/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.log.api.AppLogInfo;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.log.LogServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.xdb.XDBConfig;
import kd.fi.arapcommon.balance.BalanceRebuildService;
import kd.fi.arapcommon.helper.SettingMapperHelper;
import kd.fi.arapcommon.journal.convert.AdjExchPushJournalConverter;
import kd.fi.arapcommon.journal.convert.JournalConvertFactory;
import kd.fi.arapcommon.journal.convert.JournalConverter;
import kd.fi.arapcommon.journal.convert.SettleRecordPushJournalConverter;
import kd.fi.arapcommon.service.closerecord.CacheableCloseRecordLoader;
import kd.fi.arapcommon.util.DateUtils;

public class JournalService {
    private static Log logger = LogFactory.getLog(JournalService.class);
    private boolean isChangeRec = false;
    private static JournalConvertFactory apJournalConverterFactory;
    private static JournalConvertFactory arJournalConverterFactory;

    public JournalService() {
    }

    public JournalService(boolean isChangeRec) {
        this.isChangeRec = isChangeRec;
    }

    public void pushAndSaveJournals(DynamicObject[] sourceBills) {
        this.deleteJournals(sourceBills);
        List<DynamicObject> journals = this.pushJournals(sourceBills);
        Map<String, List<DynamicObject>> groupByJournals = journals.stream().collect(Collectors.groupingBy(journal -> journal.getDataEntityType().getName()));
        for (Map.Entry<String, List<DynamicObject>> entry : groupByJournals.entrySet()) {
            List<DynamicObject> eachTypeJournals = entry.getValue();
            String journalType = entry.getKey();
            SaveServiceHelper.save((DynamicObject[])eachTypeJournals.toArray(new DynamicObject[0]));
            this.recalculateBalance(journalType, eachTypeJournals);
        }
    }

    public List<DynamicObject> pushJournals(DynamicObject[] sourceBills) {
        if (sourceBills.length == 0 || !this.pushJournal()) {
            return new ArrayList<DynamicObject>();
        }
        String sourceBillType = sourceBills[0].getDataEntityType().getName();
        JournalConverter journalConverter = this.getConverter(sourceBillType);
        return journalConverter.convert(sourceBills);
    }

    private boolean pushJournal() {
        String pushJournal = SettingMapperHelper.getOrCreateValueFromCache("journal", "pushjournal", "true");
        return !"false".equals(pushJournal);
    }

    private void recalculateBalance(String journalType, List<DynamicObject> eachTypeJournals) {
        HashMap<Long, Date> orgDateMap = new HashMap<Long, Date>();
        boolean isAp = "ap_journal".equals(journalType);
        CacheableCloseRecordLoader cacheableCloseRecordLoader = new CacheableCloseRecordLoader(isAp);
        for (DynamicObject dynamicObject : eachTypeJournals) {
            Date recalculateDate;
            long orgId = 0L;
            Object org = dynamicObject.get("org");
            if (org instanceof Long) {
                orgId = (Long)org;
            } else if (org instanceof DynamicObject) {
                orgId = ((DynamicObject)org).getLong("id");
            }
            DynamicObject closeRecord = cacheableCloseRecordLoader.queryLastestCloseRecord(orgId);
            if (closeRecord == null) continue;
            Date closeDate = closeRecord.getDate("closedate");
            Date bizDate = dynamicObject.getDate("bizdate");
            if (bizDate == null || closeDate == null || bizDate.compareTo(closeDate = DateUtils.getDataFormat(closeDate, false)) > 0 || (recalculateDate = (Date)orgDateMap.get(orgId)) != null && bizDate.compareTo(recalculateDate) >= 0) continue;
            orgDateMap.put(orgId, bizDate);
        }
        for (Map.Entry entry : orgDateMap.entrySet()) {
            BalanceRebuildService balanceRebuildService = new BalanceRebuildService((Long)entry.getKey(), (Date)entry.getValue(), isAp ? "ap" : "ar");
            balanceRebuildService.rebuild();
        }
    }

    public void deleteJournals(String sourceBillType, Long[] sourceBillIds) {
        IDataEntityType dataEntityType;
        Object[] journals;
        List<Long[]> splitJournalIdArrays;
        DynamicObjectCollection journalList;
        boolean deleteApJournal = false;
        boolean deleteArJournal = false;
        QFilter sourceTypeFilter = new QFilter("sourcebilltype", "=", (Object)sourceBillType);
        if ("ap_settlerecord".equals(sourceBillType) || "ar_settlerecord".equals(sourceBillType)) {
            deleteApJournal = true;
            deleteArJournal = true;
            sourceTypeFilter = new QFilter("sourcebilltype", "in", (Object)new String[]{"ap_settlerecord", "ar_settlerecord"});
        } else if (sourceBillType.startsWith("ap_") || "cas_paybill".equals(sourceBillType)) {
            deleteApJournal = true;
        } else {
            deleteArJournal = true;
        }
        QFilter sourceIdFilter = new QFilter("sourcebillid", "in", (Object)sourceBillIds);
        QFilter[] deleteJournalFilters = new QFilter[]{sourceTypeFilter, sourceIdFilter};
        if (deleteApJournal) {
            journalList = QueryServiceHelper.query((String)"ap_journal", (String)"id", (QFilter[])deleteJournalFilters);
            splitJournalIdArrays = this.getBatchJournalId(journalList);
            for (Object[] objectArray : splitJournalIdArrays) {
                journals = BusinessDataServiceHelper.load((String)"ap_journal", (String)"org,bizdate,billno,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objectArray)});
                if (ObjectUtils.isEmpty((Object[])journals)) continue;
                dataEntityType = journals[0].getDataEntityType();
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])objectArray);
                this.recalculateBalance("ap_journal", Arrays.asList(journals));
            }
        }
        if (deleteArJournal) {
            if (this.isChangeRec) {
                sourceIdFilter.and("iswrittenoff", "=", (Object)Boolean.FALSE);
                sourceIdFilter.and("hadwrittenoff", "=", (Object)Boolean.FALSE);
            }
            journalList = QueryServiceHelper.query((String)"ar_journal", (String)"id", (QFilter[])deleteJournalFilters);
            splitJournalIdArrays = this.getBatchJournalId(journalList);
            for (Object[] objectArray : splitJournalIdArrays) {
                journals = BusinessDataServiceHelper.load((String)"ar_journal", (String)"org,bizdate,billno,sourcebilltype", (QFilter[])new QFilter[]{new QFilter("id", "in", (Object)objectArray)});
                if (ObjectUtils.isEmpty((Object[])journals)) continue;
                dataEntityType = journals[0].getDataEntityType();
                DeleteServiceHelper.delete((IDataEntityType)dataEntityType, (Object[])objectArray);
                this.recalculateBalance("ar_journal", Arrays.asList(journals));
            }
        }
    }

    private List<Long[]> getBatchJournalId(DynamicObjectCollection journals) {
        ArrayList<Long[]> splitJournalIdArrays = new ArrayList<Long[]>(16);
        ArrayList<Long> batchJnIds = new ArrayList<Long>(16);
        List journalIds = journals.stream().map(v -> v.getLong("id")).collect(Collectors.toList());
        for (Long id : journalIds) {
            batchJnIds.add(id);
            if (batchJnIds.size() != 5000) continue;
            splitJournalIdArrays.add(batchJnIds.toArray(new Long[0]));
            batchJnIds.clear();
        }
        if (batchJnIds.size() > 0) {
            splitJournalIdArrays.add(batchJnIds.toArray(new Long[0]));
        }
        return splitJournalIdArrays;
    }

    public void deleteJournals(DynamicObject[] sourceBills) {
        if (sourceBills.length == 0 || !this.pushJournal()) {
            return;
        }
        String sourceBillType = sourceBills[0].getDataEntityType().getName();
        Long[] sourceBillIds = Arrays.stream(sourceBills).map(bill -> bill.getLong("id")).collect(Collectors.toList()).toArray(new Long[0]);
        this.deleteJournals(sourceBillType, sourceBillIds);
    }

    public void modifyJournalDate(String sourceBillType, Long[] sourceBillIds, Date modifyDate) {
        DynamicObject[] journals;
        boolean modifyApJournal = false;
        boolean modifyArJournal = false;
        if ("ap_settlerecord".equals(sourceBillType) || "ar_settlerecord".equals(sourceBillType)) {
            modifyApJournal = true;
            modifyArJournal = true;
        } else if (sourceBillType.startsWith("ap_") || "cas_paybill".equals(sourceBillType)) {
            modifyApJournal = true;
        } else {
            modifyArJournal = true;
        }
        QFilter sourceBillTypeFilter = new QFilter("sourcebilltype", "=", (Object)sourceBillType);
        QFilter[] journalFilters = new QFilter[]{sourceBillTypeFilter, new QFilter("sourcebillid", "in", (Object)sourceBillIds)};
        if (modifyApJournal) {
            journals = BusinessDataServiceHelper.load((String)"ap_journal", (String)"bizdate", (QFilter[])journalFilters);
            this.updateBizDate(journals, modifyDate);
        }
        if (modifyArJournal) {
            journals = BusinessDataServiceHelper.load((String)"ar_journal", (String)"bizdate", (QFilter[])journalFilters);
            this.updateBizDate(journals, modifyDate);
        }
    }

    private void updateBizDate(DynamicObject[] journals, Date modifyDate) {
        if (!ObjectUtils.isEmpty((Object[])journals)) {
            boolean isXdb;
            IDataEntityType dataType = journals[0].getDataEntityType();
            boolean bl = isXdb = DB.isXDBEnable() && !ObjectUtils.isEmpty((Object)XDBConfig.getShardingConfigProvider().getConfig(dataType.getAlias()));
            if (isXdb) {
                MainEntityType dt = EntityMetadataCache.getDataEntityType((String)dataType.getName());
                CloneUtils utils = new CloneUtils(true, false);
                ArrayList<DynamicObject> journalList = new ArrayList<DynamicObject>(journals.length);
                Object[] pks = Arrays.stream(journals).map(bill -> bill.getLong("id")).collect(Collectors.toList()).toArray();
                for (DynamicObject journal : journals = BusinessDataServiceHelper.load((Object[])pks, (DynamicObjectType)dt)) {
                    DynamicObject newObj = (DynamicObject)utils.clone((IDataEntityType)dt, (Object)journal);
                    newObj.set("bizdate", (Object)modifyDate);
                    journalList.add(newObj);
                }
                try (TXHandle h = TX.requiresNew();){
                    DeleteServiceHelper.delete((IDataEntityType)dt, (Object[])pks);
                }
                h = TX.requiresNew();
                var10_15 = null;
                try {
                    SaveServiceHelper.save((DynamicObject[])journalList.toArray(new DynamicObject[0]));
                }
                catch (Throwable throwable) {
                    var10_15 = throwable;
                    throw throwable;
                }
                finally {
                    if (h != null) {
                        if (var10_15 != null) {
                            try {
                                h.close();
                            }
                            catch (Throwable throwable) {
                                var10_15.addSuppressed(throwable);
                            }
                        } else {
                            h.close();
                        }
                    }
                }
            }
            for (DynamicObject journal : journals) {
                journal.set("bizdate", (Object)modifyDate);
            }
            SaveServiceHelper.save((DynamicObject[])journals);
        }
    }

    public void pushAndSaveRedJournals(List<Long> sourceBillIds) {
        Object[] journals = this.queryJournals(sourceBillIds);
        if (ObjectUtils.isEmpty((Object[])journals)) {
            return;
        }
        List<DynamicObject> redJournals = this.pushRedJournals((DynamicObject[])journals);
        SaveServiceHelper.save((DynamicObject[])redJournals.toArray(new DynamicObject[0]));
        for (Object journal : journals) {
            journal.set("hadwrittenoff", (Object)Boolean.TRUE);
        }
        SaveServiceHelper.update((DynamicObject[])journals);
    }

    private DynamicObject[] queryJournals(List<Long> sourceBillIds) {
        QFilter sourceBillIdFilter = new QFilter("sourcebillid", "in", sourceBillIds);
        QFilter sourceBillTypeFilter = new QFilter("sourcebilltype", "=", (Object)"cas_recbill");
        QFilter isWrittenOffFilter = new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE);
        QFilter hadWrittenOffFilter = new QFilter("hadwrittenoff", "=", (Object)Boolean.FALSE);
        return BusinessDataServiceHelper.load((String)"ar_journal", (String)"id,hadwrittenoff,sourcebillid", (QFilter[])new QFilter[]{sourceBillIdFilter, sourceBillTypeFilter, isWrittenOffFilter, hadWrittenOffFilter});
    }

    private List<DynamicObject> pushRedJournals(DynamicObject[] journals) {
        return this.pushJournals(journals);
    }

    public JournalConverter getConverter(String entityKey) {
        if ("ap_settlerecord".equals(entityKey) || "ar_settlerecord".equals(entityKey)) {
            return new SettleRecordPushJournalConverter();
        }
        if ("ap_adjexchbill".equals(entityKey) || "ar_adjustexchbill".equals(entityKey)) {
            return new AdjExchPushJournalConverter();
        }
        boolean isAp = false;
        if (entityKey.startsWith("ap_") || "cas_paybill".equals(entityKey)) {
            isAp = true;
        }
        return this.getJournalConverterFactory(isAp).getConverter(entityKey);
    }

    private JournalConvertFactory getJournalConverterFactory(boolean isAp) {
        if (isAp) {
            if (apJournalConverterFactory == null) {
                try {
                    apJournalConverterFactory = (JournalConvertFactory)Class.forName("kd.fi.ap.business.journal.ApJournalConverterFactory").newInstance();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                    throw new RuntimeException(e);
                }
            }
            return apJournalConverterFactory;
        }
        if (arJournalConverterFactory == null) {
            try {
                arJournalConverterFactory = (JournalConvertFactory)Class.forName("kd.fi.ar.business.journal.ArJournalConverterFactory").newInstance();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
                throw new RuntimeException(e);
            }
        }
        return arJournalConverterFactory;
    }

    public void addAppLog(String journalType, String opName, List<DynamicObject> journals) {
        String appId = "+HKZHSKFXOX";
        if ("ar_journal".equals(journalType)) {
            appId = "/BBRH+122=39";
        }
        ArrayList<AppLogInfo> appLogInfos = new ArrayList<AppLogInfo>(journals.size());
        try {
            for (DynamicObject journal : journals) {
                AppLogInfo appLogInfo = new AppLogInfo();
                appLogInfo.setBizAppID(appId);
                appLogInfo.setBizObjID(journalType);
                appLogInfo.setOpName(opName);
                appLogInfo.setOpDescription(String.format("%s: billno\u3010%s\u3011, billtype\u3010%s\u3011", opName, journal.getString("billno"), journal.getString("sourcebilltype")));
                appLogInfos.add(appLogInfo);
            }
            LogServiceHelper.addBatchLog(appLogInfos);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
        }
    }

    public void deleteJournal4Init(boolean isAr, long orgPk, Date startDate) {
        QFilter qFilter = new QFilter("org", "=", (Object)orgPk);
        qFilter.and(new QFilter("bizdate", "<", (Object)startDate));
        DeleteServiceHelper.delete((String)(isAr ? "ar_journal" : "ap_journal"), (QFilter[])new QFilter[]{qFilter});
    }
}

