/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal.convert;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.journal.BizDescriptionEnum;
import kd.fi.arapcommon.journal.convert.BasedataBatchReader;
import kd.fi.arapcommon.journal.convert.JournalConverter;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class AdjExchPushJournalConverter
implements JournalConverter {
    private static final Log logger = LogFactory.getLog(AdjExchPushJournalConverter.class);
    private Map<String, String> bizdescMap = new HashMap<String, String>(8);
    private BasedataBatchReader basedataBatchReader = new BasedataBatchReader();

    @Override
    public List<DynamicObject> convert(DynamicObject[] sourceBills) {
        for (DynamicObject adjExchBill : sourceBills) {
            this.basedataBatchReader.addParam(adjExchBill.getString("asstacttype"), adjExchBill.get("asstact"));
        }
        ArrayList<DynamicObject> journals = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> payAdjExchBills = new ArrayList<DynamicObject>(8);
        ArrayList<DynamicObject> recAdjExchBills = new ArrayList<DynamicObject>(8);
        for (DynamicObject adjExchBill : sourceBills) {
            BigDecimal gainloss = adjExchBill.getBigDecimal("gainloss");
            if (BigDecimal.ZERO.compareTo(gainloss) == 0) continue;
            String sourceBillType = adjExchBill.getString("sourcebilltype");
            if (!"cas_paybill".equals(sourceBillType) && !"cas_recbill".equals(sourceBillType)) {
                DynamicObject journal = this.convertJournal(adjExchBill);
                journals.add(journal);
                continue;
            }
            if ("cas_paybill".equals(sourceBillType)) {
                payAdjExchBills.add(adjExchBill);
                continue;
            }
            recAdjExchBills.add(adjExchBill);
        }
        if (!payAdjExchBills.isEmpty()) {
            journals.addAll(this.convertJournalForCas(payAdjExchBills, true));
        }
        if (!recAdjExchBills.isEmpty()) {
            journals.addAll(this.convertJournalForCas(recAdjExchBills, false));
        }
        return journals;
    }

    private List<DynamicObject> convertJournalForCas(List<DynamicObject> casAdjExchBills, boolean isPay) {
        HashSet<Long> casBillIds = new HashSet<Long>(8);
        HashSet<Long> casBillEntryIds = new HashSet<Long>(8);
        for (DynamicObject casAdjExchBill : casAdjExchBills) {
            casBillIds.add(casAdjExchBill.getLong("sourcebillid"));
            DynamicObjectCollection entries = casAdjExchBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                casBillEntryIds.add(entry.getLong("e_srcentryid"));
            }
        }
        QFilter filter = new QFilter("id", "in", casBillIds);
        filter.and(new QFilter("entry.id", "in", casBillEntryIds));
        String partSettle = isPay ? "entry.e_paymenttype.ispartpayment" : "entry.e_receivingtype.ispartreceivable";
        filter.and(new QFilter(partSettle, "=", (Object)"1"));
        String selectors = isPay ? "id,entry.id,entry.e_paymenttype.biztype" : "id,entry.id,entry.e_receivingtype.biztype";
        DynamicObjectCollection datas = QueryServiceHelper.query((String)(isPay ? "cas_paybill" : "cas_recbill"), (String)selectors, (QFilter[])new QFilter[]{filter});
        HashMap<Long, String> entryIdAndBizDescription = new HashMap<Long, String>(8);
        for (DynamicObject data : datas) {
            entryIdAndBizDescription.put(data.getLong("entry.id"), this.getBizDescriptionForCas(data.getString(isPay ? "entry.e_paymenttype.biztype" : "entry.e_receivingtype.biztype"), isPay));
        }
        ArrayList<DynamicObject> journals = new ArrayList<DynamicObject>(8);
        for (DynamicObject casAdjExchBill : casAdjExchBills) {
            String bizSystem = casAdjExchBill.getString("bizsystem");
            String sourceBillType = casAdjExchBill.getString("sourcebilltype");
            String asstactType = casAdjExchBill.getString("asstacttype");
            long asstactId = casAdjExchBill.getLong("asstact");
            DynamicObject asstact = this.basedataBatchReader.read(asstactType, asstactId);
            String localAmtType = this.journalAmtBySourceBillType(sourceBillType);
            boolean isAr = this.isAr(bizSystem);
            Map<String, String> propertyMap = this.getPropertyMap(isAr ? "ar_adjustexchbill" : "ap_adjexchbill");
            DynamicObjectCollection entries = casAdjExchBill.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)(isAr ? "ar_journal" : "ap_journal"));
                journal.set("org", casAdjExchBill.get("org"));
                journal.set("bizdate", casAdjExchBill.get("bizdate"));
                journal.set("asstacttype", (Object)asstactType);
                if (asstact != null) {
                    journal.set("asstact", asstact.get("masterid"));
                } else {
                    journal.set("asstact", (Object)asstactId);
                }
                journal.set("currency", casAdjExchBill.get("currency"));
                journal.set("basecurrency", casAdjExchBill.get("basecurrency"));
                journal.set("biztype", (Object)"adjustExchange");
                journal.set("sourcebilltype", (Object)(isAr ? "ar_adjustexchbill" : "ap_adjexchbill"));
                journal.set("sourcebillid", (Object)casAdjExchBill.getLong("id"));
                journal.set("billno", casAdjExchBill.get("billno"));
                if (EmptyUtils.isNotEmpty(localAmtType)) {
                    journal.set(localAmtType, (Object)entry.getBigDecimal("e_gainloss"));
                }
                journal.set("bizdescription", entryIdAndBizDescription.get(entry.getLong("e_srcentryid")));
                List<String> journalproperties = EntityMetadataUtils.getProperties(journal);
                if (ObjectUtils.isEmpty(propertyMap)) {
                    journals.add(journal);
                    continue;
                }
                Set<Map.Entry<String, String>> properties = propertyMap.entrySet();
                for (Map.Entry<String, String> property : properties) {
                    String billField = property.getValue();
                    String journalField = property.getKey();
                    if (!this.judgeArApIsMatch(isAr, billField) && !journalproperties.contains(journalField)) continue;
                    Object billFieldValue = casAdjExchBill.get(billField);
                    if (billFieldValue instanceof DynamicObject) {
                        DynamicProperty masterIdProperty = ((DynamicObject)billFieldValue).getDynamicObjectType().getProperty("masterid");
                        long masterId = ((DynamicObject)billFieldValue).getLong(masterIdProperty == null ? "id" : "masterid");
                        journal.set(journalField, (Object)masterId);
                        continue;
                    }
                    journal.set(journalField, billFieldValue);
                }
                journals.add(journal);
            }
        }
        return journals;
    }

    private DynamicObject convertJournal(DynamicObject adjExchBill) {
        String bizSystem = adjExchBill.getString("bizsystem");
        DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)(this.isAr(bizSystem) ? "ar_journal" : "ap_journal"));
        journal.set("org", adjExchBill.get("org"));
        journal.set("bizdate", adjExchBill.get("bizdate"));
        String asstactType = adjExchBill.getString("asstacttype");
        journal.set("asstacttype", (Object)asstactType);
        long asstactId = adjExchBill.getLong("asstact");
        DynamicObject asstact = this.basedataBatchReader.read(asstactType, asstactId);
        if (asstact != null) {
            journal.set("asstact", asstact.get("masterid"));
        } else {
            journal.set("asstact", (Object)asstactId);
        }
        journal.set("currency", adjExchBill.get("currency"));
        journal.set("basecurrency", adjExchBill.get("basecurrency"));
        journal.set("biztype", (Object)"adjustExchange");
        journal.set("sourcebilltype", (Object)(this.isAr(bizSystem) ? "ar_adjustexchbill" : "ap_adjexchbill"));
        journal.set("sourcebillid", (Object)adjExchBill.getLong("id"));
        journal.set("billno", adjExchBill.get("billno"));
        String sourceBillType = adjExchBill.getString("sourcebilltype");
        String localAmtType = this.journalAmtBySourceBillType(sourceBillType);
        if (EmptyUtils.isNotEmpty(localAmtType)) {
            journal.set(localAmtType, (Object)adjExchBill.getBigDecimal("gainloss"));
        }
        journal.set("bizdescription", (Object)this.getBizDescription(sourceBillType, adjExchBill.getLong("sourcebillid")));
        List<String> journalproperties = EntityMetadataUtils.getProperties(journal);
        Map<String, String> propertyMap = this.getPropertyMap(this.isAr(bizSystem) ? "ar_adjustexchbill" : "ap_adjexchbill");
        if (ObjectUtils.isEmpty(propertyMap)) {
            return journal;
        }
        Set<Map.Entry<String, String>> properties = propertyMap.entrySet();
        for (Map.Entry<String, String> property : properties) {
            String billField = property.getValue();
            String journalField = property.getKey();
            if (!this.judgeArApIsMatch(this.isAr(bizSystem), billField) && !journalproperties.contains(journalField)) continue;
            Object billFieldValue = adjExchBill.get(billField);
            if (billFieldValue instanceof DynamicObject) {
                DynamicProperty masterIdProperty = ((DynamicObject)billFieldValue).getDynamicObjectType().getProperty("masterid");
                long masterId = ((DynamicObject)billFieldValue).getLong(masterIdProperty == null ? "id" : "masterid");
                journal.set(journalField, (Object)masterId);
                continue;
            }
            journal.set(journalField, billFieldValue);
        }
        return journal;
    }

    private String getBizDescriptionForCas(String bizType, boolean isPay) {
        if (isPay) {
            return "202".equals(bizType) ? BizDescriptionEnum.paid.name() : BizDescriptionEnum.pay.name();
        }
        return "101".equals(bizType) ? BizDescriptionEnum.received.name() : BizDescriptionEnum.rec.name();
    }

    private String getBizDescription(String sourceBillType, long sourceBillPk) {
        String bizDescription = BizDescriptionEnum.fin.name();
        if ("ap_busbill".equals(sourceBillType) || "ar_busbill".equals(sourceBillType)) {
            bizDescription = BizDescriptionEnum.bus.name();
        } else if ("cas_paybill".equals(sourceBillType) || "ap_paidbill".equals(sourceBillType)) {
            String key = sourceBillType + "_" + sourceBillPk;
            String value = this.bizdescMap.get(key);
            if (value != null) {
                bizDescription = value;
            } else {
                DynamicObject paybill = BusinessDataServiceHelper.loadSingle((String)sourceBillType, (String)"paymenttype", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillPk)});
                if (paybill != null) {
                    bizDescription = "202".equals(paybill.getString("paymenttype.biztype")) ? BizDescriptionEnum.paid.name() : BizDescriptionEnum.pay.name();
                }
                this.bizdescMap.put(key, bizDescription);
            }
        } else if ("cas_recbill".equals(sourceBillType) || "ar_receivedbill".equals(sourceBillType)) {
            String key = sourceBillType + "_" + sourceBillPk;
            String value = this.bizdescMap.get(key);
            if (value != null) {
                bizDescription = value;
            } else {
                String selector = "cas_recbill".equals(sourceBillType) ? "receivingtype" : "rectype";
                DynamicObject recbill = BusinessDataServiceHelper.loadSingle((String)sourceBillType, (String)selector, (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)sourceBillPk)});
                if (recbill != null) {
                    bizDescription = "101".equals(recbill.getString(selector + ".biztype")) ? BizDescriptionEnum.received.name() : BizDescriptionEnum.rec.name();
                }
                this.bizdescMap.put(key, bizDescription);
            }
        }
        return bizDescription;
    }

    private boolean judgeArApIsMatch(boolean isAr, String billField) {
        return isAr ? billField.endsWith("_ar") : billField.endsWith("_ap");
    }

    private Map<String, String> getPropertyMap(String Key2) {
        Map<Object, Object> PropertyMap = new HashMap(8);
        if ("ap_adjexchbill".equals(Key2)) {
            PropertyMap = BaseDataHelper.getMapperProperties(Key2);
        } else if ("ar_adjustexchbill".equals(Key2)) {
            PropertyMap = BaseDataHelper.getMapperProperties(Key2);
        } else {
            throw new IllegalArgumentException("Unknown AdjExch Type :" + Key2);
        }
        return PropertyMap;
    }

    private String journalAmtBySourceBillType(String sourceBillType) {
        String loaclAmtType = null;
        switch (sourceBillType) {
            case "ap_busbill": {
                return "localestimatedamt";
            }
            case "ar_busbill": {
                return "localestimatedamt";
            }
            case "ap_finapbill": {
                return "localpayableamt";
            }
            case "ar_finarbill": {
                return "localreceivableamt";
            }
            case "cas_paybill": {
                return "localprepaidamt";
            }
            case "cas_recbill": {
                return "localreceivedamt";
            }
            case "ap_paidbill": {
                return "localprepaidamt";
            }
            case "ar_receivedbill": {
                return "localreceivedamt";
            }
        }
        return loaclAmtType;
    }

    private boolean isAr(String bizSystem) {
        return !"AP".equals(bizSystem);
    }
}

