/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal.convert;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BaseDataHelper;
import kd.fi.arapcommon.journal.BizDescriptionEnum;
import kd.fi.arapcommon.journal.convert.BasedataBatchReader;
import kd.fi.arapcommon.journal.convert.JournalConverter;
import kd.fi.arapcommon.journal.convert.SrPushJournalSetting;
import kd.fi.arapcommon.journal.convert.SrPushJournalSettingFactory;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class SettleRecordPushJournalConverter
implements JournalConverter {
    private Map<String, String> arPropertyMap;
    private Map<String, String> apPropertyMap;
    private Set<String> apJournalFields;
    private Set<String> arJournalFields;
    private BasedataBatchReader basedataBatchReader = new BasedataBatchReader();
    private Map<String, String> bizdescMap = new HashMap<String, String>(8);

    @Override
    public List<DynamicObject> convert(DynamicObject[] sourceBills) {
        for (DynamicObject settleRecord : sourceBills) {
            this.basedataBatchReader.addParam(settleRecord.getString("mainasstacttype"), settleRecord.get("mainasstactid"));
            DynamicObjectCollection entry = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                this.basedataBatchReader.addParam(row.getString("asstacttype"), row.get("asstactid"));
            }
        }
        ArrayList<DynamicObject> journals = new ArrayList<DynamicObject>(2);
        for (DynamicObject settleRecord : sourceBills) {
            DynamicObject mainJournal = this.mainBillConvert(settleRecord);
            if (mainJournal != null) {
                journals.add(mainJournal);
            }
            DynamicObjectCollection entry = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                DynamicObject asstactJournal = this.asstactBillConvert(settleRecord, row);
                if (asstactJournal == null) continue;
                journals.add(asstactJournal);
            }
        }
        return journals;
    }

    private DynamicObject mainBillConvert(DynamicObject settleRecord) {
        SettleRelationEnum settleRelation = this.getSettleRelation(settleRecord);
        SrPushJournalSetting setting = SrPushJournalSettingFactory.getSetting(settleRelation);
        String journalType = setting.getMainJournalType();
        if (journalType == null) {
            return null;
        }
        DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)journalType);
        journal.set("org", settleRecord.get("org.id"));
        journal.set("bizdate", settleRecord.get("settledate"));
        String mainAsstactType = settleRecord.getString("mainasstacttype");
        journal.set("asstacttype", (Object)mainAsstactType);
        Long mainAsstactId = settleRecord.getLong("mainasstactid.id");
        DynamicObject asstact = this.basedataBatchReader.read(mainAsstactType, mainAsstactId);
        if (asstact != null) {
            journal.set("asstact", asstact.get("masterid"));
        } else {
            journal.set("asstact", (Object)mainAsstactId);
        }
        journal.set("currency", settleRecord.get("maincurrency"));
        journal.set("basecurrency", settleRecord.get("basecurrency"));
        journal.set("biztype", (Object)settleRecord.getString("settlerelation"));
        String settleRecordType = this.getSettleRecordType(settleRelation);
        journal.set("sourcebilltype", (Object)settleRecordType);
        journal.set("sourcebillid", (Object)settleRecord.getLong("id"));
        journal.set("billno", (Object)settleRecord.getString("billno"));
        journal.set(setting.getMainAmountType().getAmtKey(), (Object)settleRecord.getBigDecimal("totalsettleamt").negate());
        journal.set(setting.getMainAmountType().getLocalAmtKey(), (Object)settleRecord.getBigDecimal("localtotalsettleamt").negate());
        journal.set("bizdescription", (Object)this.getBizDescription(settleRecord.getString("billentity"), settleRecord.get("mainbillentryid")));
        Map<String, String> propertyMap = this.getPropertyMap(settleRecordType);
        if (propertyMap.isEmpty()) {
            return journal;
        }
        Set<Map.Entry<String, String>> properties = propertyMap.entrySet();
        for (Map.Entry<String, String> property : properties) {
            String billField = property.getValue();
            String journalField = property.getKey();
            Object billFieldValue = settleRecord.get(billField);
            if (billFieldValue instanceof DynamicObject) {
                DynamicProperty masterIdProperty = ((DynamicObject)billFieldValue).getDynamicObjectType().getProperty("masterid");
                long masterId = ((DynamicObject)billFieldValue).getLong(masterIdProperty == null ? "id" : "masterid");
                journal.set(journalField, (Object)masterId);
                continue;
            }
            journal.set(journalField, billFieldValue);
        }
        return journal;
    }

    private String getBizDescription(String billEntity, Object entryPk) {
        String bizDescription = BizDescriptionEnum.fin_woff.name();
        if ("cas_paybill".equals(billEntity) || "ap_paidbill".equals(billEntity)) {
            String key = billEntity + "_" + String.valueOf(entryPk);
            String value = this.bizdescMap.get(key);
            if (value != null) {
                bizDescription = value;
            } else {
                String selector = "cas_paybill".equals(billEntity) ? "entry.e_paymenttype.biztype" : "paymenttype.biztype";
                DynamicObjectCollection paybill = QueryServiceHelper.query((String)billEntity, (String)selector, (QFilter[])new QFilter[]{new QFilter("entry.id", "=", entryPk)});
                if (paybill != null) {
                    bizDescription = "202".equals(((DynamicObject)paybill.get(0)).getString(selector)) ? BizDescriptionEnum.paid_woff.name() : BizDescriptionEnum.pay_woff.name();
                }
                this.bizdescMap.put(key, bizDescription);
            }
        } else if ("cas_recbill".equals(billEntity) || "ar_receivedbill".equals(billEntity)) {
            String key = billEntity + "_" + String.valueOf(entryPk);
            String value = this.bizdescMap.get(key);
            if (value != null) {
                bizDescription = value;
            } else {
                String selector = "cas_recbill".equals(billEntity) ? "entry.e_receivingtype.biztype" : "rectype.biztype";
                DynamicObjectCollection recbill = QueryServiceHelper.query((String)billEntity, (String)selector, (QFilter[])new QFilter[]{new QFilter("entry.id", "=", entryPk)});
                if (recbill != null) {
                    bizDescription = "101".equals(((DynamicObject)recbill.get(0)).getString(selector)) ? BizDescriptionEnum.received_woff.name() : BizDescriptionEnum.rec_woff.name();
                }
                this.bizdescMap.put(key, bizDescription);
            }
        }
        return bizDescription;
    }

    private DynamicObject asstactBillConvert(DynamicObject settleRecord, DynamicObject row) {
        SettleRelationEnum settleRelation = this.getSettleRelation(settleRecord);
        SrPushJournalSetting setting = SrPushJournalSettingFactory.getSetting(settleRelation);
        String journalType = setting.getAsstJournalType();
        if (setting.getAsstJournalType() == null) {
            return null;
        }
        DynamicObject journal = BusinessDataServiceHelper.newDynamicObject((String)journalType);
        journal.set("org", settleRecord.get("org.id"));
        journal.set("bizdate", settleRecord.get("settledate"));
        String asstactType = row.getString("asstacttype");
        journal.set("asstacttype", (Object)asstactType);
        Object asstactId = row.get("asstactid.id");
        DynamicObject asstact = this.basedataBatchReader.read(asstactType, asstactId);
        if (asstact != null) {
            journal.set("asstact", asstact.get("masterid"));
        } else {
            journal.set("asstact", asstactId);
        }
        journal.set("currency", row.get("currency"));
        journal.set("basecurrency", settleRecord.get("basecurrency"));
        journal.set("biztype", (Object)settleRecord.getString("settlerelation"));
        String settleRecordType = this.getSettleRecordType(settleRelation);
        journal.set("sourcebilltype", (Object)settleRecordType);
        journal.set("sourcebillid", (Object)settleRecord.getLong("id"));
        journal.set(setting.getAsstAmountType().getAmtKey(), (Object)row.getBigDecimal("settleamt").negate());
        journal.set(setting.getAsstAmountType().getLocalAmtKey(), (Object)row.getBigDecimal("localsettleamt").negate());
        journal.set("sourceentryid", (Object)row.getLong("id"));
        journal.set("billno", (Object)row.getString("billnum"));
        journal.set("bizdescription", (Object)this.getBizDescription(row.getString("e_billentity"), row.getLong("billentryid")));
        Map<String, String> propertyMap = this.getPropertyMap(settleRecordType);
        if (propertyMap.isEmpty()) {
            return journal;
        }
        Map<String, String> standardMapper = this.getStandardMapper();
        Set<Map.Entry<String, String>> properties = propertyMap.entrySet();
        for (Map.Entry<String, String> property : properties) {
            Object billFieldValue;
            String billField = property.getValue();
            String journalField = property.getKey();
            String entryField = standardMapper.get(billField);
            Object object = billFieldValue = entryField == null ? row.get("e_" + billField) : row.get(entryField);
            if (billFieldValue instanceof DynamicObject) {
                DynamicProperty masterIdProperty = ((DynamicObject)billFieldValue).getDynamicObjectType().getProperty("masterid");
                long masterId = ((DynamicObject)billFieldValue).getLong(masterIdProperty == null ? "id" : "masterid");
                journal.set(journalField, (Object)masterId);
                continue;
            }
            journal.set(journalField, billFieldValue);
        }
        return journal;
    }

    private Map<String, String> getStandardMapper() {
        HashMap<String, String> mapper = new HashMap<String, String>(2);
        mapper.put("mainbilltype", "billtype");
        return mapper;
    }

    private SettleRelationEnum getSettleRelation(DynamicObject settleRecord) {
        SettleRelationEnum[] values;
        for (SettleRelationEnum v : values = SettleRelationEnum.values()) {
            if (!v.getValue().equals(settleRecord.getString("settlerelation"))) continue;
            return v;
        }
        return null;
    }

    private String getSettleRecordType(SettleRelationEnum settleRelation) {
        String settleRecordType = "ar_settlerecord";
        if (settleRelation != null && settleRelation.isAp()) {
            settleRecordType = "ap_settlerecord";
        }
        return settleRecordType;
    }

    private Map<String, String> getPropertyMap(String settleRecordKey) {
        if ("ap_settlerecord".equals(settleRecordKey)) {
            if (this.apPropertyMap == null) {
                this.apPropertyMap = BaseDataHelper.getMapperProperties(settleRecordKey);
            }
            return this.apPropertyMap;
        }
        if ("ar_settlerecord".equals(settleRecordKey)) {
            if (this.arPropertyMap == null) {
                this.arPropertyMap = BaseDataHelper.getMapperProperties(settleRecordKey);
            }
            return this.arPropertyMap;
        }
        throw new IllegalArgumentException("Unknown Settle Record Type :" + settleRecordKey);
    }

    private Set<String> getAllJournalFields(String journalType) {
        if ("ap_journal".equals(journalType)) {
            if (this.apJournalFields == null) {
                List<IDataEntityProperty> properties = EntityMetadataUtils.getProperties(journalType);
                this.apJournalFields = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
            }
            return this.apJournalFields;
        }
        if ("ar_journal".equals(journalType)) {
            if (this.arJournalFields == null) {
                List<IDataEntityProperty> properties = EntityMetadataUtils.getProperties(journalType);
                this.arJournalFields = properties.stream().map(IMetadata::getName).collect(Collectors.toSet());
            }
            return this.arJournalFields;
        }
        throw new IllegalArgumentException("Unknown journal type:" + journalType);
    }
}

