/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal.service;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.journal.service.CommonjournalSelectService;
import kd.fi.arapcommon.vo.ErrCheckVo;

public class CasBillSelectService
extends CommonjournalSelectService {
    public CasBillSelectService(boolean isAr) {
        super(isAr);
    }

    @Override
    public QFilter getFilter(Set<Long> orgIds, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("bizdate", ">=", (Object)beginDate);
        filter.and("bizdate", "<=", (Object)endDate);
        if (this.isAr) {
            filter.and("receivingtype.ispartreceivable", "=", (Object)Boolean.TRUE);
            filter.and("entry.e_settleorg.id", "in", orgIds);
            filter.and("billstatus", "=", (Object)"D");
        } else {
            filter.and("paymenttype.ispartpayment", "=", (Object)Boolean.TRUE);
            filter.and("entry.settleorg.id", "in", orgIds);
            filter.and("billstatus", "in", (Object)new String[]{"D", "F", "I"});
        }
        return filter;
    }

    public Set<ErrCheckVo> getNoJournalBills(QFilter filter, String key) {
        DynamicObjectCollection casBills = QueryServiceHelper.query((String)key, (String)"id,billno", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        Set casIds = casBills.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        if ("cas_recbill".equals(key)) {
            DynamicObjectCollection casRecChangBills = QueryServiceHelper.query((String)"cas_recchgbill", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", casIds)});
            Set casChangIds = casRecChangBills.stream().map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
            casIds.removeAll(casChangIds);
        }
        DynamicObjectCollection journals = QueryServiceHelper.query((String)this.journalEntity, (String)"id,billno,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", casIds)});
        Set journalIds = journals.stream().map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
        casIds.removeAll(journalIds);
        Set warnCasBills = casBills.stream().filter(t -> casIds.contains(t.getLong("id"))).collect(Collectors.toSet());
        HashSet<ErrCheckVo> errCheckVoSet = new HashSet<ErrCheckVo>(16);
        for (DynamicObject warnBill : warnCasBills) {
            errCheckVoSet.add(this.setErrVo(warnBill, key));
        }
        return errCheckVoSet;
    }

    @Override
    public Set<ErrCheckVo> setRepJournal(DynamicObjectCollection journals, String journalEntity) {
        HashSet<Long> casIds = new HashSet<Long>(16);
        HashSet<Long> srcBillIds = new HashSet<Long>(16);
        for (DynamicObject journal : journals) {
            String srceBillType = journal.getString("sourcebilltype");
            Long casBillId = journal.getLong("sourcebillid");
            if ("cas_recbill".equals(srceBillType)) {
                casIds.add(casBillId);
            }
            srcBillIds.add(casBillId);
        }
        if (casIds.size() > 0) {
            DynamicObjectCollection casRecChangBills = QueryServiceHelper.query((String)"cas_recchgbill", (String)"sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", casIds)});
            Set casChangIds = casRecChangBills.stream().map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
            srcBillIds.removeAll(casChangIds);
        }
        List compJournals = journals.stream().filter(t -> srcBillIds.contains(t.getLong("sourcebillid"))).collect(Collectors.toList());
        return super.setRepJournal(new DynamicObjectCollection(((DynamicObject)journals.get(0)).getDynamicObjectType(), compJournals), journalEntity);
    }
}

