/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.journal.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.journal.service.IBillSelectJournal;
import kd.fi.arapcommon.vo.ErrCheckVo;

public class CommonjournalSelectService
implements IBillSelectJournal {
    private static final int BATCHQUERYCOUNT = 10000;
    protected boolean isAr;
    protected String journalEntity;

    public CommonjournalSelectService(boolean isAr) {
        this.isAr = isAr;
        this.journalEntity = isAr ? "ar_journal" : "ap_journal";
    }

    @Override
    public QFilter getFilter(Set<Long> orgIds, Date beginDate, Date endDate) {
        QFilter filter = new QFilter("org", "in", orgIds);
        filter.and("bizdate", ">=", (Object)beginDate);
        filter.and("bizdate", "<=", (Object)endDate);
        filter.and("billstatus", "=", (Object)"C");
        return filter;
    }

    @Override
    public Set<ErrCheckVo> BatchSelectBills(QFilter filter, String key) {
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"CommonjournalSelectService-query", (String)key, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"id");
        ArrayList<Long> idList = new ArrayList<Long>(100);
        HashSet<ErrCheckVo> ErrorEntry = new HashSet<ErrCheckVo>(64);
        for (Row row : dataSet) {
            idList.add(row.getLong("id"));
            if (idList.size() != 10000) continue;
            ErrorEntry.addAll(this.getNoJournalBills(idList, key));
            idList.clear();
        }
        if (!idList.isEmpty()) {
            ErrorEntry.addAll(this.getNoJournalBills(idList, key));
        }
        return ErrorEntry;
    }

    @Override
    public Set<ErrCheckVo> BatchSelectJournals(Set<Long> orgIds, Date beginDate, Date endDate, String key) {
        QFilter filter = new QFilter("org.id", "in", orgIds).and("bizdate", ">=", (Object)beginDate).and("bizdate", "<=", (Object)endDate).and("sourcebilltype", "=", (Object)key);
        DataSet dataSet = QueryServiceHelper.queryDataSet((String)"JournalCheckEdit-query", (String)this.journalEntity, (String)"id", (QFilter[])new QFilter[]{filter}, (String)"bizdate");
        HashSet<ErrCheckVo> ErrorEntry = new HashSet<ErrCheckVo>(64);
        if (!dataSet.isEmpty()) {
            ArrayList<Long> idList = new ArrayList<Long>(16);
            for (Row row : dataSet) {
                idList.add(row.getLong("id"));
                if (idList.size() != 10000) continue;
                DynamicObjectCollection journals = QueryServiceHelper.query((String)this.journalEntity, (String)"id,billno,sourcebillid,sourcebilltype,sourceentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)"bizdate");
                ErrorEntry.addAll(this.setRepJournal(journals, this.journalEntity));
                ErrorEntry.addAll(this.setNoBillJournal(journals, this.journalEntity));
                idList.clear();
            }
            if (!idList.isEmpty()) {
                DynamicObjectCollection journals = QueryServiceHelper.query((String)this.journalEntity, (String)"id,billno,sourcebillid,sourcebilltype,sourceentryid", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)}, (String)"bizdate");
                ErrorEntry.addAll(this.setRepJournal(journals, this.journalEntity));
                ErrorEntry.addAll(this.setNoBillJournal(journals, this.journalEntity));
            }
        }
        return ErrorEntry;
    }

    public Set<ErrCheckVo> setRepJournal(DynamicObjectCollection journals, String journalEntity) {
        HashMap<String, DynamicObject> errorMap = new HashMap<String, DynamicObject>(8);
        HashSet<ErrCheckVo> errCheckVoSet = new HashSet<ErrCheckVo>(16);
        for (DynamicObject journal : journals) {
            Long srcBillId = journal.getLong("sourcebillid");
            Long srcBillEntryId = journal.getLong("sourceentryid");
            String errorBillKey = srcBillId + "_" + srcBillEntryId;
            if (errorMap.get(errorBillKey) == null) {
                errorMap.put(errorBillKey, journal);
                continue;
            }
            errCheckVoSet.add(this.setErrByItem(journal, "doublejournal"));
        }
        return errCheckVoSet;
    }

    public Set<ErrCheckVo> setNoBillJournal(DynamicObjectCollection journals, String journalEntity) {
        HashSet notExistIds = new HashSet(10);
        Map<String, List<DynamicObject>> recordEntryMap = journals.stream().collect(Collectors.groupingBy(bill -> bill.getString("sourcebilltype")));
        for (Map.Entry<String, List<DynamicObject>> groupBill : recordEntryMap.entrySet()) {
            String key = groupBill.getKey();
            List<DynamicObject> groupJournals = groupBill.getValue();
            Set srcBillIds = groupJournals.stream().map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
            DynamicObjectCollection srcBills = QueryServiceHelper.query((String)key, (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
            Set existIds = srcBills.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
            srcBillIds.removeAll(existIds);
            notExistIds.addAll(srcBillIds);
        }
        HashSet<ErrCheckVo> errCheckVoSet = new HashSet<ErrCheckVo>(16);
        for (DynamicObject journal : journals) {
            Long srcBillId = journal.getLong("sourcebillid");
            Long srcBillEnytyId = journal.getLong("sourceentryid");
            if (!notExistIds.contains(srcBillId) && !notExistIds.contains(srcBillEnytyId)) continue;
            errCheckVoSet.add(this.setErrByItem(journal, "notbilljournal"));
        }
        return errCheckVoSet;
    }

    public Set<ErrCheckVo> getNoJournalBills(List<Long> idList, String key) {
        DynamicObjectCollection finBills = QueryServiceHelper.query((String)key, (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", idList)});
        Set finIds = finBills.stream().map(t -> t.getLong("id")).collect(Collectors.toSet());
        DynamicObjectCollection journals = QueryServiceHelper.query((String)this.journalEntity, (String)"id,billno,sourcebillid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", finIds)});
        Set journalIds = journals.stream().map(t -> t.getLong("sourcebillid")).collect(Collectors.toSet());
        finIds.removeAll(journalIds);
        Set warnFinBills = finBills.stream().filter(t -> finIds.contains(t.getLong("id"))).collect(Collectors.toSet());
        HashSet<ErrCheckVo> errCheckVoSet = new HashSet<ErrCheckVo>(16);
        for (DynamicObject warnBill : warnFinBills) {
            errCheckVoSet.add(this.setErrVo(warnBill, key));
        }
        return errCheckVoSet;
    }

    protected ErrCheckVo setErrByItem(DynamicObject journal, String item) {
        ErrCheckVo errVo = new ErrCheckVo();
        errVo.setBillid(journal.getLong("sourcebillid"));
        errVo.setBillno(journal.getString("billno"));
        errVo.setCheckitem(item);
        errVo.setJournalid(journal.getLong("id"));
        errVo.setSourcebill(this.journalEntity);
        return errVo;
    }

    protected ErrCheckVo setErrVo(DynamicObject warnBill, String entity) {
        ErrCheckVo errVo = new ErrCheckVo();
        errVo.setBillid(warnBill.getLong("id"));
        errVo.setBillno(warnBill.getString("billno"));
        errVo.setCheckitem("journalbill");
        errVo.setSourcebill(entity);
        return errVo;
    }
}

