/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.openapi;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.openapi.CustomImportAsyncExecutor;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;

public class CustomImportApiService {
    private static ThreadPool pools = ThreadPools.newFixedThreadPool((String)"CustomImportApiService", (int)10);

    public void customImport(String entityKey, Map<String, Object> data) {
        LinkedList<AsyncTx> txs = new LinkedList<AsyncTx>();
        if (data.get("data") != null) {
            txs.add(this.transToTx(entityKey, (Map)data.get("data")));
        } else if (data.get("datas") != null) {
            List object = (List)data.get("datas");
            for (Map each : object) {
                txs.add(this.transToTx(entityKey, each));
            }
        }
        TXHandle tx = TX.required();
        Object object = null;
        try {
            try {
                AsyncTxService asyncTxService = new AsyncTxService();
                asyncTxService.save(txs.toArray(new AsyncTx[0]));
            }
            catch (Exception e) {
                tx.markRollback();
                if (e instanceof RuntimeException) {
                    throw e;
                }
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (tx != null) {
                if (object != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    tx.close();
                }
            }
        }
        for (AsyncTx tx2 : txs) {
            this.runtimeAsyncExecute(tx2);
        }
    }

    private AsyncTx transToTx(String entityKey, Map<String, Object> data) {
        AsyncTx asyncTx = new AsyncTx();
        asyncTx.setGroup(entityKey);
        asyncTx.setAction("custom-import");
        asyncTx.setTask("default");
        asyncTx.setXid((String)data.get("billno"));
        HashMap<String, Map<String, Object>> dataWapper = new HashMap<String, Map<String, Object>>();
        dataWapper.put("data", data);
        asyncTx.setParam(dataWapper);
        asyncTx.setExecuteClass(CustomImportAsyncExecutor.class.getName());
        return asyncTx;
    }

    private void runtimeAsyncExecute(AsyncTx asyncTx) {
        AsyncTxService asyncTxService = new AsyncTxService();
        pools.executeIncludeRequestContext(() -> {
            try (TXHandle tx = TX.requiresNew();){
                try {
                    asyncTxService.execute(asyncTx);
                    asyncTxService.handleSuccess(asyncTx);
                }
                catch (Exception e) {
                    tx.markRollback();
                    try (TXHandle errorRecordTx = TX.requiresNew();){
                        asyncTxService.handleException(asyncTx, e);
                    }
                }
            }
        });
    }
}

