/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.service.adjustexch.AdjustExchangeService;
import kd.fi.arapcommon.validator.AdjExchOpValidator;
import kd.fi.arapcommon.vo.adjexch.AdjustExchangeResult;

public class AdjExchBaseOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizsystem");
        fieldKeys.add("org");
        fieldKeys.add("isperiod");
        fieldKeys.add("period");
        fieldKeys.add("isadjexch");
        fieldKeys.add("gainloss");
        fieldKeys.add("basecurrency");
        fieldKeys.add("adjexchmode");
        fieldKeys.add("adjexchdate");
        fieldKeys.add("id");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new AdjExchOpValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        AdjustExchangeService service = new AdjustExchangeService();
        String opKey = e.getOperationKey();
        boolean isAr = "aradjexchop".equalsIgnoreCase(opKey);
        ArrayList<DynamicObject> records = new ArrayList<DynamicObject>(8);
        for (DynamicObject data : e.getDataEntities()) {
            Long adjExchPeriodId;
            boolean isPeriod;
            long orgPk;
            String bizSystem = data.getString("bizsystem");
            AdjustExchangeResult adjustExchangeResult = service.adjustExchange(bizSystem, orgPk = data.getLong("org.id"), isPeriod = data.getBoolean("isperiod"), adjExchPeriodId = Long.valueOf(data.getLong("period.id")), new HashMap<String, BigDecimal>(8), new HashMap<String, String>(8));
            if (!adjustExchangeResult.isSuccess()) continue;
            data.set("adjexchdate", (Object)new Date());
            data.set("isadjexch", (Object)Boolean.TRUE);
            data.set("gainloss", (Object)adjustExchangeResult.getTotalgainloss());
            data.set("adjexchmode", (Object)"realtime");
            records.add(data);
        }
        OperationServiceHelper.executeOperate((String)"save", (String)(isAr ? "ar_adjustexch" : "ap_adjustexch"), (DynamicObject[])records.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
    }
}

