/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.TypesContainer;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.enums.UpgradeExecuteStatusEnum;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.service.upgrade.IUpgradeHandle;
import kd.fi.arapcommon.vo.UpgradeConfigVO;

public class ArApExecuteUpgradeOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(ArApExecuteUpgradeOp.class);

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        ArrayList<UpgradeConfigVO> upgradeConfigVOS = new ArrayList<UpgradeConfigVO>(dataEntities.length);
        long upgradeEntryId = Long.parseLong(this.getOption().getVariableValue("upgradeentryid", "0"));
        String isUpgradeTask = this.getOption().getVariableValue("isupgradetask", "false");
        for (DynamicObject config : dataEntities) {
            String executeStatus = config.getString("executestatus");
            if (!"C".equals(config.getString("billstatus")) || !UpgradeExecuteStatusEnum.WAIT.getValue().equals(executeStatus) && !UpgradeExecuteStatusEnum.FAILED.getValue().equals(executeStatus)) continue;
            String entityName = config.getString("bizobj.number");
            String plugin = config.getString("plugin");
            int intervalDays = config.getInt("intervaldays");
            DynamicObjectCollection entryEntity = config.getDynamicObjectCollection("entryentity");
            for (DynamicObject executeResult : entryEntity) {
                String eExecuteStatus = executeResult.getString("e_executestatus");
                if (UpgradeExecuteStatusEnum.DONE.getValue().equals(eExecuteStatus)) continue;
                int eExecuteTimes = executeResult.getInt("e_executetimes");
                if (!(UpgradeExecuteStatusEnum.FAILED.getValue().equals(eExecuteStatus) && "true".equals(isUpgradeTask) && eExecuteTimes <= 2 || upgradeEntryId != 0L && executeResult.getLong("id") == upgradeEntryId) && (upgradeEntryId != 0L || !"false".equals(isUpgradeTask))) continue;
                UpgradeConfigVO upgradeConfigVO = new UpgradeConfigVO();
                upgradeConfigVO.setBillId(config.getLong("id"));
                upgradeConfigVO.setEntryId(executeResult.getLong("id"));
                upgradeConfigVO.setDataStartDate(executeResult.getDate("e_datastartdate"));
                upgradeConfigVO.setDataEndTime(executeResult.getDate("e_dataenddate"));
                upgradeConfigVO.setBizObj(entityName);
                upgradeConfigVO.setIntervalDays(intervalDays);
                upgradeConfigVO.setPlugin(plugin);
                upgradeConfigVO.setCreateUpgradeTask(false);
                if (executeResult.getDate("e_dataenddate") == null) {
                    upgradeConfigVO.setFirst(true);
                }
                upgradeConfigVOS.add(upgradeConfigVO);
            }
            if (upgradeEntryId != 0L || !UpgradeExecuteStatusEnum.WAIT.getValue().equals(executeStatus)) continue;
            Date dataEndTime = config.getDate("dataendtime");
            UpgradeConfigVO upgradeConfigVO = new UpgradeConfigVO();
            upgradeConfigVO.setBillId(config.getLong("id"));
            upgradeConfigVO.setDataStartDate(config.getDate("datastarttime"));
            upgradeConfigVO.setDataEndTime(dataEndTime == null ? new Date() : dataEndTime);
            upgradeConfigVO.setBizObj(entityName);
            upgradeConfigVO.setIntervalDays(intervalDays);
            upgradeConfigVO.setPlugin(plugin);
            upgradeConfigVO.setFirst(dataEndTime == null);
            upgradeConfigVO.setCreateUpgradeTask(false);
            upgradeConfigVOS.add(upgradeConfigVO);
        }
        if (!upgradeConfigVOS.isEmpty()) {
            for (UpgradeConfigVO configVO : upgradeConfigVOS) {
                try {
                    IUpgradeHandle upgradeService = (IUpgradeHandle)TypesContainer.createInstance((String)configVO.getPlugin());
                    upgradeService.batchExecute(configVO);
                }
                catch (Exception e1) {
                    logger.info("ArApExecuteUpgradeOp execute error :" + ArApHelper.getStackTraceMessage(e1));
                    logger.info("UpgradeConfigVO error message : " + configVO);
                }
            }
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("executestatus");
        fieldKeys.add("datastarttime");
        fieldKeys.add("dataendtime");
        fieldKeys.add("plugin");
        fieldKeys.add("intervaldays");
        fieldKeys.add("bizobj");
        fieldKeys.add("billstatus");
        fieldKeys.add("isdefault");
        fieldKeys.add("entryentity.e_executestatus");
        fieldKeys.add("entryentity.e_datastartdate");
        fieldKeys.add("entryentity.e_dataenddate");
        fieldKeys.add("entryentity.e_executetimes");
    }
}

