/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class BusArBillInvoicedQtyUpgradeOp
extends AbstractOperationServicePlugIn {
    private static final int MAX_PROCESSENTRYNUMBER = 20000;
    private static final Log logger = LogFactory.getLog(BusArBillInvoicedQtyUpgradeOp.class);

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        try {
            String upgradeDateStr = StdConfig.get("businvupgradeDate");
            if (upgradeDateStr == null) {
                return;
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date upgradeDate = sdf.parse(upgradeDateStr);
            if (upgradeDate == null) {
                return;
            }
            Date beginDate = DateUtils.getNextDay(new Date(), -180);
            this.upgradeBusBillInvoiceQty(beginDate);
        }
        catch (ParseException p) {
            logger.info("message", (Object)p.getMessage());
        }
    }

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List props = e.getFieldKeys();
        props.add("payproperty.isbasedonamt");
        props.add("entry.e_amount");
        props.add("entry.e_invoicednotaxamt");
        props.add("entry.e_invoicedqty");
        props.add("entry.e_uninvoicedqty");
    }

    private void upgradeBusBillInvoiceQty(Date date) {
        ArrayList<Date> queryArgs = new ArrayList<Date>(2);
        queryArgs.add(date);
        String isbasedonamtBusSql = "select a.fid from t_ar_busbill a,t_ar_payproperty b where a.fpaypropertyid = b.fid and a.fbizdate > ? and b.fisbasedonamt = '1'";
        HashSet<Long> busIds = new HashSet<Long>(2);
        DataSet isbasedonamtBus = DB.queryDataSet((String)"BusArBillInvoicedQtyUpgradeOp", (DBRoute)DBRoute.of((String)"ar"), (String)isbasedonamtBusSql, (Object[])queryArgs.toArray());
        for (Row busRow : isbasedonamtBus) {
            busIds.add(busRow.getLong("fid"));
            if (busIds.size() != 20000) continue;
            this.upDateAmtBaseInvoiceQty(busIds);
            busIds.clear();
        }
        if (busIds.size() > 0) {
            this.upDateAmtBaseInvoiceQty(busIds);
            busIds.clear();
        }
    }

    private void upDateAmtBaseInvoiceQty(Set<Long> busIds) {
        String invoiceQtySql = "select a.fentryid,a.famount,b.finvoicednotaxamt from t_ar_busbillentry a,t_ar_busbillentry_e b where a.fentryid = b.fentryid and a.fid in" + StringUtils.setToString(busIds);
        DataSet needUpdateEntryIds = DB.queryDataSet((String)"BusArBillInvoicedQtyUpgradeOp", (DBRoute)DBRoute.of((String)"ar"), (String)invoiceQtySql);
        ArrayList<Long> busEntryIds = new ArrayList<Long>(2);
        ArrayList<Object[]> updateFinBillParams = new ArrayList<Object[]>(2);
        for (Row entry : needUpdateEntryIds) {
            BigDecimal amount = entry.getBigDecimal("famount");
            BigDecimal invamt = entry.getBigDecimal("finvoicednotaxamt");
            if (amount == null || invamt == null || amount.compareTo(BigDecimal.ZERO) * invamt.compareTo(BigDecimal.ZERO) < 0 || amount.abs().compareTo(invamt.abs()) <= 0) continue;
            busEntryIds.add(entry.getLong("fentryid"));
        }
        for (Long entryId : busEntryIds) {
            Object[] param = new Object[]{entryId};
            updateFinBillParams.add(param);
        }
        if (updateFinBillParams.size() == 0) {
            return;
        }
        String updateSql = "update t_ar_busbillentry set finvoicedqty = 0,funinvoicedqty = 1 where fentryid = ?";
        DB.executeBatch((DBRoute)new DBRoute("ar"), (String)updateSql, updateFinBillParams);
    }
}

