/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;
import kd.fi.arapcommon.opplugin.BusBillBatchWoffValidator;
import kd.fi.arapcommon.opplugin.BusBillWoffRevaluaTionValidator;

public class BusBillBatchWoffOp
extends ArapBaseOp {
    private String busEntityKey;

    @Override
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator((AbstractValidator)new BusBillBatchWoffValidator());
        e.addValidator((AbstractValidator)new BusBillWoffRevaluaTionValidator());
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        String entityName;
        HashMap<String, String> paramMap;
        DynamicObject[] dataEntities = e.getDataEntities();
        List<Long> ids = Arrays.stream(dataEntities).map(v -> v.getLong("id")).collect(Collectors.toList());
        this.busEntityKey = dataEntities[0].getDataEntityType().getName();
        boolean isAr = false;
        if (this.busEntityKey.startsWith("ar")) {
            isAr = true;
        }
        if ((paramMap = this.getOption().getVariables()) == null) {
            paramMap = new HashMap<String, String>(2);
        }
        if ((entityName = (String)paramMap.get("entity")) != null) {
            paramMap.put("woffmode", "batch");
        } else {
            entityName = this.busEntityKey;
        }
        paramMap.put("isselfwoff", "true");
        Map<String, Object> resultMap = BOTPHelper.push4Result(this.busEntityKey, this.busEntityKey, isAr ? "697561685841434624" : "712748085842822144", ids, paramMap);
        Object convertResult = resultMap.get("convertResult");
        if (convertResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertResult;
            ErrorCode ec = new ErrorCode("botp", result.getMessage());
            throw new KDBizException(ec, new Object[0]);
        }
        List woffBills = (List)resultMap.get("trgBills");
        if (woffBills.isEmpty()) {
            return;
        }
        for (DynamicObject trgBusBill : woffBills) {
            trgBusBill.set("isselfwoff", (Object)Boolean.TRUE);
        }
        this.doOperation(entityName, woffBills);
    }

    private void doOperation(String entityName, List<DynamicObject> woffBills) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])woffBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(result);
    }

    @Override
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        List lst = e.getFieldKeys();
        lst.add("org");
        lst.add("e_uninvoicedamt");
        lst.add("e_uninvoicedqty");
        lst.add("e_taxrate");
        lst.add("e_iswriteoff");
        lst.add("isrevaluation");
        lst.add("sourcebillid");
        lst.add("hadrevaluation");
    }
}

