/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.fin.FinWoffService;
import kd.fi.arapcommon.util.StdConfig;

public class BusBillSave4WoffOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(FinWoffService.class);
    private boolean fastAudit;

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        ArrayList<DynamicObject> selfWoffBills = new ArrayList<DynamicObject>(e.getDataEntities().length);
        DynamicObject curUser = this.getCurrentUser();
        this.fastAudit = "fastAudit".equals(StdConfig.get("selfWoffAuditType"));
        for (DynamicObject bill : e.getDataEntities()) {
            if (!bill.getBoolean("isselfwoff")) continue;
            if (this.fastAudit) {
                bill.set("billstatus", (Object)"C");
                bill.set("auditor", (Object)curUser);
                bill.set("auditdate", (Object)new Date());
            }
            selfWoffBills.add(bill);
        }
        if (this.fastAudit) {
            Map<String, List<DynamicObject>> groupbyWoffBills = selfWoffBills.stream().collect(Collectors.groupingBy(woffBill -> woffBill.getDataEntityType().getName()));
            for (Map.Entry<String, List<DynamicObject>> entry : groupbyWoffBills.entrySet()) {
                List<DynamicObject> woffBills = entry.getValue();
                String billType = woffBills.get(0).getDataEntityType().getName();
                if (billType.startsWith("ap")) {
                    BookDateHelper.setBookDate(woffBills.toArray(new DynamicObject[0]), false);
                    continue;
                }
                BookDateHelper.setBookDate(woffBills.toArray(new DynamicObject[0]), true);
            }
            new JournalService().pushAndSaveJournals(selfWoffBills.toArray(new DynamicObject[0]));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] entities;
        super.endOperationTransaction(e);
        for (DynamicObject bill : entities = e.getDataEntities()) {
            if (!ObjectUtils.isEmpty((Object)bill.getString("billno")) || !bill.getBoolean("isadjust")) continue;
            throw new KDBizException(ResManager.loadKDString((String)"\u6682\u4f30\u5355\u672a\u6309\u8981\u6c42\u586b\u5199\u201c\u5355\u636e\u7f16\u53f7\u201d\u4e14\u672a\u627e\u5230\u6ee1\u8db3\u6761\u4ef6\u7684\u7f16\u7801\u89c4\u5219\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"BusBillSave4WoffOp_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        super.afterExecuteOperationTransaction(e);
        if (this.fastAudit) {
            return;
        }
        ArrayList<Object> selfWoffBills = new ArrayList<Object>(e.getDataEntities().length);
        for (DynamicObject bill : e.getDataEntities()) {
            if (!bill.getBoolean("isselfwoff")) continue;
            selfWoffBills.add(bill.getPkValue());
        }
        if (!selfWoffBills.isEmpty()) {
            logger.info("selfWoffBills.executeOperate");
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            option.setVariableValue("iswoff", "true");
            option.setVariableValue("WF", "false");
            option.setVariableValue("mutex_writeback", "false");
            OperationResult result = OperationServiceHelper.executeOperate((String)"nocontrolsubmit", (String)this.billEntityType.getName(), (Object[])selfWoffBills.toArray(), (OperateOption)option);
            OperationHelper.assertResult(result);
            OperationResult auditResult = OperationServiceHelper.executeOperate((String)"audit", (String)this.billEntityType.getName(), (Object[])result.getSuccessPkIds().toArray(), (OperateOption)option);
            OperationHelper.assertResult(auditResult);
        }
    }

    private DynamicObject getCurrentUser() {
        long userId = RequestContext.get().getCurrUserId();
        return BusinessDataServiceHelper.loadSingleFromCache((Object)userId, (String)"bos_user");
    }
}

