/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.opplugin.ArapBaseOp;

public class BusBillWoffOp
extends ArapBaseOp {
    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        Map paramMap = this.getOption().getVariables();
        String entityName = (String)paramMap.get("entity");
        String busBillIds = (String)paramMap.get("ids");
        List ids = (List)SerializationUtils.fromJsonString((String)busBillIds, List.class);
        paramMap.put("woffmode", "batch");
        paramMap.put("isselfwoff", "true");
        List woffBills = null;
        Map<String, Object> resultMap = BOTPHelper.push4Result(entityName, entityName, "ar_busbill".equals(entityName) ? "697561685841434624" : "712748085842822144", ids, paramMap);
        Object convertResult = resultMap.get("convertResult");
        if (convertResult != null) {
            ConvertOperationResult result = (ConvertOperationResult)convertResult;
            ErrorCode ec = new ErrorCode("botp", result.getMessage());
            throw new KDBizException(ec, new Object[0]);
        }
        woffBills = (List)resultMap.get("trgBills");
        this.setTargetBillsNo(entityName, woffBills);
        this.doOperation(entityName, woffBills);
    }

    private void doOperation(String entityName, List<DynamicObject> woffBills) {
        OperateOption option = OperateOption.create();
        option.setVariableValue("ishasright", "true");
        option.setVariableValue("iswoff", "true");
        option.setVariableValue("WF", "false");
        option.setVariableValue("mutex_writeback", "false");
        OperationResult result = OperationServiceHelper.executeOperate((String)"save", (String)entityName, (DynamicObject[])woffBills.toArray(new DynamicObject[0]), (OperateOption)option);
        OperationHelper.assertResult(result);
    }

    private void setTargetBillsNo(String entityName, List<DynamicObject> trgBills) {
        Map<String, List<DynamicObject>> orgPkGroup = trgBills.stream().collect(Collectors.groupingBy(bill -> bill.getDynamicObject("org").getPkValue().toString()));
        orgPkGroup.entrySet().forEach(entry -> {
            List targetBills = (List)entry.getValue();
            String[] numbers = CodeRuleServiceHelper.getBatchNumber((String)entityName, (DynamicObject)((DynamicObject)targetBills.get(0)), (String)((String)entry.getKey()), (int)targetBills.size());
            int i = 0;
            for (DynamicObject trgBusBill : targetBills) {
                trgBusBill.set("billno", (Object)numbers[i]);
                trgBusBill.set("isselfwoff", (Object)Boolean.TRUE);
                ++i;
            }
        });
    }
}

