/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;

public class BusBillWoffRevaluaTionValidator
extends AbstractValidator {
    public void validate() {
        String busEntityKey = this.dataEntities[0].getDataEntity().getDataEntityType().getName();
        if (busEntityKey.startsWith("ar")) {
            return;
        }
        Map<Long, String> srcBusBillNo = this.getHadRevaluaTionSrcBusBill();
        this.rvalValidate(srcBusBillNo);
    }

    private void rvalValidate(Map<Long, String> srcBusBillNo) {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            String srcBillNo;
            DynamicObject busBill = dataEntity.getDataEntity();
            String busBillNo = busBill.getString("billno");
            boolean isReval = busBill.getBoolean("isrevaluation");
            boolean hadReval = busBill.getBoolean("hadrevaluation");
            if (isReval) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7%s\uff1a\u91cd\u4f30\u4e1a\u52a1\u6682\u4f30\u5355\u4e0d\u5141\u8bb8\u624b\u5de5\u51b2\u56de\u3002\u82e5\u91cd\u4f30\u9519\u8bef\u8bf7\u4f7f\u7528\u91cd\u4f30\u529f\u80fd\u3002", (String)"BusBillWoffRevaluaTionValidator_0", (String)"fi-arapcommon", (Object[])new Object[]{busBillNo}));
                continue;
            }
            if (hadReval) {
                this.addErrorMessage(dataEntity, String.format(ResManager.loadResFormat((String)"\u5355\u636e\u7f16\u53f7%1$s\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u51b2\u56de\u3002", (String)"BusBillWoffRevaluaTionValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]), busBillNo));
                continue;
            }
            String srcBillId = busBill.getString("sourcebillid");
            if (srcBillId == null || "".equals(srcBillId) || (srcBillNo = srcBusBillNo.get(Long.valueOf(srcBillId))) == null) continue;
            this.addErrorMessage(dataEntity, String.format(ResManager.loadResFormat((String)"\u5355\u636e\u7f16\u53f7%1$s\uff1a\u4e0a\u6e38\u6682\u4f30\u5355%2$s\u5df2\u91cd\u4f30\uff0c\u4e0d\u5141\u8bb8\u624b\u5de5\u51b2\u56de\u3002", (String)"BusBillWoffRevaluaTionValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), busBillNo, srcBillNo));
        }
    }

    private Map<Long, String> getHadRevaluaTionSrcBusBill() {
        DynamicObject[] hadRevalBusBills;
        HashMap<Long, String> srcBusBillNo = new HashMap<Long, String>(2);
        ArrayList<Long> srcIds = new ArrayList<Long>(2);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject busBill = dataEntity.getDataEntity();
            String srcBillId = busBill.getString("sourcebillid");
            if (srcBillId == null || "".equals(srcBillId)) continue;
            srcIds.add(Long.valueOf(srcBillId));
        }
        if (srcIds.size() == 0) {
            return srcBusBillNo;
        }
        for (DynamicObject bill : hadRevalBusBills = BusinessDataServiceHelper.load((String)"ap_busbill", (String)"id,billno", (QFilter[])new QFilter[]{new QFilter("id", "in", srcIds), new QFilter("hadrevaluation", "=", (Object)Boolean.TRUE)})) {
            srcBusBillNo.put(bill.getLong("id"), bill.getString("billno"));
        }
        return srcBusBillNo;
    }
}

