/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.AfterOperationArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.OpBizRuleSetServiceHelper;
import kd.fi.arapcommon.service.helper.OpLogServiceHelper;
import kd.fi.arapcommon.service.log.OpLogInfo;
import kd.fi.arapcommon.util.EmptyUtils;

public class ExecControlOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        fieldKeys.add("bizobj");
        fieldKeys.add("ctrltype");
        fieldKeys.add("ctrlmode");
        fieldKeys.add("ctrlpoint");
        fieldKeys.add("plugin");
        fieldKeys.add("status");
        fieldKeys.add("enable");
        fieldKeys.add("number");
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String operationKey = e.getOperationKey();
        for (DynamicObject dataEntity : dataEntities) {
            if (!"save".equals(operationKey)) continue;
            dataEntity.set("enable", (Object)Character.valueOf('1'));
        }
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] execControls = e.getDataEntities();
        String operationKey = e.getOperationKey();
        ArrayList<OpLogInfo> opLogInfos = new ArrayList<OpLogInfo>(32);
        for (DynamicObject execControl : execControls) {
            OpLogInfo log = new OpLogInfo();
            log.setOpName(operationKey).setIgnoreLogParam(true).setEntity("arap_execcontrol").setBillNo(execControl.getString("number"));
            opLogInfos.add(log);
        }
        OpLogServiceHelper.addLog(opLogInfos);
    }

    public void afterExecuteOperationTransaction(AfterOperationArgs e) {
        DynamicObject[] dataEntities;
        for (DynamicObject dataEntity : dataEntities = e.getDataEntities()) {
            if (!EmptyUtils.isNotEmpty(dataEntity.getString("ctrlpoint")) || !EmptyUtils.isNotEmpty(dataEntity.getString("bizobj"))) continue;
            DynamicObject bizObj = dataEntity.getDynamicObject("bizobj");
            String ctrltype = dataEntity.getString("ctrltype");
            if ("deleteprocesssr".equals(ctrltype)) {
                String operationKey = e.getOperationKey();
                OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)bizObj.getString("number"), (String)"BillDeleteProcessSettleRecord");
                if (!"save".equals(operationKey) && !"enable".equals(operationKey)) continue;
                ArrayList<String> ctrlPointOps = new ArrayList<String>(1);
                ctrlPointOps.add("delete");
                OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)bizObj.getString("number"), (String)"BillDeleteProcessSettleRecord", new ArrayList(ctrlPointOps));
                continue;
            }
            if (bizObj == null || !"cas_paybill".equals(bizObj.getString("number")) && !"cas_recbill".equals(bizObj.getString("number"))) continue;
            OpBizRuleSetServiceHelper.deleteOpBizRuleSet((String)bizObj.getString("number"), (String)"ArApExecControl");
            Set<String> ctrlPointOps = this.needProcessOpAction(dataEntity);
            if (!EmptyUtils.isNotEmpty(ctrlPointOps)) continue;
            OpBizRuleSetServiceHelper.saveOpBizRuleSet((String)bizObj.getString("number"), (String)"ArApExecControl", new ArrayList<String>(ctrlPointOps));
        }
    }

    private Set<String> getCtrlPointOp(String ctrlPoint) {
        if (EmptyUtils.isNotEmpty(ctrlPoint)) {
            return Arrays.stream(ctrlPoint.split(",")).filter(str -> str.length() != 0).collect(Collectors.toSet());
        }
        return new HashSet<String>(4);
    }

    private Set<String> needProcessOpAction(DynamicObject dataEntity) {
        DynamicObject bizObj = dataEntity.getDynamicObject("bizobj");
        HashSet<String> ctrlPointOps = new HashSet<String>(16);
        QFilter filter = new QFilter("bizobj.number", "=", (Object)bizObj.getString("number"));
        filter.and("enable", "=", (Object)Boolean.TRUE);
        filter.and("status", "=", (Object)Character.valueOf('C'));
        filter.and("ctrlmode", "=", (Object)"plugin");
        filter.and("plugin", "not in", Arrays.asList("", " "));
        Map execControls = BusinessDataServiceHelper.loadFromCache((String)"arap_execcontrol", (String)"ctrlpoint", (QFilter[])new QFilter[]{filter});
        for (Map.Entry entrySet : execControls.entrySet()) {
            ctrlPointOps.addAll(this.getCtrlPointOp(((DynamicObject)entrySet.getValue()).getString("ctrlpoint")));
        }
        return ctrlPointOps;
    }
}

