/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.helper.ArApHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class FinBillCheckAmtValidator
extends AbstractValidator {
    private boolean isAr;

    public FinBillCheckAmtValidator() {
    }

    public FinBillCheckAmtValidator(boolean isAr) {
        this.isAr = isAr;
    }

    public void validate() {
        HashMap<Long, Integer> orgMap = new HashMap<Long, Integer>();
        String periodEntity = this.isAr ? ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u6536\u5355", (String)"FinBillCheckAmtValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u671f\u521d\u8d22\u52a1\u5e94\u4ed8\u5355", (String)"FinBillCheckAmtValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        for (ExtendedDataEntity dataEntity : this.getDataEntities()) {
            this.checkPlanAmtForSplitScheme(dataEntity);
            DynamicObject bill = dataEntity.getDataEntity();
            Long orgPk = (Long)bill.getDynamicObject("org").getPkValue();
            Integer param = (Integer)orgMap.get(orgPk);
            if (ObjectUtils.isEmpty((Object)param)) {
                param = this.isAr ? ArApHelper.getArSettleParam(orgPk) : ArApHelper.getApSettleParam(orgPk);
                orgMap.put(orgPk, param);
            }
            if (!this.isPeriod(bill)) break;
            boolean success = this.checkAmt(param, bill);
            if (success) continue;
            if (1 == param) {
                if (this.isAr) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u7269\u6599\u884c\u7ed3\u7b97\u65f6\uff0c%s\u660e\u7ec6\u884c\u5e94\u6536\u91d1\u989d\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a0\u3002", (String)"FinBillCheckAmtValidator_4", (String)"fi-arapcommon", (Object[])new Object[]{periodEntity}));
                    continue;
                }
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u7269\u6599\u884c\u7ed3\u7b97\u65f6\uff0c%s\u660e\u7ec6\u884c\u5e94\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a0\u3002", (String)"FinBillCheckAmtValidator_6", (String)"fi-arapcommon", (Object[])new Object[]{periodEntity}));
                continue;
            }
            if (this.isAr) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u8ba1\u5212\u884c\u7ed3\u7b97\u65f6\uff0c%s\u6536\u6b3e\u8ba1\u5212\u884c\u5e94\u6536\u91d1\u989d\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a0\u3002", (String)"FinBillCheckAmtValidator_7", (String)"fi-arapcommon", (Object[])new Object[]{periodEntity}));
                continue;
            }
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6309\u8ba1\u5212\u884c\u7ed3\u7b97\u65f6\uff0c%s\u4ed8\u6b3e\u8ba1\u5212\u884c\u5e94\u4ed8\u91d1\u989d\u4e0d\u5141\u8bb8\u5168\u90e8\u4e3a0\u3002", (String)"FinBillCheckAmtValidator_8", (String)"fi-arapcommon", (Object[])new Object[]{periodEntity}));
        }
    }

    private boolean checkAmt(Integer param, DynamicObject bill) {
        boolean success = false;
        if (1 == param) {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection(this.isAr ? "entry" : "detailentry");
            for (DynamicObject entry : entries) {
                BigDecimal e_recamount = entry.getBigDecimal(this.isAr ? "e_recamount" : "e_pricetaxtotal");
                if (BigDecimal.ZERO.compareTo(e_recamount) == 0) continue;
                success = true;
                break;
            }
        } else {
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("planentity");
            for (DynamicObject entry : entries) {
                BigDecimal e_recamount = entry.getBigDecimal("planpricetax");
                if (BigDecimal.ZERO.compareTo(e_recamount) == 0) continue;
                success = true;
                break;
            }
        }
        return success;
    }

    private boolean isPeriod(DynamicObject bill) {
        return bill.getBoolean("isperiod");
    }

    private void checkPlanAmtForSplitScheme(ExtendedDataEntity data) {
        DynamicObject dataEntity = data.getDataEntity();
        String entityName = dataEntity.getDataEntityType().getName();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)entityName);
        BillModel billModel = BillModelFactory.getModel(entityName);
        DynamicObjectCollection detailEntries = dataEntity.getDynamicObjectCollection(billModel.ENTRY);
        DynamicObjectCollection planEntries = dataEntity.getDynamicObjectCollection(billModel.P_ENTRY);
        String entryName = entityType.findProperty(billModel.P_ENTRY).getDisplayName().getLocaleValue();
        Map<Integer, List<DynamicObject>> detailEntriesBySplitDimensionId = detailEntries.stream().collect(Collectors.groupingBy(entries -> entries.getInt(billModel.E_SPLITDIMENSION_ID)));
        Map<Integer, List<DynamicObject>> planEntriesBySplitDimensionId = planEntries.stream().collect(Collectors.groupingBy(entries -> entries.getInt(billModel.P_SPLITDIMENSION_ID)));
        HashMap<Integer, BigDecimal> dimensionAmtBydetailEntriesMap = new HashMap<Integer, BigDecimal>(detailEntriesBySplitDimensionId.size());
        for (Map.Entry<Integer, List<DynamicObject>> entries2 : detailEntriesBySplitDimensionId.entrySet()) {
            BigDecimal bigDecimal = entries2.getValue().stream().map(e -> e.getBigDecimal(billModel.E_PRICETAXTOTAL)).reduce(BigDecimal.ZERO, BigDecimal::add);
            dimensionAmtBydetailEntriesMap.put(entries2.getKey(), bigDecimal);
        }
        HashMap<Integer, BigDecimal> dimensionAmtByplanEntriesMap = new HashMap<Integer, BigDecimal>(planEntriesBySplitDimensionId.size());
        for (Map.Entry<Integer, List<DynamicObject>> entry : planEntriesBySplitDimensionId.entrySet()) {
            BigDecimal pricetaxtotal = entry.getValue().stream().map(e -> e.getBigDecimal(billModel.P_PLANPRICETAX)).reduce(BigDecimal.ZERO, BigDecimal::add);
            dimensionAmtByplanEntriesMap.put(entry.getKey(), pricetaxtotal);
        }
        for (Map.Entry<Integer, List<Object>> entry : dimensionAmtByplanEntriesMap.entrySet()) {
            String fieldName = entityType.findProperty(billModel.P_PLANPRICETAX).getDisplayName().getLocaleValue();
            if (((BigDecimal)((Object)entry.getValue())).compareTo((BigDecimal)dimensionAmtBydetailEntriesMap.get(entry.getKey())) == 0) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%1$s\u6309\u7167\u62c6\u5206\u7ef4\u5ea6\u62c6\u5206\u540e\u7684%2$s\u6c47\u603b\u4e0e\u660e\u7ec6\u884c%3$s\u6c47\u603b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillCheckAmtValidator_11", (String)"fi-arapcommon", (Object[])new Object[0]), entryName, fieldName, fieldName));
            break;
        }
        for (Map.Entry<Integer, List<Object>> entry : planEntriesBySplitDimensionId.entrySet()) {
            boolean isAllPositive = entry.getValue().stream().allMatch(e -> e.getBigDecimal(billModel.P_PLANPRICETAX).compareTo(BigDecimal.ZERO) >= 0);
            boolean isAllNegative = entry.getValue().stream().allMatch(e -> e.getBigDecimal(billModel.P_PLANPRICETAX).compareTo(BigDecimal.ZERO) <= 0);
            if (isAllPositive || isAllNegative) continue;
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u76f8\u540c\u62c6\u5206\u7ef4\u5ea6\u7684%s\u884c\u4e0d\u80fd\u540c\u65f6\u5b58\u5728\u6b63\u8d1f\u5206\u5f55\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinBillCheckAmtValidator_13", (String)"fi-arapcommon", (Object[])new Object[0]), entryName));
            break;
        }
        for (DynamicObject dynamicObject : planEntries) {
            BigDecimal planpricetax = dynamicObject.getBigDecimal(billModel.P_PLANPRICETAX);
            BigDecimal planpricetaxloc = dynamicObject.getBigDecimal(billModel.P_PLANPRICETAXLOC);
            int seq = dynamicObject.getInt("seq");
            if (planpricetax.multiply(planpricetaxloc).compareTo(BigDecimal.ZERO) >= 0) continue;
            String planPriceTaxName = entityType.findProperty(billModel.P_PLANPRICETAX).getDisplayName().getLocaleValue();
            String planPriceTaxLocName = entityType.findProperty(billModel.P_PLANPRICETAXLOC).getDisplayName().getLocaleValue();
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"%1$s\u7b2c%2$s\u884c%3$s\u4e0e%4$s\u65b9\u5411\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinBillCheckAmtValidator_14", (String)"fi-arapcommon", (Object[])new Object[0]), entryName, seq, planPriceTaxName, planPriceTaxLocName));
        }
    }
}

