/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.ArApRecOrPayBillHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;

public class FinBillPreInfoValidator
extends AbstractValidator {
    private boolean isAr;

    public FinBillPreInfoValidator() {
    }

    public FinBillPreInfoValidator(boolean isAr) {
        this.isAr = isAr;
    }

    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        String sign = this.isAr ? ResManager.loadKDString((String)"\u6536", (String)"FinBillPreInfoValidator_0", (String)"fi-arapcommon", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u4ed8", (String)"FinBillPreInfoValidator_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        String operateKey = this.getOperateKey();
        ArrayList<DynamicObject> historyBills = new ArrayList<DynamicObject>(10);
        if ("submit".equals(operateKey)) {
            for (ExtendedDataEntity dataEntity : dataEntities) {
                DynamicObject bill = dataEntity.getDataEntity();
                boolean isHistory = ArApRecOrPayBillHelper.isHistoryPreEntryBill(bill);
                if (isHistory) {
                    historyBills.add(bill);
                    continue;
                }
                DynamicObjectCollection entry = bill.getDynamicObjectCollection("preentry");
                BigDecimal priceTaxTotal = bill.getBigDecimal(this.isAr ? "recamount" : "pricetaxtotal");
                if (priceTaxTotal.compareTo(BigDecimal.ZERO) == 0 && !ObjectUtils.isEmpty((Object)entry)) {
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u8d22\u52a1\u5e94%1$s\u5355\u5e94%1$s\u91d1\u989d\u4e3a0\uff0c\u4e0d\u5141\u8bb8\u5173\u8054\u9884%1$s\u6b3e\u5355\u3002", (String)"FinBillPreInfoValidator_2", (String)"fi-arapcommon", (Object[])new Object[0]), sign));
                    continue;
                }
                for (DynamicObject row : entry) {
                    long preBillId = row.getLong("y_billid");
                    BigDecimal amount = row.getBigDecimal("y_amount");
                    if (preBillId != 0L && priceTaxTotal.multiply(amount).compareTo(BigDecimal.ZERO) < 0) {
                        this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884%1$s\u4fe1\u606f\u7b2c%2$s\u884c\u5173\u8054\u7684\u9884%1$s\u6b3e\u5355\u5e94%1$s\u91d1\u989d\u4e0e\u8d22\u52a1\u5e94%1$s\u5355\u6574\u5355\u5e94%1$s\u91d1\u989d\u65b9\u5411\u4e0d\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillPreInfoValidator_3", (String)"fi-arapcommon", (Object[])new Object[0]), sign, row.getInt("seq")));
                    }
                    BigDecimal settleAmt = row.getBigDecimal("y_settleamt");
                    if (preBillId == 0L || priceTaxTotal.multiply(settleAmt).compareTo(BigDecimal.ZERO) >= 0) continue;
                    this.addErrorMessage(dataEntity, String.format(ResManager.loadKDString((String)"\u9884%1$s\u4fe1\u606f\u7b2c%2$s\u884c\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0e\u8d22\u52a1\u5e94%1$s\u5355\u6574\u5355\u5e94%1$s\u91d1\u989d\u65b9\u5411\u4e0d\u540c\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillPreInfoValidator_4", (String)"fi-arapcommon", (Object[])new Object[0]), sign, row.getInt("seq")));
                }
                BigDecimal premiumAmt = bill.getBigDecimal("premiumamt");
                priceTaxTotal = priceTaxTotal.subtract(premiumAmt);
                BigDecimal settleAmtSum = BigDecimal.ZERO;
                for (DynamicObject row : entry) {
                    settleAmtSum = settleAmtSum.add(row.getBigDecimal("y_settleamt"));
                }
                if (priceTaxTotal.abs().compareTo(settleAmtSum.abs()) >= 0) continue;
                String message = ResManager.loadKDString((String)"\u9884\u4ed8\u4fe1\u606f\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6c47\u603b\u503c\u4e0d\u80fd\u8d85\u8fc7\u53ef\u7ed3\u7b97\u91d1\u989d\uff08\u5e94\u4ed8\u91d1\u989d\u51cf\u53bb\u8d28\u4fdd\u91d1\u91d1\u989d\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillPreInfoValidator_5", (String)"fi-arapcommon", (Object[])new Object[0]);
                if (this.isAr) {
                    message = ResManager.loadKDString((String)"\u9884\u6536\u4fe1\u606f\u7684\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u6c47\u603b\u503c\u4e0d\u80fd\u8d85\u8fc7\u53ef\u7ed3\u7b97\u91d1\u989d\uff08\u5e94\u6536\u91d1\u989d\u51cf\u53bb\u8d28\u4fdd\u91d1\u91d1\u989d\uff09\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillPreInfoValidator_6", (String)"fi-arapcommon", (Object[])new Object[0]);
                }
                this.addErrorMessage(dataEntity, message);
            }
        }
        HashMap<Long, ArrayList<ExtendedDataEntity>> map = new HashMap<Long, ArrayList<ExtendedDataEntity>>(4);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            long orgId = bill.getLong("org.id");
            ArrayList<ExtendedDataEntity> entities = (ArrayList<ExtendedDataEntity>)map.get(orgId);
            if (entities == null) {
                entities = new ArrayList<ExtendedDataEntity>(10);
            }
            entities.add(dataEntity);
            map.put(orgId, entities);
        }
        ArrayList<ExtendedDataEntity> submitSettleDatas = new ArrayList<ExtendedDataEntity>(10);
        Map<Long, Object> paramMap = SystemParameterHelper.batchGetAppParameter(this.isAr, new ArrayList<Long>(map.keySet()), this.isAr ? "ar_016" : "ap_016");
        for (Map.Entry<Long, Object> entry : paramMap.entrySet()) {
            List entities;
            Long orgId = entry.getKey();
            Object value = entry.getValue();
            if (value == null || !((Boolean)value).booleanValue() || (entities = (List)map.get(orgId)) == null) continue;
            submitSettleDatas.addAll(entities);
        }
        if (!ObjectUtils.isEmpty(submitSettleDatas) && "submit".equals(operateKey)) {
            this.validateUnsettleAmt(submitSettleDatas, sign, historyBills);
        }
        if ("audit".equals(operateKey)) {
            ArrayList<ExtendedDataEntity> entities = new ArrayList<ExtendedDataEntity>(Arrays.asList(dataEntities));
            if (!ObjectUtils.isEmpty(submitSettleDatas)) {
                entities.removeAll(submitSettleDatas);
            }
            if (!ObjectUtils.isEmpty(entities)) {
                this.validateUnsettleAmt(entities, sign, historyBills);
            }
        }
    }

    private void validateUnsettleAmt(List<ExtendedDataEntity> entities, String sign, List<DynamicObject> historyBills) {
        for (ExtendedDataEntity entity : entities) {
            DynamicObject bill = entity.getDataEntity();
            if (historyBills.contains(bill)) continue;
            Long orgId = bill.getLong("org.id");
            DynamicObjectCollection preEntry = bill.getDynamicObjectCollection("preentry");
            long settleOrgId = 0L;
            for (DynamicObject preRow : preEntry) {
                String preBillType = preRow.getString("y_billtype");
                long preBillId = preRow.getLong("y_billid");
                if (0L == preBillId) continue;
                BigDecimal settleAmt = preRow.getBigDecimal("y_settleamt");
                BigDecimal unsettleAmt = BigDecimal.ZERO;
                Object[] preBills = BusinessDataServiceHelper.load((String)preBillType, (String)String.join((CharSequence)",", this.getSelectors(preBillType)), (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)preBillId)});
                if (ObjectUtils.isEmpty((Object[])preBills)) {
                    this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u53ef\u53c2\u4e0e\u7ed3\u7b97\u7684\u9884%1$s\u6b3e\u5355%2$s\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillPreInfoValidator_7", (String)"fi-arapcommon", (Object[])new Object[0]), sign, preRow.getString("y_billno")));
                    continue;
                }
                Object preBill = preBills[0];
                settleOrgId = preBill.getLong("org.id");
                for (DynamicObject row : preBill.getDynamicObjectCollection("entry")) {
                    if (preBillType.startsWith("cas_")) {
                        DynamicObject paymentType = row.getDynamicObject("cas_paybill".equals(preBillType) ? "e_paymenttype" : "e_receivingtype");
                        if (ObjectUtils.isEmpty((Object)paymentType) || !("cas_paybill".equals(preBillType) ? "202" : "101").equals(paymentType.getString("biztype"))) continue;
                        settleOrgId = row.getLong("cas_paybill".equals(preBillType) ? "settleorg.id" : "e_settleorg.id");
                    }
                    if (!orgId.equals(settleOrgId)) continue;
                    unsettleAmt = unsettleAmt.add(row.getBigDecimal("e_unsettledamt"));
                }
                if (settleAmt.abs().compareTo(unsettleAmt.abs()) <= 0) continue;
                this.addErrorMessage(entity, String.format(ResManager.loadKDString((String)"\u9884%1$s\u4fe1\u606f\u7b2c%2$s\u884c\uff0c\u9884%1$s\u6b3e\u5355%3$s\u672a\u7ed3\u7b97\u91d1\u989d\u4e0d\u8db3\uff0c\u8bf7\u4fee\u6539\u3002", (String)"FinBillPreInfoValidator_8", (String)"fi-arapcommon", (Object[])new Object[0]), sign, preRow.getInt("seq"), preRow.getString("y_billno")));
            }
        }
    }

    private List<String> getSelectors(String preBillType) {
        ArrayList<String> selectors = new ArrayList<String>(4);
        selectors.add("entry.e_unsettledamt");
        selectors.add("org");
        if ("cas_paybill".equals(preBillType)) {
            selectors.add("entry.settleorg");
            selectors.add("entry.e_paymenttype");
        } else if ("cas_recbill".equals(preBillType)) {
            selectors.add("entry.e_settleorg");
            selectors.add("entry.e_receivingtype");
        }
        return selectors;
    }
}

