/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.SqlParameter;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.db.SqlBuilder;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.util.EmptyUtils;

public class HealthCheckOp
extends AbstractOperationServicePlugIn {
    public void onAddValidators(AddValidatorsEventArgs e) {
        e.addValidator(new AbstractValidator(){

            public void validate() {
                ExtendedDataEntity[] datas = this.getDataEntities();
                Map readDBLockMap = HealthCheckOp.this.readDBLock("ap_healthcheck", "dataCheck", (String[])Arrays.stream(datas).map(data -> Long.toString(data.getDataEntity().getLong("id"))).toArray(String[]::new));
                for (ExtendedDataEntity data2 : datas) {
                    if (!EmptyUtils.isNotEmpty(readDBLockMap) || !Boolean.TRUE.equals(readDBLockMap.get(Long.toString(data2.getDataEntity().getLong("id"))))) continue;
                    this.addErrorMessage(data2, ResManager.loadKDString((String)"\u6b63\u5728\u6267\u884c\uff0c\u8bf7\u52ff\u91cd\u590d\u6267\u884c\u8be5\u201c\u5065\u5eb7\u5de1\u67e5\u201d\u3002", (String)"HealthCheckOp_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
            }
        });
    }

    private Map<String, Boolean> readDBLock(String entityKey, String operationKey, String[] dataObjIds) {
        Map<String, Boolean> lockMap = new HashMap<String, Boolean>();
        if (dataObjIds != null && dataObjIds.length != 0) {
            ArrayList<SqlParameter> params = new ArrayList<SqlParameter>(10);
            params.add(new SqlParameter(":FEntityKey", 12, (Object)entityKey));
            params.add(new SqlParameter(":FOperationKey", 12, (Object)operationKey));
            SqlBuilder sbBuilder = new SqlBuilder();
            sbBuilder.append("select FObjectID from t_mutex_datalock where FEntityKey = ? and FOperationKey = ? and ", params.toArray(new Object[params.size()])).appendIn("FObjectID", (Object[])dataObjIds);
            lockMap = (Map)DB.query((DBRoute)DBRoute.basedata, (SqlBuilder)sbBuilder, (ResultSetHandler)new ResultSetHandler<Map<String, Boolean>>(){

                public Map<String, Boolean> handle(ResultSet rs) throws Exception {
                    HashMap<String, Boolean> locks = new HashMap<String, Boolean>(8);
                    while (rs.next()) {
                        locks.put(rs.getString("FObjectID"), Boolean.TRUE);
                    }
                    return locks;
                }
            });
        }
        return lockMap;
    }
}

