/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IMetadata;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.property.EntryProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.BookDateHelper;
import kd.fi.arapcommon.journal.JournalService;

public class SettleRecordAuditJournalOp
extends AbstractOperationServicePlugIn {
    private static final Log logger = LogFactory.getLog(SettleRecordAuditJournalOp.class);

    public void onPreparePropertys(PreparePropertysEventArgs e) {
        List fieldKeys = e.getFieldKeys();
        List<IDataEntityProperty> properties = SettleRecordAuditJournalOp.getProperties(this.billEntityType);
        List propertyKeys = properties.stream().map(IMetadata::getName).collect(Collectors.toList());
        fieldKeys.addAll(propertyKeys);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] settleDatas = e.getDataEntities();
        this.setSettleDate(settleDatas);
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        super.endOperationTransaction(e);
        long start = System.currentTimeMillis();
        DynamicObject[] sourceBills = e.getDataEntities();
        JournalService journalService = new JournalService();
        journalService.pushAndSaveJournals(sourceBills);
        logger.info("---audit.journalService---" + (System.currentTimeMillis() - start) + "ms");
    }

    private static List<IDataEntityProperty> getProperties(MainEntityType entityType) {
        ArrayList<IDataEntityProperty> props = new ArrayList<IDataEntityProperty>();
        DataEntityPropertyCollection properties = entityType.getProperties();
        for (IDataEntityProperty prop : properties) {
            if (prop instanceof EntryProp) {
                DataEntityPropertyCollection entryProperties = ((EntryProp)prop)._collectionItemPropertyType.getProperties();
                props.addAll((Collection<IDataEntityProperty>)entryProperties);
                continue;
            }
            props.add(prop);
        }
        return props;
    }

    private void setSettleDate(DynamicObject[] settleDatas) {
        String submitSettleRecords;
        Map optionVariables = this.operateOption.getVariables();
        if (!ObjectUtils.isEmpty((Object)optionVariables) && "true".equals(submitSettleRecords = (String)optionVariables.get("submitsettlerecords"))) {
            BookDateHelper.setSettleDate(settleDatas);
        }
    }
}

