/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.BeginOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.validator.UpdateSettleDateValidator;

public class UpdateSettleDateOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().add("settledate");
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        UpdateSettleDateValidator validator = new UpdateSettleDateValidator();
        e.addValidator((AbstractValidator)validator);
    }

    public void beginOperationTransaction(BeginOperationTransactionArgs e) {
        super.beginOperationTransaction(e);
        DynamicObject[] infos = e.getDataEntities();
        String dateString = this.getOption().getVariableValue("newdate");
        Date newDate = (Date)SerializationUtils.fromJsonString((String)dateString, Date.class);
        ArrayList<Long> pks = new ArrayList<Long>(64);
        for (DynamicObject info : infos) {
            pks.add(info.getLong("id"));
            info.set("settledate", (Object)newDate);
        }
        SaveServiceHelper.save((DynamicObject[])infos);
        JournalService journalService = new JournalService();
        journalService.modifyJournalDate(infos[0].getDataEntityType().getName(), pks.toArray(new Long[0]), newDate);
    }
}

