/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.opplugin;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.plugin.AbstractOperationServicePlugIn;
import kd.bos.entity.plugin.AddValidatorsEventArgs;
import kd.bos.entity.plugin.PreparePropertysEventArgs;
import kd.bos.entity.plugin.args.EndOperationTransactionArgs;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.validator.VerifyRecordUnVerifyValidator;

public class VerifyRecordBaseUnVerifyNewOp
extends AbstractOperationServicePlugIn {
    public void onPreparePropertys(PreparePropertysEventArgs e) {
        super.onPreparePropertys(e);
        e.getFieldKeys().addAll(this.preparePropertys());
    }

    protected List<String> preparePropertys() {
        ArrayList<String> selector = new ArrayList<String>(64);
        selector.add("writeofftypeid");
        selector.add("org");
        selector.add("verifyseq");
        selector.add("billid");
        selector.add("billno");
        selector.add("billtype");
        selector.add("billentryid");
        selector.add("qty");
        selector.add("measureunit");
        selector.add("verifyqty");
        selector.add("verifybaseqty");
        selector.add("payableamount");
        selector.add("verifyamount");
        selector.add("verifytaxamount");
        selector.add("verifytype");
        selector.add("verifyrelation");
        selector.add("e_billtype");
        selector.add("e_qty");
        selector.add("e_measureunit");
        selector.add("e_verifyqty");
        selector.add("e_verifybaseqty");
        selector.add("e_payableamount");
        selector.add("e_verifyamount");
        selector.add("e_verifytaxamount");
        selector.add("e_billid");
        selector.add("e_billno");
        selector.add("e_billentryid");
        selector.add("e_iswrittenoff");
        selector.add("e_hadwrittenoff");
        selector.add("isvoucher");
        selector.add("currency");
        selector.add("e_currency");
        selector.add("asstact");
        selector.add("asstacttype");
        if ("cal_purwfrecord".equals(this.billEntityType.getName())) {
            selector.add("wfscheme");
            selector.add("writeofftypeid");
        }
        return selector;
    }

    public void onAddValidators(AddValidatorsEventArgs e) {
        super.onAddValidators(e);
        e.addValidator((AbstractValidator)new VerifyRecordUnVerifyValidator());
    }

    public void endOperationTransaction(EndOperationTransactionArgs e) {
        DynamicObject[] dataEntities = e.getDataEntities();
        String wfRecordEntityNum = this.billEntityType.getName();
        String oldRecordEntityNUm = this.getRecordEntityNum(wfRecordEntityNum);
        HashSet<Object> oldWfRecordIdSet = new HashSet<Object>(16);
        for (DynamicObject data : dataEntities) {
            DynamicObject wfType = data.getDynamicObject("writeofftypeid");
            if (wfType == null) {
                oldWfRecordIdSet.add(data.getPkValue());
                continue;
            }
            if (Long.compare(wfType.getLong("id"), 0L) != 0) continue;
            oldWfRecordIdSet.add(data.getPkValue());
        }
        if (!oldWfRecordIdSet.isEmpty()) {
            OperateOption option;
            MainEntityType oldRecordEntity = MetadataServiceHelper.getDataEntityType((String)oldRecordEntityNUm);
            DynamicObject[] oldRecords = BusinessDataServiceHelper.load((Object[])oldWfRecordIdSet.toArray(), (DynamicObjectType)oldRecordEntity);
            OperationResult result = OperationServiceHelper.executeOperate((String)"unverify", (String)oldRecordEntityNUm, (DynamicObject[])oldRecords, (OperateOption)(option = OperateOption.create()));
            if (!result.isSuccess()) {
                StringBuilder errorInfo = new StringBuilder();
                errorInfo.append(result.getMessage());
                for (IOperateInfo info : result.getAllErrorOrValidateInfo()) {
                    errorInfo.append(info.getMessage());
                }
                throw new KDBizException(errorInfo.toString());
            }
        }
    }

    private String getRecordEntityNum(String wfRecordEntityNum) {
        if ("cal_purwfrecord".equals(wfRecordEntityNum)) {
            return "ap_verifyrecord";
        }
        return "ar_verifyrecord";
    }
}

