/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import org.apache.commons.lang3.StringUtils;

public class BcmFormula {
    private String formulaName;
    private String paramJson;
    private Map<String, Object> commonParam = new HashMap<String, Object>(10);
    private Map<String, List<Object>> paramListMap;
    private Map<String, Integer> fieldIndexMap = new HashMap<String, Integer>(20);
    private Map<String, Map<String, Object>> results = new HashMap<String, Map<String, Object>>();

    public BcmFormula(String formulaName, String paramJson, String formulaJsonFileName) {
        this.formulaName = formulaName;
        this.paramJson = paramJson;
        Map paramMap = (Map)SerializationUtils.fromJsonString((String)paramJson, Map.class);
        this.paramListMap = (Map)paramMap.get("param");
        this.commonParam = (Map)paramMap.get("commParam");
        List formulaParamNames = (List)this.commonParam.get("formulaParamNames");
        for (int i = 0; i < formulaParamNames.size(); ++i) {
            this.fieldIndexMap.put((String)formulaParamNames.get(i), i);
        }
    }

    public boolean existsParam(String paramKey) {
        return this.fieldIndexMap.containsKey(paramKey);
    }

    public long getOrgId(String formulaId) {
        DynamicObject org;
        String orgNumber = this.getString(this.paramListMap.get(formulaId), this.fieldIndexMap.get("org"));
        if (StringUtils.isBlank((CharSequence)orgNumber)) {
            orgNumber = (String)this.commonParam.get("org");
        }
        if ((org = QueryServiceHelper.queryOne((String)"bos_org", (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)orgNumber)})) == null) {
            throw new KDBizException("Can't find org by number:" + orgNumber);
        }
        return org.getLong("id");
    }

    public void putResult(String formulaId, String text) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", 2);
        hashMap.put("v", text);
        this.results.put(formulaId, hashMap);
    }

    public void putResult(String formulaId, Exception e) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("type", -1);
        if (e instanceof KDBizException) {
            hashMap.put("v", e.getMessage());
        } else {
            StringBuilder sb = new StringBuilder();
            StackTraceElement[] stackArray = e.getStackTrace();
            for (int i = 0; i < stackArray.length; ++i) {
                StackTraceElement element = stackArray[i];
                sb.append(element).append('\n');
            }
            hashMap.put("v", sb.toString());
        }
        this.results.put(formulaId, hashMap);
    }

    public void putResult(String formulaId, Date date) {
        HashMap<String, Comparable<Integer>> hashMap = new HashMap<String, Comparable<Integer>>();
        hashMap.put("type", Integer.valueOf(3));
        hashMap.put("v", date);
        this.results.put(formulaId, hashMap);
    }

    public void putResult(String formulaId, BigDecimal result) {
        HashMap<String, BigDecimal> hashMap = new HashMap<String, BigDecimal>();
        hashMap.put("v", result);
        this.results.put(formulaId, hashMap);
    }

    public Map<String, Map<String, Object>> getResults() {
        return this.results;
    }

    public Set<String> formulaIdSet() {
        return this.paramListMap.keySet();
    }

    public Integer getInt(String formulaId, String paramKey) {
        Object param = this.paramListMap.get(formulaId).get(this.fieldIndexMap.get(paramKey));
        if (param instanceof Long) {
            param = Integer.parseInt(String.valueOf(param));
        } else if (param instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)param))) {
                return 0;
            }
            param = Integer.valueOf((String)param);
        }
        return (Integer)param;
    }

    public Date getDate(String formulaId, String paramKey) {
        Object param = this.paramListMap.get(formulaId).get(this.fieldIndexMap.get(paramKey));
        if (param instanceof Date) {
            return (Date)param;
        }
        if (param instanceof String) {
            if (StringUtils.isBlank((CharSequence)((String)param))) {
                return null;
            }
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            try {
                return simpleDateFormat.parse((String)param);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("Unknow type for date value." + param);
    }

    public long getBasedataId(String formulaId, String paramKey, String entityKey) {
        String number = this.getString(this.paramListMap.get(formulaId), this.fieldIndexMap.get(paramKey));
        DynamicObject basedata = QueryServiceHelper.queryOne((String)entityKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        if (basedata == null) {
            throw new KDBizException("basedata not found.number=" + number + ",entityKey=" + entityKey);
        }
        return basedata.getLong("id");
    }

    public List<Object> getBasedataIds(String formulaId, String paramKey, String entityKey) {
        String number = this.getString(this.paramListMap.get(formulaId), this.fieldIndexMap.get(paramKey));
        DynamicObjectCollection basedatas = QueryServiceHelper.query((String)entityKey, (String)"id", (QFilter[])new QFilter[]{new QFilter("number", "=", (Object)number)});
        ArrayList<Object> ids = new ArrayList<Object>(basedatas.size());
        for (DynamicObject basedata : basedatas) {
            ids.add(basedata.get("id"));
        }
        return ids;
    }

    public String getString(String formulaId, String paramKey) {
        return this.getString(this.paramListMap.get(formulaId), this.fieldIndexMap.get(paramKey));
    }

    private String getString(List<Object> values, int index) {
        return (String)values.get(index);
    }

    public Date getLastDayOfMonth() {
        String endDate = (String)this.commonParam.get("endDate");
        if (endDate == null) {
            return null;
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return simpleDateFormat.parse(endDate);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public String getFormulaName() {
        return this.formulaName;
    }

    public void setFormulaName(String formulaName) {
        this.formulaName = formulaName;
    }

    public String getParamJson() {
        return this.paramJson;
    }

    public void setParamJson(String paramJson) {
        this.paramJson = paramJson;
    }
}

