/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;

@KSObject
public class BizTypeDisplayNameProvider {
    private Map<String, ILocaleString> displayNameCache = new HashMap<String, ILocaleString>();

    public BizTypeDisplayNameProvider(String ... entityKeys) {
        ArrayList<String> billTypeEntityKeys = new ArrayList<String>();
        boolean containsSettleRecord = false;
        for (String string : entityKeys) {
            if ("ap_settlerecord".equals(string) || "ar_settlerecord".equals(string)) {
                containsSettleRecord = true;
                continue;
            }
            if ("ap_paidbill".equals(string)) {
                this.displayNameCache.put("ap_paidbill", (ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u9884\u4ed8\u5355", (String)"BizTypeDisplayNameProvider_0", (String)"fi-arapcommon", (Object[])new Object[0])));
            } else if ("ar_receivedbill".equals(string)) {
                this.displayNameCache.put("ar_receivedbill", (ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u9884\u6536\u5355", (String)"BizTypeDisplayNameProvider_1", (String)"fi-arapcommon", (Object[])new Object[0])));
            } else if ("cas_recbill".equals(string)) {
                this.displayNameCache.put("SalesRec", (ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u9500\u552e\u6536\u6b3e", (String)"BizTypeDisplayNameProvider_2", (String)"fi-arapcommon", (Object[])new Object[0])));
                this.displayNameCache.put("OtherRec", (ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u5176\u4ed6\u6536\u6b3e", (String)"BizTypeDisplayNameProvider_3", (String)"fi-arapcommon", (Object[])new Object[0])));
            }
            billTypeEntityKeys.add(string);
        }
        if (!billTypeEntityKeys.isEmpty()) {
            QFilter[] qFilterArray = new QFilter[]{new QFilter("billformid", "in", billTypeEntityKeys)};
            Map billTypeMap = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"name,number", (QFilter[])qFilterArray);
            for (DynamicObject dynamicObject : billTypeMap.values()) {
                this.displayNameCache.put(dynamicObject.getString("number"), dynamicObject.getLocaleString("name"));
            }
        }
        if (containsSettleRecord) {
            for (SettleRelationEnum settleRelationEnum : SettleRelationEnum.values()) {
                this.displayNameCache.put(settleRelationEnum.getValue(), (ILocaleString)new LocaleString(settleRelationEnum.getName()));
            }
        }
        this.displayNameCache.put("BusAdjust", (ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u6682\u4f30\u7ea2\u51b2\u5355", (String)"BizTypeDisplayNameProvider_4", (String)"fi-arapcommon", (Object[])new Object[0])));
        this.displayNameCache.put("adjustExchange", (ILocaleString)new LocaleString(ResManager.loadKDString((String)"\u671f\u672b\u8c03\u6c47", (String)"BizTypeDisplayNameProvider_5", (String)"fi-arapcommon", (Object[])new Object[0])));
    }

    @KSMethod
    public ILocaleString getDisplayName(String bizType) {
        return this.displayNameCache.get(bizType);
    }
}

