/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.DynamicObjectJsonValue;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.FilterItemInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.RptCustomSettingParser;

public class DefaultCustomSettingParser
implements RptCustomSettingParser {
    protected ReportQueryParam queryParam;

    public DefaultCustomSettingParser(ReportQueryParam queryParam) {
        this.queryParam = queryParam;
    }

    @Override
    public List<String> getStatisticalDimensions() {
        ArrayList<String> dimensions = new ArrayList<String>();
        String setting = this.queryParam.getFilter().getString("statisticaldimension");
        dimensions.addAll(Arrays.asList(setting.split(",")));
        if (!dimensions.contains("currency")) {
            dimensions.add("currency");
        }
        if (!dimensions.contains("basecurrency") && this.showBaseCurrency()) {
            dimensions.add("basecurrency");
        }
        return dimensions;
    }

    @Override
    public List<String> getSumDimensions() {
        return Collections.emptyList();
    }

    @Override
    public List<QFilter> getCustomFilters() {
        FilterInfo filterInfo = this.queryParam.getFilter();
        ArrayList<QFilter> customFilters = new ArrayList<QFilter>();
        Boolean isHyperLinkClickByGroup = Boolean.FALSE;
        FilterItemInfo filterItem = filterInfo.getFilterItem("isHyperLinkClickByGroup");
        if (filterItem != null) {
            isHyperLinkClickByGroup = (Boolean)filterItem.getValue();
        }
        for (FilterItemInfo item : filterInfo.getFilterItems()) {
            String propName = item.getPropName();
            Object value = item.getValue();
            String filterProp = null;
            if (propName.startsWith("q_") && !"q_asstacttype".equals(propName)) {
                filterProp = propName.substring(2);
            } else if (propName.endsWith("_s")) {
                filterProp = propName.substring(0, propName.length() - 2);
            }
            if (filterProp != null && !ObjectUtils.isEmpty((Object)value)) {
                if (value instanceof DynamicObjectJsonValue) {
                    DynamicObjectCollection values = filterInfo.getDynamicObjectCollection(propName);
                    customFilters.add(new QFilter(filterProp, "in", DynamicObjectHelper.getLongIds((Collection<DynamicObject>)values)));
                } else if (value instanceof DynamicObjectCollection) {
                    List<Long> customItemIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)((DynamicObjectCollection)value));
                    customFilters.add(new QFilter(filterProp, "in", customItemIds));
                } else if (value instanceof DynamicObject) {
                    customFilters.add(new QFilter(filterProp, "=", ((DynamicObject)value).getPkValue()));
                } else {
                    customFilters.add(new QFilter(filterProp, "=", value));
                }
            }
            if (!isHyperLinkClickByGroup.booleanValue() || filterProp == null || !ObjectUtils.isEmpty((Object)value)) continue;
            if (propName.endsWith("_s")) {
                filterProp = propName.substring(0, propName.length() - 2);
                customFilters.add(new QFilter(filterProp, "=", (Object)0L));
            }
            if (!propName.startsWith("q_") || "q_asstacttype".equals(propName) || "q_currency".equals(propName)) continue;
            filterProp = propName.substring(2);
            customFilters.add(new QFilter(filterProp, "=", (Object)0L));
        }
        List directCustomFilters = (List)filterInfo.getValue("customfilters");
        if (directCustomFilters != null) {
            customFilters.addAll(directCustomFilters);
        }
        return customFilters;
    }

    @Override
    public List<String> getTotalSumDimensions() {
        return Collections.emptyList();
    }

    @Override
    public List<String> getSortFields() {
        return this.getStatisticalDimensions();
    }

    @Override
    public boolean showBaseCurrency() {
        return this.queryParam.getFilter().getBoolean("showmaincurrency");
    }
}

