/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report;

import java.util.List;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.report.events.CreateColumnEvent;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.report.DefaultCustomSettingParser;

public class RptDimensionColumnControlPlugin
extends AbstractReportFormPlugin {
    public void afterCreateColumn(CreateColumnEvent event) {
        super.afterCreateColumn(event);
        BalJouMapper mapper = BalJouMapper.getMapper(this.isAp());
        BalanceSettingParser balanceSettingParser = new BalanceSettingParser(mapper);
        List<String> balanceDimensions = balanceSettingParser.getBalanceDimensions();
        List<String> queryDimension = this.getQueryDimension();
        List columns = event.getColumns();
        for (AbstractReportColumn column : columns) {
            String columnKey;
            if (!this.isDimensionColumn(column, balanceDimensions) || queryDimension.contains(columnKey = ((ReportColumn)column).getFieldKey())) continue;
            ((ReportColumn)column).setHide(true);
        }
    }

    protected List<String> getQueryDimension() {
        DefaultCustomSettingParser settingParser = new DefaultCustomSettingParser(this.getQueryParam());
        return settingParser.getStatisticalDimensions();
    }

    protected boolean isDimensionColumn(AbstractReportColumn column, List<String> balanceDimensions) {
        String columnKey;
        return column instanceof ReportColumn && balanceDimensions.contains(columnKey = ((ReportColumn)column).getFieldKey());
    }

    protected boolean isAp() {
        String entityId = this.getView().getEntityId();
        if (entityId.startsWith("ap")) {
            return true;
        }
        if (entityId.startsWith("ar")) {
            return false;
        }
        throw new IllegalArgumentException("unknown form prefix,only 'ap' or 'ar' is accepted. Current form is :" + entityId);
    }
}

