/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.DataSetUtils;

public class AcctageFinAmtReverser
implements AcctageAmtReverser {
    private DataSet settleRecords;
    private AcctageRptParam param;

    public AcctageFinAmtReverser(DataSet settleRecords, AcctageRptParam param) {
        this.settleRecords = settleRecords;
        this.param = param;
    }

    @Override
    public DataSet reverse(DataSet ds) {
        JoinDataSet joinDataSet = ds.join(this.settleRecords, JoinType.LEFT).on("id", "mainbillid");
        List<String> selectedFields = DataSetUtils.getSelectedFields(ds, "balance", "localbalance");
        selectedFields.add("case when totalsettleamt=null then balance else balance+totalsettleamt end as balance");
        if (this.param.getAnalysisAmtFields().length > 1) {
            selectedFields.add("case when localtotalsettleamt=null then localbalance else localbalance+localtotalsettleamt end as localbalance");
        }
        if (this.param.getAnalysisAmtFields().length > 1) {
            DataSet adjExchBills = AcctageHelper.getAdjExchBillForOldAcctage(this.param);
            DataSet finbills = joinDataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
            JoinDataSet adjJoinDataSet = finbills.leftJoin(adjExchBills).on("id", "sourcebillid");
            List<String> selectedFields1 = DataSetUtils.getSelectedFields(finbills, "localbalance");
            selectedFields1.add("case when curgainloss=null then localbalance else localbalance+curgainloss end as localbalance");
            return adjJoinDataSet.select(selectedFields1.toArray(new String[0]), new String[0]).finish();
        }
        return joinDataSet.select(selectedFields.toArray(new String[0]), new String[0]).finish();
    }
}

