/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.user.UserConfigServiceHelper;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class AcctageHelper {
    private static final String AR_ACCTAGERPT_SETTING_KEY = "ar_acctagesetting";
    private static final String AP_ACCTAGERPT_SETTING_KEY = "ap_acctagesetting";
    private static ThreadLocal<DataSet> dataSetHolder = new ThreadLocal();

    public static boolean match(AcctageGroup group, Date baseDate, Date compareDate) {
        if (compareDate == null) {
            return group.beginDay == null;
        }
        int diffDays = DateUtils.getDiffDaysIgnoreTime(compareDate, baseDate);
        if (group.beginDay != null && group.endDay != null) {
            return diffDays >= group.beginDay && diffDays <= group.endDay;
        }
        if (group.beginDay == null) {
            return diffDays <= group.endDay;
        }
        if (group.endDay == null) {
            return diffDays >= group.beginDay;
        }
        return false;
    }

    @Deprecated
    public static String getAmountFieldName(AcctageGroup group) {
        if (group.beginDay == null) {
            return "groupamount";
        }
        return "groupamount" + group.beginDay;
    }

    public static String getAmountFieldName(AcctageGroup group, String extraMark) {
        if (group.beginDay == null) {
            return extraMark + "D";
        }
        if (group.beginDay < 0) {
            return extraMark + "N" + -group.beginDay.intValue();
        }
        return extraMark + group.beginDay;
    }

    public static List<AcctageGroup> getGroups(boolean isAr, String groupKey) {
        String settingJson = UserConfigServiceHelper.getSetting((long)AcctageHelper.getCurrentUserID(), (String)groupKey);
        if (settingJson != null && !settingJson.trim().isEmpty()) {
            return SerializationUtils.fromJsonStringToList((String)settingJson, AcctageGroup.class);
        }
        return AcctageHelper.getDefaultGroups(isAr);
    }

    public static List<AcctageGroup> getGroups(boolean isAr) {
        String settingJson = UserConfigServiceHelper.getSetting((long)AcctageHelper.getCurrentUserID(), (String)AcctageHelper.getSettingKey(isAr));
        if (settingJson != null && !settingJson.trim().isEmpty()) {
            return SerializationUtils.fromJsonStringToList((String)settingJson, AcctageGroup.class);
        }
        return AcctageHelper.getDefaultGroups(isAr);
    }

    public static List<AcctageGroup> getGroupsWithAgingGroup(String groupKey) {
        String settingJson = UserConfigServiceHelper.getSetting((long)AcctageHelper.getCurrentUserID(), (String)groupKey);
        if (settingJson != null && !settingJson.trim().isEmpty()) {
            return SerializationUtils.fromJsonStringToList((String)settingJson, AcctageGroup.class);
        }
        return new ArrayList<AcctageGroup>(8);
    }

    public static boolean saveGroupSetting(List<AcctageGroup> groups, boolean isAr, String groupKey) {
        String jsonString = SerializationUtils.toJsonString(groups);
        return UserConfigServiceHelper.setSetting((long)AcctageHelper.getCurrentUserID(), (String)groupKey, (String)jsonString);
    }

    public static boolean saveGroupSetting(List<AcctageGroup> groups, boolean isAr) {
        String jsonString = SerializationUtils.toJsonString(groups);
        return UserConfigServiceHelper.setSetting((long)AcctageHelper.getCurrentUserID(), (String)AcctageHelper.getSettingKey(isAr), (String)jsonString);
    }

    public static List<AcctageGroup> getDefaultGroups(boolean isAr) {
        ArrayList<AcctageGroup> groups = new ArrayList<AcctageGroup>();
        groups.add(new AcctageGroup(ResManager.loadKDString((String)"0\uff5e30\u5929", (String)"AcctageHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), 0, 30));
        groups.add(new AcctageGroup(ResManager.loadKDString((String)"31\uff5e60\u5929", (String)"AcctageHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), 31, 60));
        groups.add(new AcctageGroup(ResManager.loadKDString((String)"61\uff5e90\u5929", (String)"AcctageHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]), 61, 90));
        groups.add(new AcctageGroup(ResManager.loadKDString((String)"90\u5929\u4ee5\u4e0a", (String)"AcctageHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]), 91, null));
        return groups;
    }

    private static String getSettingKey(boolean isAr) {
        return isAr ? AR_ACCTAGERPT_SETTING_KEY : AP_ACCTAGERPT_SETTING_KEY;
    }

    private static long getCurrentUserID() {
        return RequestContext.get().getCurrUserId();
    }

    public static void putIntoThreadLocal(DataSet ds) {
        dataSetHolder.set(ds);
    }

    public static DataSet getFromThreadLocal() {
        DataSet dataSet = dataSetHolder.get();
        dataSetHolder.remove();
        return dataSet;
    }

    public static List<String> getBalanceGroupCols(Set<String> showQtyCols, List<AcctageGroup> groups) {
        ArrayList<String> balanceCols = new ArrayList<String>(2);
        for (String showQtyCol : showQtyCols) {
            if (!StringUtils.contains((String)showQtyCol, (String)"balance")) continue;
            for (AcctageGroup group : groups) {
                balanceCols.add(AcctageHelper.getAmountFieldName(group, showQtyCol));
            }
        }
        return balanceCols;
    }

    public static List<Long> getPrevPeriod4Date(AcctageRptParam param) {
        return AcctageHelper.getPrevPeriod4Date(param.getEntity(), param.getOrgIds(), param.getQueryDate());
    }

    public static List<Long> getPrevPeriod4Date(String entityKey, List<Object> orgIds, Date queryDate) {
        Set<Long> periodtypePks = null;
        if (orgIds != null && orgIds.size() > 0) {
            boolean isAr = StringUtils.contains((String)entityKey, (String)"ar_");
            QFilter qFilter = new QFilter("org", "in", orgIds);
            DynamicObjectCollection inits = QueryServiceHelper.query((String)(isAr ? "ar_init" : "ap_init"), (String)"org, periodtype", (QFilter[])new QFilter[]{qFilter});
            periodtypePks = inits.stream().map(i -> i.getLong("periodtype")).collect(Collectors.toSet());
        } else {
            periodtypePks = new HashSet<Long>(1);
            periodtypePks.add(1L);
        }
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)queryDate), new QFilter("enddate", ">=", (Object)queryDate), new QFilter("periodtype", "in", periodtypePks)};
        Map periodMap = BusinessDataServiceHelper.loadFromCache((String)"bd_period", (String)"id, periodtype, periodyear, periodnumber", (QFilter[])filters);
        List<Long> prePeriodPks = PeriodHelper.getPrevPeriod(periodMap.values());
        return prePeriodPks;
    }

    public static Map<Long, List<Long>> getPreviousPeriodEndDate(String entityKey, List<Object> orgIds, Date queryDate) {
        HashMap<Long, List<Long>> map = new HashMap<Long, List<Long>>(2);
        if (ObjectUtils.isEmpty(orgIds)) {
            return map;
        }
        boolean isAr = StringUtils.contains((String)entityKey, (String)"ar_");
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObjectCollection inits = QueryServiceHelper.query((String)(isAr ? "ar_init" : "ap_init"), (String)"org,periodtype,startperiod.periodyear,startperiod.periodnumber", (QFilter[])new QFilter[]{orgFilter});
        Set periodtypeIds = inits.stream().map(i -> i.getLong("periodtype")).collect(Collectors.toSet());
        QFilter[] filters = new QFilter[]{new QFilter("begindate", "<=", (Object)queryDate), new QFilter("enddate", ">=", (Object)queryDate), new QFilter("periodtype", "in", periodtypeIds)};
        DynamicObjectCollection periods = QueryServiceHelper.query((String)"bd_period", (String)"id,periodtype,periodyear,periodnumber,begindate, enddate", (QFilter[])filters);
        HashSet<Long> queryDatePeriods = new HashSet<Long>(8);
        for (DynamicObject period : periods) {
            if (queryDate.compareTo(period.getDate("enddate")) != 0) continue;
            queryDatePeriods.add(period.getLong("id"));
        }
        HashSet<Long> queryDateOrgId = new HashSet<Long>(8);
        if (!queryDatePeriods.isEmpty()) {
            HashMap<Long, Object> periodTypeAndPeriod = new HashMap<Long, Object>(8);
            for (Object period : periods) {
                periodTypeAndPeriod.put(period.getLong("periodtype"), period);
            }
            HashMap<Long, Long> orgAndQueryPeriod = new HashMap<Long, Long>(8);
            for (DynamicObject init : inits) {
                boolean isPeriod;
                DynamicObject period = (DynamicObject)periodTypeAndPeriod.get(init.getLong("periodtype"));
                if (period == null || !queryDatePeriods.contains(period.getLong("id"))) continue;
                boolean bl = isPeriod = period.getInt("periodyear") < init.getInt("startperiod.periodyear") || period.getInt("periodyear") == init.getInt("startperiod.periodyear") && period.getInt("periodnumber") < init.getInt("startperiod.periodnumber");
                if (isPeriod) {
                    orgAndQueryPeriod.put(init.getLong("org"), 0L);
                    continue;
                }
                orgAndQueryPeriod.put(init.getLong("org"), period.getLong("id"));
            }
            DynamicObjectCollection adjExchRecords = QueryServiceHelper.query((String)(isAr ? "ar_adjustexch" : "ap_adjustexch"), (String)"id,org,period", (QFilter[])new QFilter[]{new QFilter("org", "in", orgAndQueryPeriod.keySet()), new QFilter("period", "in", orgAndQueryPeriod.values()), new QFilter("isadjexch", "=", (Object)Boolean.TRUE), new QFilter("bizsystem", "=", (Object)(isAr ? "AR" : "AP"))});
            if (adjExchRecords != null && !adjExchRecords.isEmpty()) {
                Date adjPrcDate = DateUtils.getDataFormat(queryDate, true);
                long time = adjPrcDate.getTime();
                for (DynamicObject adjExchRecord : adjExchRecords) {
                    Long orgId = adjExchRecord.getLong("org");
                    if (!((Long)orgAndQueryPeriod.get(orgId)).equals(adjExchRecord.getLong("period"))) continue;
                    queryDateOrgId.add(orgId);
                    List orgIdList = map.getOrDefault(time, new ArrayList(2));
                    orgIdList.add(orgId);
                    map.put(time, orgIdList);
                }
            }
        }
        HashMap<Long, Date> bizDateMap = new HashMap<Long, Date>(2);
        for (Object period : periods) {
            long periodTypeId = period.getLong("periodtype");
            Date startDate = period.getDate("begindate");
            bizDateMap.put(periodTypeId, DateUtils.getDataFormat(DateUtils.getLastDay(startDate, 1), true));
        }
        for (DynamicObject init : inits) {
            Date date;
            long periodTypeId = init.getLong("periodtype");
            long orgId = init.getLong("org");
            if (queryDateOrgId.contains(orgId) || (date = (Date)bizDateMap.get(periodTypeId)) == null) continue;
            long time = date.getTime();
            ArrayList<Long> orgIdList = (ArrayList<Long>)map.get(time);
            if (orgIdList == null) {
                orgIdList = new ArrayList<Long>(2);
            }
            orgIdList.add(orgId);
            map.put(time, orgIdList);
        }
        return map;
    }

    public static DataSet getAdjExchBill(AcctageRptParam param, List<Long> prePeriodPks) {
        List<Object> currencyIds;
        boolean isAr = StringUtils.contains((String)param.getEntity(), (String)"ar_");
        String adjEntityKey = isAr ? "ar_adjustexchbill" : "ap_adjexchbill";
        QFilter adjFilter = new QFilter("sourcebilltype", "=", (Object)param.getEntity());
        adjFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        List<Object> orgIds = param.getOrgIds();
        if (orgIds != null && orgIds.size() > 0) {
            adjFilter.and(new QFilter("org", "in", orgIds));
        }
        adjFilter.and(new QFilter("period", "in", prePeriodPks));
        adjFilter.and(new QFilter("asstacttype", "=", (Object)param.getAsstactType()));
        List<Object> asstactPks = param.getAsstactPks();
        if (asstactPks != null && asstactPks.size() > 0) {
            adjFilter.and(new QFilter("asstact", "in", asstactPks));
        }
        if (!ObjectUtils.isEmpty(currencyIds = param.getCurrencyIds())) {
            adjFilter.and(new QFilter("currency", "in", currencyIds));
        }
        DataSet adjExchBills = QueryServiceHelper.queryDataSet((String)"adjustexchbill", (String)adjEntityKey, (String)"sourcebillid, curgainloss", (QFilter[])new QFilter[]{adjFilter}, null);
        return adjExchBills;
    }

    public static DataSet getAdjExchBillForOldAcctage(AcctageRptParam param) {
        List<Object> currencyIds;
        List<Object> asstactPks;
        boolean isAr = StringUtils.contains((String)param.getEntity(), (String)"ar_");
        String adjEntityKey = isAr ? "ar_adjustexchbill" : "ap_adjexchbill";
        QFilter adjFilter = new QFilter("sourcebilltype", "=", (Object)param.getEntity());
        adjFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        String asstactType = param.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            adjFilter.and(new QFilter("asstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty(asstactPks = param.getAsstactPks())) {
            adjFilter.and(new QFilter("asstact", "in", asstactPks));
        }
        if (!ObjectUtils.isEmpty(currencyIds = param.getCurrencyIds())) {
            adjFilter.and(new QFilter("currency", "in", currencyIds));
        }
        DataSet adjExchBills = null;
        Map<Long, List<Long>> map = AcctageHelper.getPreviousPeriodEndDate(adjEntityKey, param.getOrgIds(), param.getQueryDate());
        for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
            Date bizDate = new Date(entry.getKey());
            List<Long> orgIds = entry.getValue();
            adjFilter.and("org", "in", orgIds);
            adjFilter.and("bizdate", "=", (Object)bizDate);
            DataSet tempAdjExchBills = QueryServiceHelper.queryDataSet((String)"adjustexchbill", (String)adjEntityKey, (String)"sourcebillid, curgainloss", (QFilter[])new QFilter[]{adjFilter}, null);
            if (adjExchBills == null) {
                adjExchBills = tempAdjExchBills;
                continue;
            }
            adjExchBills = adjExchBills.union(tempAdjExchBills);
        }
        return adjExchBills;
    }
}

