/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.IPreAcctageRptProvider;
import kd.fi.arapcommon.report.acctage.PreAcctageRptParam;

public class PreAcctageRptRecBill
implements IPreAcctageRptProvider {
    @Override
    public String getOrgEntity() {
        return "entry.e_settleorg";
    }

    @Override
    public String getAsstactTypeEntity() {
        return "payertype";
    }

    @Override
    public String getAsstactEntity() {
        return "payer";
    }

    @Override
    public String getCurrencyEntity() {
        return "currency";
    }

    @Override
    public String getDateEntity(String standard) {
        if ("paydate".equals(standard)) {
            return "payeedate";
        }
        return "bizdate";
    }

    @Override
    public String[] getBillStatus(boolean containson) {
        if (containson) {
            return new String[]{"A", "B", "C", "D", "E"};
        }
        return new String[]{"D"};
    }

    @Override
    public String getPaymentBillTypeEntity() {
        return "entry.e_receivingtype";
    }

    @Override
    public List<String> selectFields(PreAcctageRptParam param) {
        ArrayList<String> selectFields = new ArrayList<String>(18);
        List<String> statisticalDimensions = param.getStatisticalSumParam().getGroupByFields();
        selectFields.add("entry.id as id");
        if (statisticalDimensions.contains("org")) {
            selectFields.add("entry.e_settleorg as org");
        }
        if (statisticalDimensions.contains("payorg")) {
            selectFields.add("org as payorg");
        }
        selectFields.add("'cas_recbill' as entitykey");
        selectFields.add("payertype as asstacttype");
        if ("other".equals(param.getAsstactType())) {
            selectFields.add("payername as asstact_name");
            selectFields.add("payername as asstact");
        } else {
            selectFields.add("payer as asstact");
            selectFields.add("payername as asstact_name");
        }
        selectFields.add("basecurrency");
        selectFields.add("currency");
        if (param.isShowbybill()) {
            selectFields.add("entry.e_receivingtype as paymentbilltype");
            selectFields.add("billno");
        }
        selectFields.add("bizdate");
        selectFields.add("payeedate as paydate");
        selectFields.add("entry.e_receivableamt as recamt");
        selectFields.add("entry.e_unsettledamt as balance");
        if (param.isShowlocalamt()) {
            selectFields.add("ROUND(entry.e_receivablelocamt,2) as localrecamt");
            selectFields.add("ROUND(entry.e_unsettledlocalamt,2) as localbalance");
        }
        return selectFields;
    }

    @Override
    public List<String> getHideFields(ReportQueryParam queryParam) {
        ArrayList<String> selectFields = new ArrayList<String>(18);
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isShowbybill = filterInfo.getBoolean("showbybill");
        boolean isShowlocalamt = filterInfo.getBoolean("showlocalamt");
        String statisticaldimension = filterInfo.getString("statisticaldimension");
        String[] statisticaldimensions = statisticaldimension.split("[,]");
        List<String> statisticaldimensionsList = Arrays.asList(statisticaldimensions);
        selectFields.add("id");
        if (statisticaldimensionsList.contains("org")) {
            selectFields.add("org");
        }
        if (statisticaldimensionsList.contains("payorg")) {
            selectFields.add("payorg");
        }
        selectFields.add("asstacttype");
        selectFields.add("asstact_name");
        selectFields.add("asstact");
        selectFields.add("currency");
        if (isShowbybill) {
            selectFields.add("paymentbilltype");
            selectFields.add("billno");
            selectFields.add("bizdate");
            if (!filterInfo.getString("standard").contains("bizdate")) {
                selectFields.add("paydate");
            }
        }
        selectFields.add("entitykey");
        selectFields.add("recamt");
        selectFields.add("balance");
        if (isShowlocalamt) {
            selectFields.add("basecurrency");
            selectFields.add("localrecamt");
            selectFields.add("localbalance");
        }
        return selectFields;
    }

    @Override
    public SumParam afterLoadBillSumField(PreAcctageRptParam param) {
        SumParam sumParam = new SumParam(SumParam.SumType.SUM);
        sumParam.addGroupByField("id");
        if (param.isShowlocalamt()) {
            sumParam.addSummaryField("balance", "recamt", "localbalance", "localrecamt");
            return sumParam;
        }
        sumParam.addSummaryField("balance", "recamt");
        return sumParam;
    }

    @Override
    public List<QFilter> queryBillFilter() {
        ArrayList<QFilter> qFilters = new ArrayList<QFilter>(2);
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".biztype", "=", (Object)"101"));
        qFilters.add(new QFilter(this.getPaymentBillTypeEntity() + ".ispartreceivable", "=", (Object)"1"));
        return qFilters;
    }
}

