/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import kd.bos.algo.DataSet;
import kd.bos.algo.Output;
import kd.bos.algo.Row;
import kd.bos.algo.output.DataSetOutput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import kd.fi.arapcommon.report.acctagev2.IAcctage;
import kd.fi.arapcommon.report.acctagev2.transform.AddReverseJoin;

public abstract class AbstractAcctage
implements IAcctage {
    protected ReportDataCtx ctx;
    protected AcctageParam reportParam;
    protected String entityKey;

    public AbstractAcctage(ReportDataCtx ctx) {
        this.ctx = ctx;
        this.reportParam = (AcctageParam)ctx.getParam(AcctageParam.class.getName());
    }

    @Override
    public void modifyBlock(SrcBlockConf blockConf) {
        this.reportParam.setRecoverHistoryData(true);
        DataSetX reverseDataSetX = this.getReserveDataSetX();
        Set<Long> reversePks = this.getReversePks(reverseDataSetX);
        QFilter filter = this.getSrcBlockFilter(reversePks);
        QFilter dataFs = blockConf.getDataFs();
        if (dataFs != null) {
            filter.and(dataFs);
        }
        blockConf.setDataFs(filter);
        blockConf.getRepoColFullSrcColMap().put("billstatus", "billstatus");
        if ("ap_finapbill".equals(this.entityKey)) {
            blockConf.getRepoColFullSrcColMap().put("billtypeid", "billtypeid");
        }
        blockConf.setAllowNotMatch(true);
        if (this.reportParam.isRecoverHistoryData()) {
            blockConf.getDataTransform().add(new AddReverseJoin(this.ctx, this.entityKey, reverseDataSetX));
        }
    }

    private Set<Long> getReversePks(DataSetX reverseDataSetX) {
        HashSet<Long> reversePks = new HashSet<Long>(8);
        JobSession session = this.ctx.getCurrentJob();
        DataSetX outReverseDs = reverseDataSetX;
        DataSetOutput out = new DataSetOutput(outReverseDs.getRowMeta());
        String id = out.getId();
        outReverseDs.output((Output)out);
        session.commit(this.ctx.getReportConf().getTimeOut(), TimeUnit.MINUTES);
        DataSet result = session.readDataSet(id);
        for (Row row : result) {
            reversePks.add(row.getLong(outReverseDs.getRowMeta().getFieldName(0)));
        }
        result.close();
        return reversePks;
    }

    protected abstract QFilter getSrcBlockFilter(Set<Long> var1);

    protected abstract DataSetX getReserveDataSetX();

    protected QFilter getAdjExchFilter() {
        QFilter qFilter = null;
        if (this.reportParam.isShowLocalAmt()) {
            qFilter = this.getAdjExchCommonFilter();
        }
        return qFilter;
    }

    private QFilter getAdjExchCommonFilter() {
        List<Object> currencyIds;
        List<Object> asstactPks;
        QFilter qFilter = new QFilter("sourcebilltype", "=", (Object)this.entityKey);
        qFilter.and(new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()));
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            qFilter.and(new QFilter("asstacttype", "=", (Object)asstactType));
        }
        if ((asstactPks = this.reportParam.getAsstactPks()) != null && asstactPks.size() > 0) {
            qFilter.and(new QFilter("asstact", "in", asstactPks));
        }
        if (!ObjectUtils.isEmpty(currencyIds = this.reportParam.getCurrencyIds())) {
            qFilter.and(new QFilter("currency", "in", currencyIds));
        }
        return qFilter;
    }
}

