/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.ValueMapItem;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.entity.property.ComboProp;
import kd.bos.entity.property.DateTimeProp;
import kd.bos.entity.property.ItemClassProp;
import kd.bos.entity.property.MulBasedataProp;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.CloseCallBack;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageTypes;
import kd.bos.form.ShowFormHelper;
import kd.bos.form.ShowType;
import kd.bos.form.container.Container;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bos.report.filter.ReportFilter;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class AcctageForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private List<Long> orgIds = null;
    private ReportConf confCache;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("orgs");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getOrgIds()));
        });
        BasedataEdit billTypeEdit = (BasedataEdit)this.getControl("billtypes");
        billTypeEdit.addBeforeF7SelectListener(listener -> {
            ListShowParameter formShowParameter = (ListShowParameter)listener.getFormShowParameter();
            String billScope = (String)this.getModel().getValue("sourceentity");
            LinkedList<String> billScopes = new LinkedList<String>();
            if ("ALL".equals(billScope)) {
                if (this.isAr()) {
                    billScopes.add("ar_finarbill");
                    billScopes.add("ar_busbill");
                } else {
                    billScopes.add("ap_finapbill");
                    billScopes.add("ap_busbill");
                }
            }
            if (billScope.contains("fin")) {
                if (this.isAr()) {
                    billScopes.add("ar_finarbill");
                } else {
                    billScopes.add("ap_finapbill");
                }
            }
            if (billScope.contains("bus")) {
                if (this.isAr()) {
                    billScopes.add("ar_busbill");
                } else {
                    billScopes.add("ap_busbill");
                }
            }
            formShowParameter.getListFilterParameter().setFilter(new QFilter("billformid", "in", billScopes));
        });
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        if (EmptyUtils.isEmpty(this.getModel().getValue("orgs"))) {
            this.orgIds = this.getOrgIds();
            if (this.orgIds != null && this.orgIds.size() > 0) {
                long orgId = RequestContext.get().getOrgId();
                if (!this.orgIds.contains(orgId)) {
                    orgId = this.orgIds.get(0);
                }
                this.getModel().setValue("orgs", (Object)new Object[]{orgId});
            }
        }
        this.setCompareDateComboItems();
    }

    private List<Long> getOrgIds() {
        if (this.orgIds == null) {
            List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs(this.getView().getEntityId(), "47150e89000000ac", this.isAr());
            this.orgIds = orgs.stream().map(org -> org.getLong("id")).distinct().collect(Collectors.toList());
        }
        return this.orgIds;
    }

    private boolean isAr() {
        return org.apache.commons.lang.StringUtils.contains((String)this.getView().getEntityId(), (String)"ar_");
    }

    private void setCompareDateComboItems() {
        String sourceEntity = (String)this.getModel().getValue("sourceentity");
        ArrayList<ComboItem> comboItems = new ArrayList<ComboItem>(64);
        if ("ALL".equals(sourceEntity) || "finpaidbill".equals(sourceEntity)) {
            ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u5355\u636e\u65e5\u671f", (String)"AcctageForm_6", (String)"fi-arapcommon", (Object[])new Object[0])), "bizdate");
            comboItems.add(comboItem);
            this.setStandard(comboItems);
            return;
        }
        if ("paidbill".equals(sourceEntity)) {
            ComboItem bizDateItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u4e1a\u52a1\u65e5\u671f", (String)"AcctageForm_7", (String)"fi-arapcommon", (Object[])new Object[0])), "bizdate");
            comboItems.add(bizDateItem);
            String recDate = ResManager.loadKDString((String)"\u6536\u6b3e\u65e5\u671f", (String)"AcctageForm_8", (String)"fi-arapcommon", (Object[])new Object[0]);
            String payDate = ResManager.loadKDString((String)"\u4ed8\u6b3e\u65e5\u671f", (String)"AcctageForm_9", (String)"fi-arapcommon", (Object[])new Object[0]);
            ComboItem payDateItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309%s", (String)"AcctageForm_10", (String)"fi-arapcommon", (Object[])new Object[]{this.isAr() ? recDate : payDate})), this.isAr() ? "payeedate" : "paydate");
            comboItems.add(payDateItem);
            this.setStandard(comboItems);
            return;
        }
        Set<String> allSourceEntityKeys = this.buildSourceEntityKeys(sourceEntity);
        List<DateTimeProp> datePropIntersection = null;
        for (String entityKey : allSourceEntityKeys) {
            List<DateTimeProp> dateProps = EntityMetadataUtils.getDateProps(entityKey);
            if (datePropIntersection == null) {
                datePropIntersection = dateProps;
                continue;
            }
            Iterator<DateTimeProp> iterator = datePropIntersection.iterator();
            while (iterator.hasNext()) {
                DateTimeProp next = iterator.next();
                boolean contains = false;
                for (DateTimeProp p : dateProps) {
                    if (!p.getName().equals(next.getName())) continue;
                    contains = true;
                    break;
                }
                if (contains) continue;
                iterator.remove();
            }
        }
        if (datePropIntersection != null) {
            for (DateTimeProp prop : datePropIntersection) {
                String value = prop.getName();
                if (org.apache.commons.lang.StringUtils.contains((String)value, (String)"createtime") || org.apache.commons.lang.StringUtils.contains((String)value, (String)"modifytime") || org.apache.commons.lang.StringUtils.contains((String)value, (String)"updatetime") || "auditdate".equals(value) || "exratedate".equals(value) || "premduedate".equals(prop.getName())) continue;
                IDataEntityType parent = prop.getParent();
                String displayName = prop.getDisplayName().getLocaleValue();
                if (parent instanceof EntryType) continue;
                ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309%s", (String)"AcctageForm_10", (String)"fi-arapcommon", (Object[])new Object[]{displayName})), value);
                comboItems.add(comboItem);
            }
        }
        if ("ap_finapbill".equals(sourceEntity) || "ar_finarbill".equals(sourceEntity)) {
            ComboItem comboItem = new ComboItem(new LocaleString(ResManager.loadKDString((String)"\u6309\u8ba1\u5212\u884c\u5230\u671f\u65e5", (String)"AcctageForm_0", (String)"fi-arapcommon", (Object[])new Object[0])), "planduedate");
            comboItems.add(comboItem);
            this.setStandard(comboItems);
        }
        this.setStandard(comboItems);
    }

    private Set<String> buildSourceEntityKeys(String sourceEntity) {
        HashSet<String> allSourceEntityKeys = new HashSet<String>(4);
        if (sourceEntity.contains("fin")) {
            if (this.isAr()) {
                allSourceEntityKeys.add("ar_finarbill");
            } else {
                allSourceEntityKeys.add("ap_finapbill");
            }
        }
        if (sourceEntity.contains("bus")) {
            if (this.isAr()) {
                allSourceEntityKeys.add("ar_busbill");
            } else {
                allSourceEntityKeys.add("ap_busbill");
            }
        }
        if ("finpaidbill".equals(sourceEntity) || "paidbill".equals(sourceEntity)) {
            if (this.isAr()) {
                allSourceEntityKeys.add("cas_recbill");
                allSourceEntityKeys.add("ar_receivedbill");
            } else {
                allSourceEntityKeys.add("cas_paybill");
                allSourceEntityKeys.add("ap_paidbill");
            }
        }
        if ("ALL".equals(sourceEntity)) {
            if (this.isAr()) {
                allSourceEntityKeys.add("cas_recbill");
                allSourceEntityKeys.add("ar_receivedbill");
                allSourceEntityKeys.add("ar_busbill");
                allSourceEntityKeys.add("ar_finarbill");
            } else {
                allSourceEntityKeys.add("cas_paybill");
                allSourceEntityKeys.add("ap_paidbill");
                allSourceEntityKeys.add("ap_busbill");
                allSourceEntityKeys.add("ap_finapbill");
            }
        }
        return allSourceEntityKeys;
    }

    private void setStandard(List<ComboItem> comboItems) {
        ComboEdit comboEdit = (ComboEdit)this.getControl("standard");
        comboEdit.setComboItems(comboItems);
        ArrayList<ValueMapItem> itemList = new ArrayList<ValueMapItem>(8);
        ComboProp property = (ComboProp)comboEdit.getProperty();
        for (ComboItem comboItem : comboItems) {
            ValueMapItem prop = new ValueMapItem();
            prop.setName(comboItem.getCaption());
            prop.setValue(comboItem.getValue());
            itemList.add(prop);
        }
        property.setComboItems(itemList);
        this.getModel().setValue("standard", (Object)"bizdate");
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        String fieldName = null;
        for (Map info : filterColumns) {
            fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>();
        removedPros.add("org");
        removedPros.add("asstacttype");
        removedPros.add("asstact");
        removedPros.add("currency");
        removedPros.add("basecurrency");
        removedPros.add("entitykey");
        removedPros.add("billtype");
        removedPros.add("bizdate");
        removedPros.add("comparedate");
        removedPros.add("id");
        removedPros.add("quotation");
        removedPros.add("exchangerate");
        removedPros.add("paymentbilltype");
        removedPros.add("entryid");
        removedPros.add("planseq");
        return !removedPros.contains(split[0]);
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        boolean showLocalAmt = (Boolean)this.getModel().getValue("showlocalamt");
        if ("showqtycols".equals(key)) {
            List qtyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!qtyCols.contains("balance")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u503c\u201d\u4e2d\u9009\u9879\u201c\u4f59\u989d\u201d\u5fc5\u9009\u3002", (String)"AcctageForm_1", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (showLocalAmt && !qtyCols.contains("balanceloc")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u663e\u793a\u6298\u672c\u5e01\u65f6\u201c\u6c47\u603b\u503c\u201d\u4e2d\u9009\u9879\u201c\u4f59\u989d\u6298\u672c\u5e01\u201d\u5fc5\u9009\u3002", (String)"AcctageForm_2", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        } else if ("showkeycols".equals(key)) {
            List keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!keyCols.contains("asstacttype")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u9009\u9879\u201c\u5f80\u6765\u7c7b\u578b\u201d\u5fc5\u9009\u3002", (String)"AcctageForm_3", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("currency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u9009\u9879\u201c\u5e01\u79cd\u201d\u5fc5\u9009\u3002", (String)"AcctageForm_4", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (showLocalAmt && !keyCols.contains("basecurrency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u663e\u793a\u6298\u672c\u5e01\u65f6\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u9009\u9879\u201c\u672c\u4f4d\u5e01\u201d\u5fc5\u9009\u3002", (String)"AcctageForm_5", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel m = this.getModel();
        if ("sourceentity".equals(key)) {
            this.setCompareDateComboItems();
            Object billScope = m.getValue("sourceentity");
            m.setValue("billtypes", (Object)new Object[0]);
            m.setValue("paymentbilltypes", (Object)new Object[0]);
            if ("ar_finarbill".equals(billScope) || "ap_finapbill".equals(billScope) || "paidbill".equals(billScope) || "finpaidbill".equals(billScope)) {
                this.getModel().setValue("onlycontainsamount", (Object)Boolean.FALSE);
            }
        } else if (("showbybill".equals(key) || "showlocalamt".equals(key)) && "showlocalamt".equals(key)) {
            ChangeData[] changeDatas = e.getChangeSet();
            Object newValue = changeDatas[0].getNewValue();
            boolean isShowLocalAmt = (Boolean)newValue;
            ReportConf conf = this.getReportConf();
            List bigTableColConfs = conf.getBigTableColConf();
            List cols = bigTableColConfs.stream().filter(colConf -> "B".equals(colConf.getCalType())).map(BigTableColConf::getCol).collect(Collectors.toList());
            if (!isShowLocalAmt) {
                cols.removeIf(col -> org.apache.commons.lang.StringUtils.endsWith((String)col, (String)"loc"));
            }
            m.setValue("showqtycols", (Object)String.join((CharSequence)",", cols));
            String showkeycols = (String)m.getValue("showkeycols");
            List dims = Stream.of(showkeycols.split(",")).filter(s -> EmptyUtils.isNotEmpty(s)).collect(Collectors.toList());
            if (isShowLocalAmt) {
                if (!dims.contains("basecurrency")) {
                    dims.add("basecurrency");
                }
            } else if (dims.contains("basecurrency")) {
                dims.remove("basecurrency");
            }
            m.setValue("showkeycols", (Object)String.join((CharSequence)",", dims));
        }
    }

    protected final ReportConf getReportConf() {
        if (this.confCache == null) {
            this.confCache = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
        }
        return this.confCache;
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        boolean verify = super.verifyQuery(queryParam);
        FilterInfo filterInfo = queryParam.getFilter();
        DynamicObjectCollection orgs = queryParam.getFilter().getDynamicObjectCollection("orgs");
        if (orgs == null || orgs.isEmpty()) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AcctageForm_11", (String)"fi-arapcommon", (Object[])new Object[0]), Integer.valueOf(3000));
            verify = false;
        } else if ("planduedate".equals(filterInfo.getString("standard"))) {
            List<Long> ids = orgs.stream().map(org -> org.getLong("id")).collect(Collectors.toList());
            Map<Long, Object> settleModelMap = SystemParameterHelper.batchGetAppParameter(this.isAr(), ids, this.isAr() ? "ar_003" : "ap_003");
            ArrayList<Long> materialSettleOrgIds = new ArrayList<Long>(2);
            for (Map.Entry<Long, Object> entry : settleModelMap.entrySet()) {
                if (!"1".equals(entry.getValue())) continue;
                materialSettleOrgIds.add(entry.getKey());
            }
            if (!ObjectUtils.isEmpty(materialSettleOrgIds)) {
                String message = ResManager.loadKDString((String)"\u4ee5\u4e0b\u7ec4\u7ec7\u7684\u7ed3\u7b97\u6a21\u578b\u4e3a\u6309\u7269\u6599\u884c\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u6309\u8ba1\u5212\u884c\u5230\u671f\u65e5\u7edf\u8ba1\u8d26\u9f84\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AcctageForm_20", (String)"fi-arapcommon", (Object[])new Object[0]);
                StringBuilder sb = new StringBuilder();
                for (DynamicObject org2 : orgs) {
                    if (!materialSettleOrgIds.contains(org2.getLong("id"))) continue;
                    sb.append(org2.getString("name")).append('\uff1b');
                }
                this.getView().showMessage(message, sb.toString(), MessageTypes.Default);
                verify = false;
            }
        }
        if (filterInfo.getString("date") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u6307\u5b9a\u67e5\u8be2\u65e5\u671f\u3002", (String)"AcctageForm_12", (String)"fi-arapcommon", (Object[])new Object[0]));
            verify = false;
        }
        if (filterInfo.getString("standard") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8d26\u9f84\u8ba1\u7b97\u6807\u51c6\u3002", (String)"AcctageForm_13", (String)"fi-arapcommon", (Object[])new Object[0]));
            verify = false;
        }
        if (filterInfo.getString("sourceentity") == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u6570\u636e\u8303\u56f4\u3002", (String)"AcctageForm_14", (String)"fi-arapcommon", (Object[])new Object[0]));
            verify = false;
        }
        if (this.getGroupsValidator()) {
            verify = false;
        }
        if (this.existEntries(queryParam)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u67e5\u8be2\u5931\u8d25\u3002\u5931\u8d25\u539f\u56e0\uff1a\u4f9b\u5e94\u94fe\u4e91-\u4e1a\u52a1\u8bbe\u7f6e-\u6781\u901f\u62a5\u8868-\u62a5\u8868\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e-\u201c\u5b57\u6bb5\u6620\u5c04\u914d\u7f6e\u201d\uff0c\u201c\u6765\u6e90\u5b57\u6bb5\u6807\u8bc6\u201d\u4e0d\u5141\u8bb8\u6765\u6e90\u4e8e\u591a\u4e2a\u5206\u5f55\u3002\u8bf7\u4fee\u6539\u540e\u91cd\u65b0\u67e5\u8be2\u3002", (String)"AcctageForm_21", (String)"fi-arapcommon", (Object[])new Object[0]));
            verify = false;
        }
        return verify;
    }

    private boolean getGroupsValidator() {
        List<AcctageGroup> groups;
        String groupStr = this.getPageCache().get("groups");
        if (ObjectUtils.isEmpty((Object)groupStr)) {
            groups = AcctageHelper.getGroupsWithAgingGroup(this.isAr() ? "ar_acctagesetting" : "ap_acctagesetting");
            if (groups.isEmpty()) {
                groups = this.getDefaultAgingGroup();
                return groups.isEmpty();
            }
        } else {
            groups = SerializationUtils.fromJsonStringToList((String)groupStr, AcctageGroup.class);
        }
        return groups.isEmpty();
    }

    private boolean existEntries(ReportQueryParam queryParam) {
        boolean existEntries = false;
        FilterInfo filterInfo = queryParam.getFilter();
        String srcEntity = filterInfo.getString("sourceentity");
        if ("ap_finapbill".equals(srcEntity) || "ar_finarbill".equals(srcEntity) || "finbusbill".equals(srcEntity) || "finpaidbill".equals(srcEntity) || "ALL".equals(srcEntity)) {
            QFilter statusFilter = new QFilter("status", "=", (Object)Boolean.TRUE);
            QFilter reportFilter = new QFilter("report", "=", (Object)this.getView().getEntityId());
            Map reportConf = BusinessDataServiceHelper.loadFromCache((String)"scmc_report_conf", (QFilter[])new QFilter[]{statusFilter, reportFilter});
            if (ObjectUtils.isEmpty((Object)reportConf)) {
                return existEntries;
            }
            DynamicObject[] cfs = reportConf.values().toArray(new DynamicObject[0]);
            HashSet<Long> colMapIds = new HashSet<Long>(2);
            for (DynamicObject row : cfs[0].getDynamicObjectCollection("srcentry")) {
                String srcNumber = row.getDynamicObject("srcentity").getString("number");
                boolean blockStatus = row.getBoolean("blockstatus");
                if (!blockStatus || !"ar_finarbill".equals(srcNumber) && !"ap_finapbill".equals(srcNumber)) continue;
                colMapIds.add(row.getDynamicObject("colmap").getLong("id"));
            }
            if (ObjectUtils.isEmpty(colMapIds)) {
                return existEntries;
            }
            QFilter idFilter = new QFilter("id", "in", colMapIds);
            Map reportColMap = BusinessDataServiceHelper.loadFromCache((String)"scmc_report_colmap", (QFilter[])new QFilter[]{idFilter});
            if (ObjectUtils.isEmpty((Object)reportColMap)) {
                return existEntries;
            }
            for (DynamicObject reportCol : reportColMap.values().toArray(new DynamicObject[0])) {
                String mapInfoJsonStr = reportCol.getString("mapinfo_tag");
                if (ObjectUtils.isEmpty((Object)mapInfoJsonStr)) {
                    return existEntries;
                }
                JSONObject colInfo = JSONObject.parseObject((String)mapInfoJsonStr);
                JSONArray fullSrcCols = colInfo.getJSONArray("fullsrccol");
                HashSet fullSrcColSet = new HashSet(fullSrcCols);
                String entryKey = "";
                for (Object value : fullSrcColSet) {
                    String[] split = ((String)value).split("\\.");
                    if (split.length != 2) continue;
                    if (ObjectUtils.isEmpty((Object)entryKey)) {
                        entryKey = split[0];
                        continue;
                    }
                    if (entryKey.equals(split[0])) continue;
                    existEntries = true;
                    break;
                }
                if (ObjectUtils.isEmpty((Object)entryKey)) continue;
                queryParam.getCustomParam().put("entryName", entryKey);
            }
        }
        return existEntries;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        AcctageParam param = this.buildReportParam(queryParam);
        Object hyperLinkClickLineName = this.getView().getFormShowParameter().getCustomParams().get("hyperLinkClickLineName");
        if (hyperLinkClickLineName != null) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"reportfilterap"});
            param.setHyperLinkClick(true);
        } else {
            param.setHyperLinkClick(false);
        }
        queryParam.getCustomParam().put(AcctageParam.class.getName(), param);
    }

    private AcctageParam buildReportParam(ReportQueryParam queryParam) {
        Date queryDate;
        AcctageParam param = new AcctageParam();
        FilterInfo filterInfo = queryParam.getFilter();
        String entity = (String)filterInfo.getFilterItem("sourceentity").getValue();
        param.setEntities(this.buildSourceEntityKeys(entity));
        String compareDateFieldKey = filterInfo.getString("standard");
        String compareDateAlias = StringUtils.removePrefix(compareDateFieldKey);
        param.setCompareDateField(compareDateFieldKey, compareDateAlias);
        param.setBillTypes((List<DynamicObject>)filterInfo.getDynamicObjectCollection("billtypes"));
        param.setPaymentType(this.isAr() ? "cas_receivingbilltype" : "cas_paymentbilltype");
        param.setPaymentTypePks(DynamicObjectHelper.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("paymentbilltypes")));
        param.setOrgIds(DynamicObjectHelper.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("orgs")));
        param.setCurrencyIds(DynamicObjectHelper.getIdList((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("q_currency")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            DynamicObjectCollection acctacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactPks(ReportHelper.getBasedataIds((List<DynamicObject>)acctacts));
        }
        if ((queryDate = filterInfo.getDate("date")) != null) {
            queryDate = DateUtils.getDataFormat(queryDate, false);
        }
        param.setQueryDate(queryDate);
        param.setRecoverHistoryData(true);
        param.setGroups(this.getGroups());
        param.setHyperLinkClick(filterInfo.getBoolean("isHyperLinkClickByGroup"));
        param.setShowLocalAmt(filterInfo.getBoolean("showlocalamt"));
        param.setShowByBill(filterInfo.getBoolean("showbybill"));
        param.setContainsUnaudit(filterInfo.getBoolean("containsunaudit"));
        param.setOnlyContainsAmount(filterInfo.getBoolean("onlycontainsamount"));
        Object entryName = queryParam.getCustomParam().get("entryName");
        if (!ObjectUtils.isEmpty(entryName)) {
            param.setEntryName(entryName.toString());
        }
        return param;
    }

    private List<AcctageGroup> getGroups() {
        List<AcctageGroup> groups;
        String groupStr = this.getPageCache().get("groups");
        if (ObjectUtils.isEmpty((Object)groupStr)) {
            groups = AcctageHelper.getGroupsWithAgingGroup(this.isAr() ? "ar_acctagesetting" : "ap_acctagesetting");
            if (groups.isEmpty()) {
                groups = this.getDefaultAgingGroup();
            }
        } else {
            groups = SerializationUtils.fromJsonStringToList((String)groupStr, AcctageGroup.class);
        }
        groups.add(0, new AcctageGroup(ResManager.loadKDString((String)"\u672a\u5230\u671f", (String)"AcctageForm_15", (String)"fi-arapcommon", (Object[])new Object[0]), null, -1));
        Object hyperLinkClickLineName = this.getView().getFormShowParameter().getCustomParam("hyperLinkClickLineName");
        LinkedList<AcctageGroup> hyperLinkClickGroups = new LinkedList<AcctageGroup>();
        if (hyperLinkClickLineName != null) {
            for (int i = 0; i < groups.size(); ++i) {
                if (!AcctageHelper.getAmountFieldName(groups.get(i), "balance").equals(String.valueOf(hyperLinkClickLineName))) continue;
                hyperLinkClickGroups.add(groups.get(i));
            }
        }
        if (hyperLinkClickGroups != null && hyperLinkClickGroups.size() > 0) {
            return hyperLinkClickGroups;
        }
        return groups;
    }

    private List<AcctageGroup> getDefaultAgingGroup() {
        ArrayList<AcctageGroup> groups = new ArrayList<AcctageGroup>(8);
        DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
        ArrayList<Long> ids = new ArrayList<Long>(8);
        ArrayList<Long> groupIds = new ArrayList<Long>(8);
        for (DynamicObject org : orgs) {
            long orgId = ((DynamicObject)org.get("fbasedataid")).getLong("id");
            ids.add(orgId);
        }
        if (ids.size() > 0) {
            String entityName = this.isAr() ? "ar_accrualaging" : "ap_accrualaging";
            QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
            filter.and(new QFilter("isdefault", "=", (Object)Boolean.TRUE));
            if (this.isAr()) {
                filter.and(new QFilter("grouptype", "ftlike", (Object)"1"));
            }
            DynamicObjectCollection standardGroups = BaseDataServiceHelper.queryBaseData((String)entityName, (Long)((Long)ids.get(0)), (QFilter)filter, (String)"id");
            for (DynamicObject standardGroup : standardGroups) {
                groupIds.add(standardGroup.getLong("id"));
            }
            if (ids.size() > 1) {
                for (int i = 1; i < ids.size(); ++i) {
                    DynamicObjectCollection validateGroups = BaseDataServiceHelper.queryBaseData((String)entityName, (Long)((Long)ids.get(i)), (QFilter)filter, (String)"id");
                    if (validateGroups.size() != groupIds.size()) {
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u8d26\u9f84\u5206\u7ec4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AcctageForm_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                        return groups;
                    }
                    for (DynamicObject group : validateGroups) {
                        if (groupIds.contains(group.getLong("id"))) continue;
                        this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u8d26\u9f84\u5206\u7ec4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AcctageForm_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                        return groups;
                    }
                }
            }
            if (groupIds.size() < 1) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u6ca1\u6709\u9ed8\u8ba4\u7684\u8d26\u9f84\u5206\u7ec4\uff0c\u8bf7\u5148\u7ef4\u62a4\u8d26\u9f84\u5206\u7ec4\u3002", (String)"AcctageForm_18", (String)"fi-arapcommon", (Object[])new Object[0]));
                return groups;
            }
        } else {
            return groups;
        }
        DynamicObject agingGroup = BusinessDataServiceHelper.loadSingle(groupIds.get(0), (String)(this.isAr() ? "ar_accrualaging" : "ap_accrualaging"));
        String groupbasis = agingGroup.getString("groupbasis");
        DynamicObjectCollection entries = agingGroup.getDynamicObjectCollection("entry");
        for (DynamicObject entry : entries) {
            String section = entry.getString("e_section");
            int index = this.findLastDigitIndex(section);
            boolean isDayMore = entry.getBoolean("e_isdaymore");
            String resSection = isDayMore ? ("0".equals(groupbasis) ? ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"AcctageForm_24", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)}) : ResManager.loadKDString((String)"%s\u5e74\u4ee5\u4e0a", (String)"AcctageForm_25", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)})) : ("0".equals(groupbasis) ? ResManager.loadKDString((String)"%s\u5929", (String)"AcctageForm_22", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)}) : ResManager.loadKDString((String)"%s\u5e74", (String)"AcctageForm_23", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)}));
            AcctageGroup group = new AcctageGroup(resSection, entry.getInt("e_startday"), isDayMore ? null : Integer.valueOf(entry.getInt("e_endday")));
            groups.add(group);
        }
        return groups;
    }

    private int findLastDigitIndex(String section) {
        int index = -1;
        if (section == null || "".equals(section)) {
            return index;
        }
        for (int i = section.length() - 1; i >= 0; --i) {
            if (!Character.isDigit(section.charAt(i))) continue;
            index = i;
            break;
        }
        return index;
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        String fieldName = evt.getFieldName();
        if ("billno".equals(fieldName)) {
            ReportList list = (ReportList)this.getControl("reportlistap");
            DynamicObject rowData = list.getReportModel().getRowData(evt.getRowIndex());
            BillShowParameter parameter = new BillShowParameter();
            parameter.setFormId(rowData.getString("entitykey"));
            parameter.setPkId((Object)rowData.getLong("id"));
            parameter.setStatus(OperationStatus.VIEW);
            parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            parameter.setHasRight(true);
            this.getView().showForm((FormShowParameter)parameter);
        } else {
            ReportShowParameter parameter = new ReportShowParameter();
            FormShowParameter reportParameter = this.getView().getFormShowParameter();
            parameter.setFormId(reportParameter.getFormId());
            parameter.getOpenStyle().setTargetKey(reportParameter.getOpenStyle().getTargetKey());
            parameter.getOpenStyle().setShowType(reportParameter.getFormConfig().getShowType());
            ReportList reportList = (ReportList)evt.getSource();
            IReportListModel reportModel = reportList.getReportModel();
            DynamicObject rowData = reportModel.getRowData(evt.getRowIndex());
            Map<String, Object> customParams = this.getCustomParams(rowData);
            customParams.put("hyperLinkClickLineName", fieldName);
            parameter.setCustomParams(customParams);
            this.getView().showForm((FormShowParameter)parameter);
        }
    }

    private Map<String, Object> getCustomParams(DynamicObject rowData) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(2);
        HashMap<String, Object> dimensionData = new HashMap<String, Object>(4);
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        dimensionData.put("org", rowData.get("org"));
        dimensionData.put("orgs", rowData.get("org"));
        dimensionData.put("asstacttype", rowData.get("asstacttype"));
        dimensionData.put("asstact", rowData.get("asstact"));
        dimensionData.put("currency", rowData.get("currency"));
        ArrayList<String> sysDimensions = new ArrayList<String>(Arrays.asList("org", "asstacttype", "asstact", "currency"));
        String showKeyCols = (String)this.getModel().getValue("showkeycols");
        List showKeyColList = Stream.of(showKeyCols.split(",")).filter(EmptyUtils::isNotEmpty).collect(Collectors.toList());
        for (String s : showKeyColList) {
            if (sysDimensions.contains(s)) continue;
            Object value = rowData.get(s);
            if (value instanceof DynamicObject) {
                s = s + ".number";
                value = ((DynamicObject)value).getString("number");
            }
            dimensionData.put(s, value);
        }
        customParams.put("rowData", dimensionData);
        return customParams;
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        if (formShowParameter == null) {
            return;
        }
        Map customParams = formShowParameter.getCustomParams();
        if (customParams == null) {
            return;
        }
        Boolean isOpenByHyperlink = (Boolean)customParams.get("isopenbyhyperlink");
        if (isOpenByHyperlink != null && isOpenByHyperlink.booleanValue()) {
            this.setQueryConditionDeassign(customParams);
        }
    }

    private void setQueryConditionDeassign(Map<String, Object> customParams) {
        IDataModel parentModel = this.getView().getParentView().getModel();
        List<String> filterFieldKeys = this.getFilterFieldKeys();
        IDataModel m = this.getModel();
        DataEntityPropertyCollection properties = m.getDataEntityType().getProperties();
        Map rowData = (Map)customParams.get("rowData");
        for (String originalFieldKey : filterFieldKeys) {
            Object prop;
            Object value = null;
            String propKey = originalFieldKey;
            if (originalFieldKey.startsWith("q_")) {
                propKey = originalFieldKey.substring(2);
            } else if ("bd_customer".equals(originalFieldKey) || "bd_supplier".equals(originalFieldKey) || "bos_user".equals(originalFieldKey)) {
                propKey = "asstact";
            }
            if (rowData.get(propKey) != null) {
                value = rowData.get(propKey);
            }
            if (ObjectUtils.isEmpty(value)) {
                value = parentModel.getValue(originalFieldKey);
            }
            if ((prop = (IDataEntityProperty)properties.get((Object)originalFieldKey)) instanceof MulBasedataProp) {
                value = this.getMutlBasedataPks(value);
            } else if (prop instanceof ItemClassProp && value instanceof Map) {
                value = ((Map)value).get("id");
            }
            m.setValue(originalFieldKey, value);
        }
        ArrayList<String> sysDimensions = new ArrayList<String>(Arrays.asList("org", "asstacttype", "asstact", "currency"));
        LinkedList<SimpleFilterRow> rows = new LinkedList<SimpleFilterRow>();
        String showKeyCols = (String)this.getModel().getValue("showkeycols");
        List showKeyColList = Stream.of(showKeyCols.split(",")).filter(EmptyUtils::isNotEmpty).collect(Collectors.toList());
        for (String s : showKeyColList) {
            if (sysDimensions.contains(s)) continue;
            LinkedList<FilterValue> filterValues = new LinkedList<FilterValue>();
            FilterValue filterValue = new FilterValue();
            String key = s;
            Object value = rowData.get(key);
            if (value == null) {
                key = s + ".number";
                value = rowData.get(key);
            }
            if (value == null) continue;
            filterValue.setValue(value);
            filterValues.add(filterValue);
            SimpleFilterRow row = new SimpleFilterRow("", "17", key, "", "0", filterValues);
            row.setValue(filterValues);
            rows.add(row);
        }
        if (!ObjectUtils.isEmpty(rows)) {
            FilterCondition filterCondition = new FilterCondition();
            filterCondition.setFilterRow(rows);
            FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
            filterGrid.SetValue(filterCondition);
        }
        m.setValue("showbybill", (Object)Boolean.TRUE);
        this.getView().setVisible(Boolean.FALSE, new String[]{"groupset_btn"});
        ReportFilter control = (ReportFilter)this.getControl("reportfilterap");
        control.search();
    }

    private Object getMutlBasedataPks(Object value) {
        if (value instanceof DynamicObjectCollection) {
            DynamicObjectCollection temCollectionValue = (DynamicObjectCollection)value;
            ArrayList<Object> pks = new ArrayList<Object>(((DynamicObjectCollection)value).size());
            for (DynamicObject eachValue : temCollectionValue) {
                pks.add(eachValue.getDynamicObject("fbasedataid").getPkValue());
            }
            value = pks.toArray(new Object[0]);
        } else if (value instanceof DynamicObject) {
            value = new Object[]{((DynamicObject)value).getPkValue()};
        } else if (value instanceof Map) {
            Object id = ((Map)value).get("id");
            value = new Object[]{Long.valueOf(id.toString())};
        }
        return value;
    }

    private List<String> getFilterFieldKeys() {
        Container fixFilterContainer = (Container)this.getView().getControl("fsap");
        Container commFilterContainer = (Container)this.getView().getControl("commonfs");
        Container showFilterContainer = (Container)this.getView().getControl("flexpanelap1");
        Container moreFilterContainer = (Container)this.getView().getControl("reportmorefilterpanelap");
        ArrayList filterItems = new ArrayList(8);
        filterItems.addAll(fixFilterContainer.getItems());
        filterItems.addAll(commFilterContainer.getItems());
        filterItems.addAll(showFilterContainer.getItems());
        filterItems.addAll(moreFilterContainer.getItems());
        List<String> filterFieldKeys = filterItems.stream().map(Control::getKey).collect(Collectors.toList());
        return filterFieldKeys;
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String key = args.getOperateKey();
        if ("groupset".equals(key)) {
            ListShowParameter lsp = ShowFormHelper.createShowListForm((String)(this.isAr() ? "ar_accrualaging" : "ap_accrualaging"), (boolean)false, (int)2);
            ListFilterParameter lfp = new ListFilterParameter();
            DynamicObjectCollection orgs = (DynamicObjectCollection)this.getModel().getValue("orgs");
            ArrayList<Long> ids = new ArrayList<Long>(8);
            ArrayList<Long> groupIds = new ArrayList<Long>(8);
            for (DynamicObject org : orgs) {
                long orgId = ((DynamicObject)org.get("fbasedataid")).getLong("id");
                ids.add(orgId);
            }
            if (ids.size() > 0) {
                String entityName = this.isAr() ? "ar_accrualaging" : "ap_accrualaging";
                QFilter filter = new QFilter("enable", "=", (Object)Boolean.TRUE);
                if (this.isAr()) {
                    filter.and(new QFilter("grouptype", "ftlike", (Object)"1"));
                }
                DynamicObjectCollection standardGroups = BaseDataServiceHelper.queryBaseData((String)entityName, (Long)((Long)ids.get(0)), (QFilter)filter, (String)"id");
                for (DynamicObject standardGroup : standardGroups) {
                    groupIds.add(standardGroup.getLong("id"));
                }
                if (ids.size() > 1) {
                    for (int i = 1; i < ids.size(); ++i) {
                        DynamicObjectCollection groups = BaseDataServiceHelper.queryBaseData((String)entityName, (Long)((Long)ids.get(i)), (QFilter)filter, (String)"id");
                        if (groups.size() != groupIds.size()) {
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u8d26\u9f84\u5206\u7ec4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AcctageForm_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                            return;
                        }
                        for (DynamicObject group : groups) {
                            if (groupIds.contains(group.getLong("id"))) continue;
                            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6240\u9009\u7ec4\u7ec7\u7684\u8d26\u9f84\u5206\u7ec4\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9\u3002", (String)"AcctageForm_17", (String)"fi-arapcommon", (Object[])new Object[0]));
                            return;
                        }
                    }
                }
                if (groupIds.size() < 1) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u65e0\u53ef\u7528\u8d26\u9f84\u5206\u7ec4\uff0c\u8bf7\u5148\u7ef4\u62a4\u8d26\u9f84\u5206\u7ec4\u3002", (String)"AcctageForm_16", (String)"fi-arapcommon", (Object[])new Object[0]));
                    return;
                }
            } else {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u7ed3\u7b97\u7ec4\u7ec7\u3002", (String)"AcctageForm_19", (String)"fi-arapcommon", (Object[])new Object[0]));
                return;
            }
            QFilter filter = new QFilter("id", "in", groupIds);
            lfp.setFilter(filter);
            lsp.setListFilterParameter(lfp);
            CloseCallBack closeCallBack = new CloseCallBack(this.getPluginName(), "aginggroup");
            lsp.setCloseCallBack(closeCallBack);
            this.getView().showForm((FormShowParameter)lsp);
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        super.closedCallBack(closedCallBackEvent);
        String actionId = closedCallBackEvent.getActionId();
        if ("aginggroup".equals(actionId)) {
            ListSelectedRowCollection rows = (ListSelectedRowCollection)closedCallBackEvent.getReturnData();
            boolean isAr = this.isAr();
            if (rows != null && rows.size() > 0) {
                Long groupId = (Long)rows.get(0).getPrimaryKeyValue();
                DynamicObject agingGroup = BusinessDataServiceHelper.loadSingle((Object)groupId, (String)(isAr ? "ar_accrualaging" : "ap_accrualaging"));
                String groupbasis = agingGroup.getString("groupbasis");
                ArrayList<AcctageGroup> groups = new ArrayList<AcctageGroup>(64);
                DynamicObjectCollection entries = agingGroup.getDynamicObjectCollection("entry");
                for (DynamicObject entry : entries) {
                    String section = entry.getString("e_section");
                    int index = this.findLastDigitIndex(section);
                    boolean isDayMore = entry.getBoolean("e_isdaymore");
                    String resSection = isDayMore ? ("0".equals(groupbasis) ? ResManager.loadKDString((String)"%s\u5929\u4ee5\u4e0a", (String)"AcctageForm_24", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)}) : ResManager.loadKDString((String)"%s\u5e74\u4ee5\u4e0a", (String)"AcctageForm_25", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)})) : ("0".equals(groupbasis) ? ResManager.loadKDString((String)"%s\u5929", (String)"AcctageForm_22", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)}) : ResManager.loadKDString((String)"%s\u5e74", (String)"AcctageForm_23", (String)"fi-arapcommon", (Object[])new Object[]{section.substring(0, index + 1)}));
                    AcctageGroup group = new AcctageGroup(resSection, entry.getInt("e_startday"), isDayMore ? null : Integer.valueOf(entry.getInt("e_endday")));
                    groups.add(group);
                }
                if (groups.size() > 0) {
                    AcctageHelper.saveGroupSetting(groups, isAr, isAr ? "ar_acctagesetting" : "ap_acctagesetting");
                    this.getPageCache().put("groups", SerializationUtils.toJsonString(groups));
                    this.getView().invokeOperation("refresh");
                }
            }
        }
    }
}

