/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AbstractAcctage;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class BusApBillAcctageImpl
extends AbstractAcctage {
    private Set<Long> busPks;

    public BusApBillAcctageImpl(ReportDataCtx ctx) {
        super(ctx);
        if (this.entityKey == null) {
            this.entityKey = "ap_busbill";
        }
    }

    @Override
    protected QFilter getSrcBlockFilter(Set<Long> reversePks) {
        String asstactType;
        QFilter filter = new QFilter("id", "in", this.busPks);
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filter.and(new QFilter("org", "in", orgIds));
        }
        if (this.reportParam.isContainsUnaudit()) {
            filter.and("billstatus", "in", (Object)new String[]{"B", "C"});
        } else {
            filter.and("billstatus", "=", (Object)"C");
        }
        List<DynamicObject> billTypes = this.reportParam.getBillTypes();
        if (!ObjectUtils.isEmpty(billTypes)) {
            filter.and("billtype", "in", DynamicObjectHelper.getIdList(billTypes));
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = this.reportParam.getAsstactType()))) {
            filter.and("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                filter.and("asstact", "in", asstactPks);
            }
        } else {
            filter.and("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        return filter;
    }

    @Override
    protected DataSetX getReserveDataSetX() {
        DataSetX groupByDataSetX;
        this.busPks = this.getBusBillPks();
        Set<Long> adjustBusBillPks = this.getAdjustBusBillPks();
        this.busPks.addAll(adjustBusBillPks);
        DataSetX woffDataSetX = this.getWoffDataSetX(true);
        woffDataSetX = woffDataSetX.union(this.getWoffDataSetX(false));
        DataSetX adjExchDataSetX = null;
        if (!this.reportParam.isOnlyContainsAmount()) {
            adjExchDataSetX = this.getAdjExchDataSetX();
        }
        if (adjExchDataSetX == null) {
            groupByDataSetX = woffDataSetX.groupBy(new String[]{"e_srcbillid"}).sum("e_pricetaxtotal").sum("e_pricetaxtotalbase");
        } else {
            DataSetX settleRecords = woffDataSetX.union(adjExchDataSetX);
            groupByDataSetX = settleRecords.groupBy(new String[]{"e_srcbillid"}).sum("e_pricetaxtotal").sum("e_pricetaxtotalbase");
        }
        return groupByDataSetX.filter("e_pricetaxtotalbase <> 0");
    }

    private Set<Long> getBusBillPks() {
        List<QFilter> busFilters = this.getBusBillwithBalanceFilter();
        DataSet busBillDataSet = ArApXDBHelper.queryDataSet(this.entityKey, "id", busFilters, null, "newacctage_ap_bus_idquery");
        HashSet<Long> pks = new HashSet<Long>(8);
        for (Row row : busBillDataSet) {
            pks.add(row.getLong("id"));
        }
        return pks;
    }

    private List<QFilter> getBusBillwithBalanceFilter() {
        QFilter asstactTypeFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(4);
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        QFilter bizdateFilter = new QFilter("bizdate", "<=", (Object)compareDate);
        filters.add(bizdateFilter);
        QFilter isadjustFilter = new QFilter("isadjust", "=", (Object)Boolean.FALSE);
        filters.add(isadjustFilter);
        QFilter unwoffAmtFilter = new QFilter("unwoffamt", "<>", (Object)0);
        filters.add(unwoffAmtFilter);
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstactTypeFilter = new QFilter("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                QFilter asstactFilter = new QFilter("asstact", "in", asstactPks);
                filters.add(asstactFilter);
            }
        } else {
            asstactTypeFilter = new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        filters.add(asstactTypeFilter);
        return filters;
    }

    private Set<Long> getAdjustBusBillPks() {
        List<QFilter> busFilters = this.getAdjustafterQueryDateFilters();
        DataSet billDataSet = ArApXDBHelper.queryDataSet(this.entityKey, "entry.e_mostsrcbusbillid,entry.e_srcbillid", busFilters, null, "newacctage_ap_bus_woffidquery");
        HashSet<Long> pks = new HashSet<Long>(8);
        for (Row row : billDataSet) {
            Long mostSrcBusBillId = row.getLong("entry.e_mostsrcbusbillid");
            if (mostSrcBusBillId > 0L) {
                pks.add(mostSrcBusBillId);
                continue;
            }
            pks.add(row.getLong("entry.e_srcbillid"));
        }
        return pks;
    }

    private List<QFilter> getAdjustafterQueryDateFilters() {
        QFilter asstactTypeFilter;
        Date queryDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        LinkedList<QFilter> adjustFilters = new LinkedList<QFilter>(this.reportParam.getFilters());
        adjustFilters.add(new QFilter("bizdate", ">", (Object)queryDate));
        adjustFilters.add(new QFilter("srcbizdate", "<=", (Object)queryDate));
        adjustFilters.add(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstactTypeFilter = new QFilter("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                QFilter asstactFilter = new QFilter("asstact", "in", asstactPks);
                adjustFilters.add(asstactFilter);
            }
        } else {
            asstactTypeFilter = new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        adjustFilters.add(asstactTypeFilter);
        return adjustFilters;
    }

    private DataSetX getWoffDataSetX(boolean isWoff) {
        List<QFilter> woffFilters = this.getAdjustbeforeQueryDateFilters(isWoff);
        JobSession session = this.ctx.getCurrentJob();
        ArrayList<String> selectors = new ArrayList<String>(4);
        if (isWoff) {
            selectors.add("entry.e_srcentryid e_srcbillid");
        } else {
            selectors.add("entry.e_mostsrcbusentryid e_srcbillid");
        }
        if (this.reportParam.isOnlyContainsAmount()) {
            selectors.add("entry.e_amount e_pricetaxtotal");
            selectors.add("entry.e_localamt e_pricetaxtotalbase");
        } else {
            selectors.add("entry.e_pricetaxtotal e_pricetaxtotal");
            selectors.add("entry.e_pricetaxtotalbase e_pricetaxtotalbase");
        }
        OrmInput woffInput = new OrmInput("queryWoffBill" + isWoff, this.entityKey, String.join((CharSequence)",", selectors), woffFilters.toArray(new QFilter[0]));
        return session.fromInput((Input)woffInput);
    }

    private List<QFilter> getAdjustbeforeQueryDateFilters(boolean isQueryWoff) {
        QFilter asstactTypeFilter;
        Date queryDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        LinkedList<QFilter> adjustFilters = new LinkedList<QFilter>(this.reportParam.getFilters());
        adjustFilters.add(new QFilter("bizdate", "<=", (Object)queryDate));
        adjustFilters.add(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        if (isQueryWoff) {
            adjustFilters.add(new QFilter("entry.e_mostsrcbusbillid", "=", (Object)0));
            adjustFilters.add(new QFilter("entry.e_srcbillid", "in", this.busPks));
        } else {
            adjustFilters.add(new QFilter("entry.e_mostsrcbusbillid", "in", this.busPks));
        }
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstactTypeFilter = new QFilter("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                QFilter asstactFilter = new QFilter("asstact", "in", asstactPks);
                adjustFilters.add(asstactFilter);
            }
        } else {
            asstactTypeFilter = new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        adjustFilters.add(asstactTypeFilter);
        return adjustFilters;
    }

    private DataSetX getAdjExchDataSetX() {
        DataSetX adjExchDataSetX = null;
        QFilter qFilter = this.getAdjExchFilter();
        if (qFilter != null) {
            Map<Long, List<Long>> map = AcctageHelper.getPreviousPeriodEndDate(this.entityKey, this.reportParam.getOrgIds(), this.reportParam.getQueryDate());
            for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
                Date bizDate = new Date(entry.getKey());
                List<Long> orgIds = entry.getValue();
                qFilter.and("org", "in", orgIds);
                qFilter.and("bizdate", "=", (Object)bizDate);
                boolean isAr = StringUtils.contains((String)this.entityKey, (String)"ar_");
                String adjEntityKey = isAr ? "ar_adjustexchbill" : "ap_adjexchbill";
                OrmInput adjInput = new OrmInput("adjExchBill", adjEntityKey, "entry.e_srcentryid as e_srcbillid, entry.e_curgainloss as e_pricetaxtotalbase", new QFilter[]{qFilter});
                DataSetX eachAdjExchDataSetX = this.ctx.getCurrentJob().fromInput((Input)adjInput);
                Field[] fields = new Field[]{new Field("e_pricetaxtotal", (DataType)DataType.BigDecimalType)};
                Object[] vals = new Object[]{BigDecimal.ZERO};
                eachAdjExchDataSetX = eachAdjExchDataSetX.addFields(fields, vals);
                eachAdjExchDataSetX = eachAdjExchDataSetX.select(new String[]{"e_srcbillid", "e_pricetaxtotal", "e_pricetaxtotalbase"});
                if (adjExchDataSetX == null) {
                    adjExchDataSetX = eachAdjExchDataSetX;
                    continue;
                }
                adjExchDataSetX = adjExchDataSetX.union(eachAdjExchDataSetX);
            }
        }
        return adjExchDataSetX;
    }
}

