/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.Input;
import kd.bos.algo.Row;
import kd.bos.algo.input.OrmInput;
import kd.bos.algox.DataSetX;
import kd.bos.algox.JobSession;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctagev2.AbstractAcctage;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang.StringUtils;

public class FinArBillAcctageImpl
extends AbstractAcctage {
    private Set<Long> finPks;

    public FinArBillAcctageImpl(ReportDataCtx ctx) {
        super(ctx);
        if (this.entityKey == null) {
            this.entityKey = "ar_finarbill";
        }
    }

    @Override
    protected QFilter getSrcBlockFilter(Set<Long> reversePks) {
        String asstactType;
        this.finPks.addAll(reversePks);
        QFilter filter = new QFilter("id", "in", this.finPks);
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filter.and(new QFilter("org", "in", orgIds));
        }
        if (this.reportParam.isContainsUnaudit()) {
            filter.and("billstatus", "in", (Object)new String[]{"B", "C"});
        } else {
            filter.and("billstatus", "=", (Object)"C");
        }
        List<DynamicObject> billTypes = this.reportParam.getBillTypes();
        if (!ObjectUtils.isEmpty(billTypes)) {
            filter.and("billtype", "in", DynamicObjectHelper.getIdList(billTypes));
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = this.reportParam.getAsstactType()))) {
            filter.and("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                filter.and("asstact", "in", asstactPks);
            }
        } else {
            filter.and("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        return filter;
    }

    @Override
    protected DataSetX getReserveDataSetX() {
        this.finPks = this.getFinPks();
        DataSetX settleDataSetX = this.getSettleDataSetX();
        DataSetX adjExchDataSetX = this.getAdjExchDataSetX();
        if (adjExchDataSetX != null) {
            settleDataSetX = settleDataSetX.union(adjExchDataSetX);
        }
        return settleDataSetX;
    }

    private Set<Long> getFinPks() {
        List<QFilter> filters = this.getFinFilters();
        DataSet finBillDataSet = ArApXDBHelper.queryDataSet(this.entityKey, "id", filters, null, "newacctage_ar_fin_idquery");
        HashSet<Long> pks = new HashSet<Long>(8);
        for (Row row : finBillDataSet) {
            pks.add(row.getLong("id"));
        }
        return pks;
    }

    private List<QFilter> getFinFilters() {
        QFilter asstactTypeFilter;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        QFilter isWrittenOffFilter = new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE);
        filters.add(isWrittenOffFilter);
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        QFilter bizDateFilter = new QFilter("bizdate", "<=", (Object)compareDate);
        filters.add(bizDateFilter);
        QFilter settleStatusFilter = new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"});
        filters.add(settleStatusFilter);
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstactTypeFilter = new QFilter("asstacttype", "=", (Object)asstactType);
            List<Object> asstactPks = this.reportParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                QFilter asstactFilter = new QFilter("asstact", "in", asstactPks);
                filters.add(asstactFilter);
            }
        } else {
            asstactTypeFilter = new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user"));
        }
        filters.add(asstactTypeFilter);
        return filters;
    }

    private DataSetX getAdjExchDataSetX() {
        DataSetX adjExchDataSetX = null;
        QFilter qFilter = this.getAdjExchFilter();
        if (qFilter != null) {
            Map<Long, List<Long>> map = AcctageHelper.getPreviousPeriodEndDate(this.entityKey, this.reportParam.getOrgIds(), this.reportParam.getQueryDate());
            for (Map.Entry<Long, List<Long>> entry : map.entrySet()) {
                Date bizDate = new Date(entry.getKey());
                List<Long> orgIds = entry.getValue();
                qFilter.and("org", "in", orgIds);
                qFilter.and("bizdate", "=", (Object)bizDate);
                boolean isAr = StringUtils.contains((String)this.entityKey, (String)"ar_");
                String adjEntityKey = isAr ? "ar_adjustexchbill" : "ap_adjexchbill";
                OrmInput adjInput = new OrmInput("adjExchBill", adjEntityKey, "entry.e_srcbillid as mainbillid, entry.e_srcentryid as mainbillentryid, entry.e_curgainloss as localtotalsettleamt", new QFilter[]{qFilter});
                DataSetX eachAdjExchDataSetX = this.ctx.getCurrentJob().fromInput((Input)adjInput);
                Field[] fields = new Field[]{new Field("totalsettleamt", (DataType)DataType.BigDecimalType)};
                Object[] vals = new Object[]{BigDecimal.ZERO};
                eachAdjExchDataSetX = eachAdjExchDataSetX.addFields(fields, vals);
                eachAdjExchDataSetX = eachAdjExchDataSetX.select(new String[]{"mainbillid", "mainbillentryid", "totalsettleamt", "localtotalsettleamt"});
                if (adjExchDataSetX == null) {
                    adjExchDataSetX = eachAdjExchDataSetX;
                    continue;
                }
                adjExchDataSetX = adjExchDataSetX.union(eachAdjExchDataSetX);
            }
        }
        return adjExchDataSetX;
    }

    private DataSetX getSettleDataSetX() {
        List<Object> asstacts;
        List<String> settleRecordBillTypes = this.getBillTypes();
        Date compareDate = DateUtils.getDataFormat(this.reportParam.getQueryDate(), false);
        List<QFilter> filters = this.getFilters(compareDate);
        ArrayList<QFilter> mainFilters = new ArrayList<QFilter>(filters);
        String asstactType = this.reportParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            mainFilters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        if (!ObjectUtils.isEmpty(asstacts = this.reportParam.getAsstactPks())) {
            mainFilters.add(new QFilter("mainasstactid", "in", asstacts));
        }
        mainFilters.add(new QFilter("mainbizdate", "<=", (Object)compareDate));
        mainFilters.add(new QFilter("billentity", "=", (Object)"ar_finarbill"));
        if (!settleRecordBillTypes.isEmpty()) {
            mainFilters.add(new QFilter("mainbilltype", "in", settleRecordBillTypes));
        }
        JobSession session = this.ctx.getCurrentJob();
        OrmInput mainInput = new OrmInput("mainSettle", "ar_settlerecord", "mainbillid,mainbillentryid,totalsettleamt,localtotalsettleamt", mainFilters.toArray(new QFilter[0]));
        DataSetX mainSettle = session.fromInput((Input)mainInput);
        ArrayList<QFilter> asstFilters = new ArrayList<QFilter>(filters);
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstFilters.add(new QFilter("entry.asstacttype", "=", (Object)asstactType));
        }
        asstFilters.add(new QFilter("entry.billdate", "<=", (Object)compareDate));
        asstFilters.add(new QFilter("entry.e_billentity", "=", (Object)"ar_finarbill"));
        asstFilters.add(new QFilter("settlerelation", "in", (Object)new String[]{SettleRelationEnum.APARSETTLE.getValue(), SettleRelationEnum.ARSELF.getValue()}));
        if (!settleRecordBillTypes.isEmpty()) {
            asstFilters.add(new QFilter("entry.billtype", "in", settleRecordBillTypes));
        }
        if (!ObjectUtils.isEmpty(asstacts)) {
            asstFilters.add(new QFilter("entry.asstactid", "in", asstacts));
        }
        OrmInput asstInput = new OrmInput("asstSettle", "ap_settlerecord", "entry.billid as mainbillid,entry.billentryid as mainbillentryid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt", asstFilters.toArray(new QFilter[0]));
        DataSetX asstSettle = session.fromInput((Input)asstInput);
        DataSetX settleRecords = mainSettle.union(asstSettle);
        return settleRecords;
    }

    private List<QFilter> getFilters(Date compareDate) {
        List<Object> currencyIds;
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        filters.add(new QFilter("settledate", ">", (Object)compareDate));
        List<Object> orgIds = this.reportParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", orgIds));
        }
        if (!ObjectUtils.isEmpty(currencyIds = this.reportParam.getCurrencyIds())) {
            filters.add(new QFilter("maincurrency", "in", currencyIds));
        }
        return filters;
    }

    private List<String> getBillTypes() {
        LinkedList<String> settleRecordBillTypes = new LinkedList<String>();
        List<DynamicObject> billTypes = this.reportParam.getBillTypes();
        if (!ObjectUtils.isEmpty(billTypes)) {
            for (DynamicObject billType : billTypes) {
                long billTypeId = billType.getLong("id");
                String settleRecordBillType = BillTypeConsts.getBillTypeMap().getOrDefault(billTypeId, billType.getString("number"));
                settleRecordBillTypes.add(settleRecordBillType);
            }
        }
        return settleRecordBillTypes;
    }
}

