/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.acctagev2.transform;

import kd.bos.algox.DataSetX;
import kd.bos.algox.JoinDataSetX;
import kd.bos.algox.JoinFunction;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.fi.arapcommon.report.acctagev2.AcctageParam;
import kd.fi.arapcommon.report.acctagev2.transform.func.BusReverseJoinFunc;
import kd.fi.arapcommon.report.acctagev2.transform.func.FinReverseJoinFunc;
import kd.fi.arapcommon.report.acctagev2.transform.func.PaidReverseJoinFunc;
import kd.fi.arapcommon.report.acctagev2.transform.func.PayReverseJoinFunc;

public class AddReverseJoin
implements IDataXTransform {
    private String entityKey;
    private DataSetX reverseDs;
    private AcctageParam reportParam;

    public AddReverseJoin(ReportDataCtx ctx, String entityKey, DataSetX reverseDs) {
        this.reportParam = (AcctageParam)ctx.getParam(AcctageParam.class.getName());
        this.entityKey = entityKey;
        this.reverseDs = reverseDs;
    }

    public DataSetX doTransform(DataSetX srcData) {
        DataSetX joinData = null;
        if (this.reverseDs != null) {
            JoinDataSetX joinDataSet = null;
            if ("ap_finapbill".equals(this.entityKey) || "ar_finarbill".equals(this.entityKey)) {
                boolean isEntry = !ObjectUtils.isEmpty((Object)this.reportParam.getEntryName());
                this.reverseDs = this.reverseDs.groupBy(new String[]{isEntry ? "mainbillentryid" : "mainbillid"}).sum("totalsettleamt").sum("localtotalsettleamt");
                joinDataSet = isEntry ? srcData.leftJoin(this.reverseDs).on("entryid", "mainbillentryid") : srcData.leftJoin(this.reverseDs).on("id", "mainbillid");
                joinDataSet.withFunc((JoinFunction)new FinReverseJoinFunc(srcData.getRowMeta(), this.reverseDs.getRowMeta(), this.reportParam.isShowLocalAmt()));
            } else if ("ap_busbill".equals(this.entityKey) || "ar_busbill".equals(this.entityKey)) {
                joinDataSet = srcData.leftJoin(this.reverseDs).on("entryid", "e_srcbillid");
                joinDataSet.withFunc((JoinFunction)new BusReverseJoinFunc(srcData.getRowMeta(), this.reverseDs.getRowMeta(), this.reportParam.isShowLocalAmt()));
            } else if ("cas_paybill".equals(this.entityKey) || "cas_recbill".equals(this.entityKey)) {
                joinDataSet = srcData.leftJoin(this.reverseDs).on("entryid", "mainbillentryid");
                joinDataSet.withFunc((JoinFunction)new PayReverseJoinFunc(srcData.getRowMeta(), this.reverseDs.getRowMeta(), this.reportParam.isShowLocalAmt()));
            } else if ("ap_paidbill".equals(this.entityKey) || "ar_receivedbill".equals(this.entityKey)) {
                joinDataSet = srcData.leftJoin(this.reverseDs).on("entryid", "mainbillentryid");
                joinDataSet.withFunc((JoinFunction)new PaidReverseJoinFunc(srcData.getRowMeta(), this.reverseDs.getRowMeta(), this.reportParam.isShowLocalAmt()));
            }
            if (joinDataSet != null) {
                String[] fields = srcData.getRowMeta().getFieldNames();
                joinData = joinDataSet.select(fields, new String[0]);
            }
        } else {
            joinData = srcData;
        }
        if (joinData != null) {
            joinData = "cas_paybill".equals(this.entityKey) || "cas_recbill".equals(this.entityKey) || "ap_paidbill".equals(this.entityKey) || "ar_receivedbill".equals(this.entityKey) ? joinData.filter("pricetaxtotal <> 0") : joinData.filter("balance <> 0");
        }
        return joinData;
    }
}

