/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.bizpartner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.RptCustomSettingParser;
import kd.fi.arapcommon.util.CollectionUtils;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;

public class ApSumDataHelper {
    private ARAPSumParam param;
    private RptCustomSettingParser customSettingParser;
    private FilterInfo filterInfo;
    private String[] journalDimensionAlias;
    private Set<String> commonAmtField;
    private List<String> amtFields;

    public ApSumDataHelper(ARAPSumParam param, RptCustomSettingParser customSettingParser, FilterInfo filterInfo, String[] journalDimensionAlias, Set<String> commonAmtField) {
        this.param = param;
        this.customSettingParser = customSettingParser;
        this.filterInfo = filterInfo;
        this.journalDimensionAlias = journalDimensionAlias;
        this.commonAmtField = commonAmtField;
    }

    public DataSet query(ReportQueryParam queryParam) {
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs());
        List<QFilter> journalFilters = this.getJournalFilters(this.filterInfo);
        List<String> journalDimensions = this.customSettingParser.getStatisticalDimensions();
        List<String> journalSelectors = this.getJournalSelectors();
        this.amtFields = new ArrayList<String>();
        this.amtFields.add("payableamt");
        this.amtFields.add("localpayableamt");
        this.amtFields.add("apsettleamt");
        this.amtFields.add("aplocalsettleamt");
        if (this.isContainsPrepaid()) {
            this.amtFields.add("prepaidamt");
            this.amtFields.add("localprepaidamt");
            this.amtFields.add("paysettleamt");
            this.amtFields.add("localpaysettleamt");
        }
        DataSet journals = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ap_journal", (String)String.join((CharSequence)",", journalSelectors), (QFilter[])journalFilters.toArray(new QFilter[0]), null);
        GroupbyDataSet journalGroupByDataSet = journals.groupBy(this.journalDimensionAlias);
        for (String amtField : this.amtFields) {
            journalGroupByDataSet.sum(amtField);
        }
        journals = journalGroupByDataSet.finish();
        List<String> journalSelectedFields = DataSetUtils.getSelectedFields(journals, new String[0]);
        List<String> balanceDimensions = this.getBalanceDimensions();
        BalanceQuerier balanceQuerier = new BalanceQuerier(this.getBalanceType());
        DataSet lastestBalance = balanceQuerier.queryBalance(orgIds, this.param.getStartDate(), balanceDimensions, this.getBalanceQueryCustomFilters(this.filterInfo));
        JoinDataSet temJoinDataSet = journals.join(lastestBalance, JoinType.FULL);
        for (int i = 0; i < this.journalDimensionAlias.length; ++i) {
            temJoinDataSet = temJoinDataSet.on(this.journalDimensionAlias[i], balanceDimensions.get(i));
        }
        String[] balanceSelectedFields = CollectionUtils.mergeArrays(balanceDimensions.toArray(new String[0]), new String[]{"periodamt", "localperiodamt"});
        this.amtFields.add("periodamt");
        this.amtFields.add("localperiodamt");
        DataSet mergedDataSet = temJoinDataSet.select(journalSelectedFields.toArray(new String[0]), balanceSelectedFields).finish();
        ArrayList<String> exp = new ArrayList<String>(journalDimensions.size() + this.amtFields.size());
        for (int i = 0; i < journalDimensions.size(); ++i) {
            String journalField = journalDimensions.get(i) + "2";
            exp.add(String.format("case when %s=null then %s else %s end as %s", journalField, balanceDimensions.get(i), journalField, journalDimensions.get(i)));
        }
        for (String amtField : this.amtFields) {
            exp.add(String.format("case when %s=null then 0 else %s end as %s", amtField, amtField, amtField));
        }
        DataSet totalDataSet = mergedDataSet.select(exp.toArray(new String[0]));
        totalDataSet = this.isContainsPrepaid() ? totalDataSet.addField("periodamt+payableamt-prepaidamt-apsettleamt+paysettleamt", "balanceamt").addField("localperiodamt+localpayableamt-localprepaidamt-aplocalsettleamt+localpaysettleamt", "localbalanceamt") : totalDataSet.addField("periodamt+payableamt-apsettleamt", "balanceamt").addField("localperiodamt+localpayableamt-aplocalsettleamt", "localbalanceamt");
        totalDataSet = totalDataSet.addField("0", "sumlevel");
        List<String> summaryFields = null;
        summaryFields = this.isContainsPrepaid() ? Arrays.asList("periodamt", "payableamt", "prepaidamt", "apsettleamt", "paysettleamt", "balanceamt", "localperiodamt", "localpayableamt", "localprepaidamt", "aplocalsettleamt", "localpaysettleamt", "localbalanceamt") : Arrays.asList("periodamt", "payableamt", "apsettleamt", "balanceamt", "localperiodamt", "localpayableamt", "aplocalsettleamt", "localbalanceamt");
        String aliasSelects = Stream.concat(journalDimensions.stream(), summaryFields.stream().map(field -> field.concat(this.commonAmtField.contains(field) ? " ap" : " ").concat((String)field))).collect(Collectors.joining(","));
        totalDataSet = totalDataSet.select(aliasSelects);
        return totalDataSet;
    }

    private BalanceType getBalanceType() {
        String billScope = this.filterInfo.getString("billscope");
        if ("ALL".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AP_FIN_BUS_PREPAID : BalanceType.AP_FIN_BUS;
        }
        if ("finbill".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AP_FIN_PREPAID : BalanceType.AP_FIN;
        }
        if ("busbill".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AP_BUS_PREPAID : BalanceType.AP_BUS;
        }
        throw new KDBizException("Unknow Report Data Source " + billScope);
    }

    private List<String> getJournalSelectors() {
        String notCasSettleRealtionExp;
        List<String> journalDimensions = this.customSettingParser.getStatisticalDimensions();
        ArrayList<String> journalSelectors = new ArrayList<String>(this.journalDimensionAlias.length);
        for (int i = 0; i < this.journalDimensionAlias.length; ++i) {
            String journalField = journalDimensions.get(i);
            String journalAlias = journalField + "2";
            journalSelectors.add(journalField + " " + journalAlias);
        }
        journalSelectors.add("sourcebilltype");
        journalSelectors.add("sourcebillid");
        journalSelectors.add("biztype");
        String payableAmtExpression = "case when SOURCEBILLTYPE ='ap_finapbill' then payableamt  when SOURCEBILLTYPE='ap_busbill' then estimatedamt else 0 end as payableamt";
        journalSelectors.add(payableAmtExpression);
        String localPayableAmtExpression = "case when SOURCEBILLTYPE ='ap_finapbill' then localpayableamt when SOURCEBILLTYPE='ap_busbill' then localestimatedamt else 0 end as localpayableamt";
        journalSelectors.add(localPayableAmtExpression);
        if (this.isContainsPrepaid()) {
            notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself'";
            String settleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-payableamt else 0 end as apsettleamt";
            journalSelectors.add(settleAmtExpression);
            String localSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-localpayableamt else 0 end as aplocalsettleamt";
            journalSelectors.add(localSettleAmtExpression);
            String casSettleRealtionExp = "BIZTYPE in('payrecsettle','payself','recpaysettle','arpaysettle','appaysettle','payclearing')";
            String casSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-prepaidamt else 0 end as paysettleamt";
            journalSelectors.add(casSettleAmtExpression);
            String localCasSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-localprepaidamt else 0 end as localpaysettleamt";
            journalSelectors.add(localCasSettleAmtExpression);
            journalSelectors.add("case when SOURCEBILLTYPE in ('cas_paybill','ap_paidbill') then prepaidamt else 0 end as prepaidamt");
            journalSelectors.add("case when SOURCEBILLTYPE in ('cas_paybill','ap_paidbill') then localprepaidamt else 0 end as localprepaidamt");
        } else {
            notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself'";
            journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-payableamt else 0 end as apsettleamt");
            journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-localpayableamt else 0 end as aplocalsettleamt");
            journalSelectors.add("0 prepaidamt");
            journalSelectors.add("0 localprepaidamt");
            journalSelectors.add("0 paysettleamt");
            journalSelectors.add("0 localpaysettleamt");
        }
        return journalSelectors;
    }

    private boolean isContainsPrepaid() {
        return this.filterInfo.getBoolean("containspre");
    }

    private List<String> getBalanceDimensions() {
        List<String> journalDimensions = this.customSettingParser.getStatisticalDimensions();
        ArrayList<String> balanceDimensions = new ArrayList<String>();
        BalJouMapper mapper = BalJouMapper.getMapper(true);
        BalanceSettingParser balanceSettingParser = new BalanceSettingParser(mapper);
        for (String journalField : journalDimensions) {
            List<String> balanceFields = balanceSettingParser.getBalanceFields(journalField);
            if (balanceFields == null || balanceFields.isEmpty()) {
                throw new KDBizException("");
            }
            balanceDimensions.addAll(balanceFields);
        }
        return balanceDimensions;
    }

    private List<QFilter> getBalanceQueryCustomFilters(FilterInfo filterInfo) {
        DynamicObjectCollection currencys;
        ArrayList<QFilter> balanceCustomFilters = new ArrayList<QFilter>();
        List<Long> cusAndPusPks = this.param.getCusAndPusPks();
        if (EmptyUtils.isNotEmpty(cusAndPusPks)) {
            QFilter asstactFilter = new QFilter("asstact", "in", cusAndPusPks);
            balanceCustomFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty(currencys = this.param.getCurrencys())) {
            List<Object> currencyPks = DynamicObjectHelper.getIdList((Collection<DynamicObject>)currencys);
            QFilter currencyFilter = new QFilter("currency", "in", currencyPks);
            balanceCustomFilters.add(currencyFilter);
        }
        balanceCustomFilters.addAll(this.customSettingParser.getCustomFilters());
        return balanceCustomFilters;
    }

    private List<QFilter> getJournalFilters(FilterInfo filterInfo) {
        DynamicObjectCollection currencys;
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs());
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter beginDateFilter = new QFilter("bizdate", ">=", (Object)this.param.getStartDate());
        QFilter endDateFilter = new QFilter("bizdate", "<=", (Object)this.param.getStopDate());
        ArrayList<QFilter> journalFilters = new ArrayList<QFilter>();
        journalFilters.add(orgFilter);
        journalFilters.add(beginDateFilter);
        journalFilters.add(endDateFilter);
        List<Long> cusAndPusPks = this.param.getCusAndPusPks();
        if (!EmptyUtils.isEmpty(cusAndPusPks)) {
            QFilter asstactFilter = new QFilter("asstact", "in", cusAndPusPks);
            journalFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty(currencys = this.param.getCurrencys())) {
            List<Object> currencyPks = DynamicObjectHelper.getIdList((Collection<DynamicObject>)currencys);
            QFilter currencyFilter = new QFilter("currency", "in", currencyPks);
            journalFilters.add(currencyFilter);
        }
        journalFilters.addAll(this.customSettingParser.getCustomFilters());
        ArrayList<String> journalSourceEntityTypes = new ArrayList<String>();
        String billScope = filterInfo.getString("billscope");
        if ("ALL".equals(billScope)) {
            journalSourceEntityTypes.add("ap_finapbill");
            journalSourceEntityTypes.add("ap_settlerecord");
            journalSourceEntityTypes.add("ar_settlerecord");
            journalSourceEntityTypes.add("ap_busbill");
        } else if ("finbill".equals(billScope)) {
            journalSourceEntityTypes.add("ap_finapbill");
            journalSourceEntityTypes.add("ap_settlerecord");
            journalSourceEntityTypes.add("ar_settlerecord");
        } else if ("busbill".equals(billScope)) {
            journalSourceEntityTypes.add("ap_busbill");
        } else {
            throw new KDBizException("Unknow Report Data Source " + billScope);
        }
        if (this.isContainsPrepaid()) {
            journalSourceEntityTypes.add("cas_paybill");
            journalSourceEntityTypes.add("ap_paidbill");
        }
        journalFilters.add(new QFilter("sourcebilltype", "in", journalSourceEntityTypes));
        return journalFilters;
    }

    public List<String> getAmtFields() {
        return this.amtFields;
    }

    public void setAmtFields(List<String> amtFields) {
        this.amtFields = amtFields;
    }
}

