/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.bizpartner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.helper.BizPartnerHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.DefaultCustomSettingParser;
import kd.fi.arapcommon.report.RptCustomSettingParser;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;

public class ArApBizPartnerDetailDataRpt
extends AbstractReportListDataPlugin {
    private RptCustomSettingParser customSettingParser;
    private FilterInfo filterInfo;
    private BalJouMapper mapper;
    private ARAPSumParam param;
    private List<String> balanceDimensions;
    private List<String> journalDimensions;
    private String[] arOther = new String[]{"receivableamt", "localreceivableamt", "receivedamt", "localreceivedamt", "receivedoffset", "localreceivedoffset"};
    private String[] apOther = new String[]{"payableamt", "localpayableamt", "prepaidamt", "localprepaidamt", "payoffset", "localpayoffset"};

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        return this.query(queryParam);
    }

    private DataSet query(ReportQueryParam queryParam) {
        this.prepareQueryParam(queryParam);
        DataSet detailData = this.queryDetailData();
        DataSet balanceData = this.queryPeriodBalance(detailData.copy());
        DataSet journalBalanceRawData = detailData.union(balanceData);
        DataSet sumData = this.sum(journalBalanceRawData);
        journalBalanceRawData = journalBalanceRawData.union(sumData);
        if (this.param.isNotShowZero()) {
            journalBalanceRawData = this.filterZeroBalanceData(journalBalanceRawData, sumData);
        }
        if (this.param.isNotShowNull()) {
            journalBalanceRawData = this.filterNoBizData(journalBalanceRawData);
        }
        DataSet totalSumData = this.totalSum(journalBalanceRawData);
        LinkedList<String> orderByFields = new LinkedList<String>();
        for (String journalDimension : this.journalDimensions) {
            orderByFields.add(journalDimension + " desc");
        }
        orderByFields.add("sumlevel");
        orderByFields.add("bizdate asc");
        return journalBalanceRawData.union(totalSumData).orderBy(orderByFields.toArray(new String[0]));
    }

    private void prepareQueryParam(ReportQueryParam queryParam) {
        this.filterInfo = queryParam.getFilter();
        this.customSettingParser = new DefaultCustomSettingParser(queryParam);
        this.param = this.getSumParam(queryParam);
        this.mapper = BalJouMapper.getMapper(true);
        this.balanceDimensions = this.customSettingParser.getStatisticalDimensions();
        this.journalDimensions = this.balanceDimensions.stream().map(bd -> this.mapper.getJournalField((String)bd)).collect(Collectors.toList());
    }

    private DataSet queryDetailData() {
        List<QFilter> journalFilters = this.getJournalFilters();
        DataSet journalsAP = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ap_journal", (String)String.join((CharSequence)",", this.getJournalSelectors(true)), (QFilter[])journalFilters.toArray(new QFilter[0]), null);
        DataSet journalsAR = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_journal", (String)String.join((CharSequence)",", this.getJournalSelectors(false)), (QFilter[])journalFilters.toArray(new QFilter[0]), null);
        journalsAP = journalsAP.addNullField(this.arOther);
        journalsAR = journalsAR.addNullField(this.apOther);
        if (this.param.isShowMainCurrency()) {
            journalsAP = this.isContainsPrepaid() ? journalsAP.filter("payableamt<>0 or payoffset<>0 or offset <> 0 or prepaidamt<>0 or localpayableamt <> 0 or localpayoffset <> 0 or localoffset <> 0 or localprepaidamt <> 0") : journalsAP.filter("(biztype <> 'recpaysettle' and biztype <> 'payrecsettle') and (payableamt<>0 or payoffset<>0 or prepaidamt<>0 or localpayableamt <> 0 or localpayoffset <> 0 or localprepaidamt <> 0)");
            journalsAR = this.isContainsPrepaid() ? journalsAR.filter("receivableamt<>0 or receivedoffset<>0 or recoffset <> 0 or receivedamt<>0 or localreceivableamt <> 0 or localreceivedoffset <> 0 or localrecoffset <> 0 or localreceivedamt <> 0") : journalsAR.filter("(biztype <> 'recpaysettle' and biztype <> 'payrecsettle') and (receivableamt<>0 or receivedoffset<>0 or receivedamt<>0 or localreceivableamt <> 0 or localreceivedoffset <> 0 or localreceivedamt <> 0)");
        } else {
            journalsAP = this.isContainsPrepaid() ? journalsAP.filter("payableamt<>0 or payoffset<>0 or offset <> 0 or prepaidamt<>0") : journalsAP.filter("(biztype <> 'recpaysettle' and biztype <> 'payrecsettle') and (payableamt<>0 or payoffset<>0 or prepaidamt<>0)");
            journalsAR = this.isContainsPrepaid() ? journalsAR.filter("receivableamt<>0 or receivedoffset<>0 or recoffset <> 0 or receivedamt<>0") : journalsAR.filter("(biztype <> 'recpaysettle' and biztype <> 'payrecsettle') and (receivableamt<>0 or receivedoffset<>0 or receivedamt<>0)");
        }
        LinkedList<String> groupbyField = new LinkedList<String>();
        groupbyField.addAll(this.journalDimensions);
        groupbyField.add("billno");
        groupbyField.add("billstatus");
        groupbyField.add("biztype");
        groupbyField.add("bizdate");
        groupbyField.add("sourcebilltype");
        groupbyField.add("sourcebillid");
        journalsAP = journalsAP.groupBy(groupbyField.toArray(new String[0])).sum("payoffset").sum("localpayoffset").sum("offset").sum("localoffset").sum("payableamt").sum("localpayableamt").sum("prepaidamt").sum("localprepaidamt").finish();
        journalsAP = journalsAP.select(String.join((CharSequence)",", this.getSelectors(true)));
        journalsAR = journalsAR.groupBy(groupbyField.toArray(new String[0])).sum("receivableamt").sum("localreceivableamt").sum("receivedoffset").sum("localreceivedoffset").sum("recoffset").sum("localrecoffset").sum("receivedamt").sum("localreceivedamt").finish();
        journalsAR = journalsAR.select(String.join((CharSequence)",", this.getSelectors(false)));
        journalsAP = BizPartnerHelper.convertAsstactToBizPartner(journalsAP, this.getSelectors(true).toArray(new String[0]), DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs()));
        journalsAR = BizPartnerHelper.convertAsstactToBizPartner(journalsAR, this.getSelectors(false).toArray(new String[0]), DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs()));
        return journalsAR.union(journalsAP).orderBy(new String[]{"billno"});
    }

    private List<String> getSelectors(boolean isAP) {
        ArrayList<String> selectors = new ArrayList<String>(32);
        selectors.addAll(this.journalDimensions);
        if (isAP) {
            selectors.add("0 receivableamt");
            selectors.add("0 localreceivableamt");
            selectors.add("payoffset");
            selectors.add("localpayoffset");
            selectors.add("offset");
            selectors.add("localoffset");
            selectors.add("0 receivedoffset");
            selectors.add("0 localreceivedoffset");
            selectors.add("0 recoffset");
            selectors.add("0 localrecoffset");
            selectors.add("0 receivedamt");
            selectors.add("0 localreceivedamt");
            selectors.add("payableamt");
            selectors.add("localpayableamt");
            selectors.add("prepaidamt");
            selectors.add("localprepaidamt");
        } else {
            selectors.add("receivableamt");
            selectors.add("localreceivableamt");
            selectors.add("0 payoffset");
            selectors.add("0 localpayoffset");
            selectors.add("0 offset");
            selectors.add("0 localoffset");
            selectors.add("receivedoffset");
            selectors.add("localreceivedoffset");
            selectors.add("recoffset");
            selectors.add("localrecoffset");
            selectors.add("receivedamt");
            selectors.add("localreceivedamt");
            selectors.add("0 payableamt");
            selectors.add("0 localpayableamt");
            selectors.add("0 prepaidamt");
            selectors.add("0 localprepaidamt");
        }
        selectors.add("0 balance");
        selectors.add("0 localbalance");
        selectors.add("billno");
        selectors.add("billstatus");
        selectors.add("biztype");
        selectors.add("bizdate");
        selectors.add("0 sumlevel");
        selectors.add("0 rowtype");
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        return selectors;
    }

    private List<String> getSelectorsBalance(boolean isAp) {
        ArrayList<String> selectors = new ArrayList<String>(30);
        selectors.addAll(this.journalDimensions);
        selectors.add("0 receivableamt");
        selectors.add("0 localreceivableamt");
        selectors.add("0 payoffset");
        selectors.add("0 localpayoffset");
        selectors.add("0 offset");
        selectors.add("0 localoffset");
        selectors.add("0 receivedoffset");
        selectors.add("0 localreceivedoffset");
        selectors.add("0 recoffset");
        selectors.add("0 localrecoffset");
        selectors.add("0 receivedamt");
        selectors.add("0 localreceivedamt");
        selectors.add("0 payableamt");
        selectors.add("0 localpayableamt");
        selectors.add("0 prepaidamt");
        selectors.add("0 localprepaidamt");
        if (isAp) {
            selectors.add("periodamt balance");
            selectors.add("localperiodamt localbalance");
        } else {
            selectors.add("-periodamt balance");
            selectors.add("-localperiodamt localbalance");
        }
        selectors.add("'' billno");
        selectors.add("'' billstatus");
        selectors.add("'' biztype");
        selectors.add("null bizdate");
        selectors.add("-2 sumlevel");
        selectors.add("-1 rowtype");
        selectors.add("'periodbalance' sourcebilltype");
        selectors.add("0 billid");
        return selectors;
    }

    private List<QFilter> getCommonFilters(String entityKey) {
        String dateProKey = "bizdate";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(5);
        QFilter orgFilter = new QFilter("org", "in", DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs()));
        QFilter dateFilter = new QFilter(dateProKey, ">=", (Object)this.param.getStartDate()).and(new QFilter(dateProKey, "<=", (Object)this.param.getStopDate()));
        filters.add(orgFilter);
        filters.add(dateFilter);
        if (!EmptyUtils.isEmpty(this.param.getCusAndPusPks())) {
            QFilter cusAndSupFilter = new QFilter("asstact", "in", this.param.getCusAndPusPks());
            filters.add(cusAndSupFilter);
        }
        if (!EmptyUtils.isEmpty(this.param.getCurrencys())) {
            String currencyKey = "currency";
            QFilter asstactTypeFilter = new QFilter(currencyKey, "in", DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getCurrencys()));
            filters.add(asstactTypeFilter);
        }
        return filters;
    }

    private List<String> getJournalSelectors(boolean isAp) {
        List<String> balanceDimensions = this.customSettingParser.getStatisticalDimensions();
        List journalDimensions = balanceDimensions.stream().map(bd -> this.mapper.getJournalField((String)bd)).collect(Collectors.toList());
        ArrayList<String> journalSelectors = new ArrayList<String>(10);
        journalSelectors.addAll(journalDimensions);
        if (isAp) {
            String payableAmtExpression = "case when SOURCEBILLTYPE ='ap_finapbill' then payableamt  when SOURCEBILLTYPE='ap_busbill' then estimatedamt else 0 end as payableamt";
            journalSelectors.add(payableAmtExpression);
            String localPayableAmtExpression = "case when SOURCEBILLTYPE ='ap_finapbill' then localpayableamt when SOURCEBILLTYPE='ap_busbill' then localestimatedamt else 0 end as localpayableamt";
            journalSelectors.add(localPayableAmtExpression);
            if (this.isContainsPrepaid()) {
                String notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself'";
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-payableamt else 0 end as payoffset");
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-localpayableamt else 0 end as localpayoffset");
                journalSelectors.add("case when SOURCEBILLTYPE in ('cas_paybill','ap_paidbill') then prepaidamt else 0 end as prepaidamt");
                journalSelectors.add("case when SOURCEBILLTYPE in ('cas_paybill','ap_paidbill') then localprepaidamt else 0 end as localprepaidamt");
                String casSettleRealtionExp = "BIZTYPE in('payrecsettle','payself','recpaysettle','arpaysettle','appaysettle','payclearing')";
                String casSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-prepaidamt else 0 end as offset";
                journalSelectors.add(casSettleAmtExpression);
                String localCasSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-localprepaidamt else 0 end as localoffset";
                journalSelectors.add(localCasSettleAmtExpression);
            } else {
                String notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself'";
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-payableamt else 0 end as payoffset");
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-localpayableamt else 0 end as localpayoffset");
                journalSelectors.add("0 prepaidamt");
                journalSelectors.add("0 localprepaidamt");
                journalSelectors.add("0 offset");
                journalSelectors.add("0 localoffset");
            }
        } else {
            journalSelectors.add("case when SOURCEBILLTYPE='ar_finarbill' then receivableamt when SOURCEBILLTYPE='ar_busbill' then estimatedamt else 0 end as receivableamt");
            journalSelectors.add("case when SOURCEBILLTYPE='ar_finarbill' then localreceivableamt when SOURCEBILLTYPE='ar_busbill' then localestimatedamt else 0 end as localreceivableamt");
            if (this.isContainsPrepaid()) {
                String notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself' and BIZTYPE<>'recself'";
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-receivableamt else 0 end as receivedoffset");
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-localreceivableamt else 0 end as localreceivedoffset");
                String casSettleRealtionExp = "BIZTYPE IN ('recsettle','recpaysettle','payrecsettle','recself','baddebtrecovery','aprecsettle','recclearing')";
                String casSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-receivedamt else 0 end as recoffset";
                journalSelectors.add(casSettleAmtExpression);
                String localCasSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-localreceivedamt else 0 end as localrecoffset";
                journalSelectors.add(localCasSettleAmtExpression);
                String receivedAmtExpression = "case when SOURCEBILLTYPE in ('cas_recbill','ar_receivedbill') then receivedamt else 0 end as receivedamt";
                journalSelectors.add(receivedAmtExpression);
                String localReceivedAmtExpression = "case when SOURCEBILLTYPE in ('cas_recbill','ar_receivedbill') then localreceivedamt else 0 end as localreceivedamt";
                journalSelectors.add(localReceivedAmtExpression);
            } else {
                String notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'recself'";
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-receivableamt else 0 end as receivedoffset");
                journalSelectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-localreceivableamt else 0 end as localreceivedoffset");
                journalSelectors.add("0 receivedamt");
                journalSelectors.add("0 localreceivedamt");
                journalSelectors.add("0 recoffset");
                journalSelectors.add("0 localrecoffset");
            }
        }
        journalSelectors.add("case when SOURCEBILLTYPE='cas_paybill' then 'D' else 'C' end as billstatus");
        journalSelectors.add("sourcebilltype");
        journalSelectors.add("sourcebillid");
        journalSelectors.add("biztype");
        journalSelectors.add("billno");
        journalSelectors.add("bizdate");
        return journalSelectors;
    }

    private List<QFilter> getJournalFilters() {
        List<QFilter> filters = this.getCommonFilters("ap_journal");
        String billScope = this.filterInfo.getString("billscope");
        ArrayList<String> sourceEntityKeys = new ArrayList<String>(5);
        if ("finbill".equals(billScope)) {
            sourceEntityKeys.add("ap_finapbill");
            sourceEntityKeys.add("ap_settlerecord");
            sourceEntityKeys.add("ar_settlerecord");
            sourceEntityKeys.add("ar_finarbill");
            sourceEntityKeys.add("ap_settlerecord");
            sourceEntityKeys.add("ap_settlerecord");
        } else if ("busbill".equals(billScope)) {
            sourceEntityKeys.add("ap_busbill");
            sourceEntityKeys.add("ar_busbill");
        } else if ("ALL".equals(billScope)) {
            sourceEntityKeys.add("ap_finapbill");
            sourceEntityKeys.add("ap_settlerecord");
            sourceEntityKeys.add("ar_settlerecord");
            sourceEntityKeys.add("ap_busbill");
            sourceEntityKeys.add("ar_finarbill");
            sourceEntityKeys.add("ap_settlerecord");
            sourceEntityKeys.add("ap_settlerecord");
            sourceEntityKeys.add("ar_busbill");
        } else {
            throw new KDBizException("Unsupported Report Data Source : " + billScope);
        }
        if (this.isContainsPrepaid()) {
            sourceEntityKeys.add("cas_paybill");
            sourceEntityKeys.add("ap_paidbill");
            sourceEntityKeys.add("cas_recbill");
            sourceEntityKeys.add("ar_receivedbill");
        }
        filters.add(new QFilter("sourcebilltype", "in", sourceEntityKeys));
        filters.addAll(this.customSettingParser.getCustomFilters());
        return filters;
    }

    private DataSet queryPeriodBalance(DataSet detailData) {
        List<QFilter> balanceCustomFilters = this.getBalanceCustomFilters();
        BalanceQuerier balanceQuerierAP = new BalanceQuerier(this.getBalanceType(true));
        BalanceQuerier balanceQuerierAR = new BalanceQuerier(this.getBalanceType(false));
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs());
        DataSet balanceDataAP = balanceQuerierAP.queryBalance(orgIds, this.param.getStartDate(), this.balanceDimensions, balanceCustomFilters);
        DataSet balanceDataAR = balanceQuerierAR.queryBalance(orgIds, this.param.getStartDate(), this.balanceDimensions, balanceCustomFilters);
        balanceDataAP = this.replenishBalance(balanceDataAP, detailData);
        balanceDataAR = this.replenishBalance(balanceDataAR, detailData);
        balanceDataAP = BizPartnerHelper.convertAsstactToBizPartner(balanceDataAP, this.getSelectorsBalance(true).toArray(new String[0]), DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs()));
        balanceDataAR = BizPartnerHelper.convertAsstactToBizPartner(balanceDataAR, this.getSelectorsBalance(false).toArray(new String[0]), DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs()));
        DataSet unoin = balanceDataAP.union(balanceDataAR);
        SumParam sumParam = new SumParam(SumParam.SumType.INIT);
        sumParam.addGroupByField(this.balanceDimensions.toArray(new String[0]));
        sumParam.addGroupByField("sourcebilltype");
        sumParam.addSummaryField("balance", "localbalance", "receivableamt", "localreceivableamt", "receivedamt", "localreceivedamt", "receivedoffset", "localreceivedoffset", "recoffset", "localrecoffset", "payableamt", "localpayableamt", "prepaidamt", "localprepaidamt", "payoffset", "localpayoffset", "offset", "localoffset");
        DataSet sum = DataSetUtils.sum(unoin, sumParam);
        return sum;
    }

    private BalanceType getBalanceType(boolean isAp) {
        String billScope = this.filterInfo.getString("billscope");
        if (isAp) {
            if ("finbill".equals(billScope)) {
                return this.isContainsPrepaid() ? BalanceType.AP_FIN_PREPAID : BalanceType.AP_FIN;
            }
            if ("busbill".equals(billScope)) {
                return this.isContainsPrepaid() ? BalanceType.AP_BUS_PREPAID : BalanceType.AP_BUS;
            }
            if ("ALL".equals(billScope)) {
                return this.isContainsPrepaid() ? BalanceType.AP_FIN_BUS_PREPAID : BalanceType.AP_FIN_BUS;
            }
            throw new KDBizException("Unsupported Report Data Source : " + billScope);
        }
        if ("finbill".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AR_FIN_RECEIVED : BalanceType.AR_FIN;
        }
        if ("busbill".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AR_BUS_RECEIVED : BalanceType.AR_BUS;
        }
        if ("ALL".equals(billScope)) {
            return this.isContainsPrepaid() ? BalanceType.AR_FIN_BUS_RECEIVED : BalanceType.AR_FIN_BUS;
        }
        throw new KDBizException("Unsupported Report Data Source : " + billScope);
    }

    private List<QFilter> getBalanceCustomFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(10);
        if (!EmptyUtils.isEmpty(this.param.getCurrencys())) {
            filters.add(new QFilter("currency", "in", DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getCurrencys())));
        }
        if (!EmptyUtils.isEmpty(this.param.getCusAndPusPks())) {
            filters.add(new QFilter("asstact", "in", this.param.getCusAndPusPks()));
        }
        filters.addAll(this.customSettingParser.getCustomFilters());
        return filters;
    }

    private DataSet replenishBalance(DataSet balanceData, DataSet detailData) {
        DataSet finish = detailData.groupBy(this.journalDimensions.toArray(new String[0])).count().finish();
        List<String> selectedFields = DataSetUtils.getSelectedFields(balanceData, new String[0]);
        HashMap<String, String> balanceFieldAliasMap = new HashMap<String, String>(selectedFields.size());
        ArrayList<String> aliasExchangeExp = new ArrayList<String>(selectedFields.size());
        for (String f : selectedFields) {
            String alias = f + "_alias";
            balanceFieldAliasMap.put(f, alias);
            aliasExchangeExp.add(f + " " + alias);
        }
        balanceData = balanceData.select(String.join((CharSequence)",", aliasExchangeExp));
        JoinDataSet join = balanceData.join(finish, JoinType.FULL);
        for (int i = 0; i < this.balanceDimensions.size(); ++i) {
            join.on((String)balanceFieldAliasMap.get(this.balanceDimensions.get(i)), this.journalDimensions.get(i));
        }
        balanceData = join.select(balanceFieldAliasMap.values().toArray(new String[0]), this.journalDimensions.toArray(new String[0])).finish();
        ArrayList<String> noNullExp = new ArrayList<String>(this.balanceDimensions.size());
        for (int i = 0; i < this.balanceDimensions.size(); ++i) {
            String balanceField2 = this.balanceDimensions.get(i);
            String balanceAlias2 = (String)balanceFieldAliasMap.remove(balanceField2);
            String journalField = this.journalDimensions.get(i);
            noNullExp.add(String.format("case when %s=null then %s else %s end as %s", balanceAlias2, journalField, balanceAlias2, balanceField2));
        }
        balanceFieldAliasMap.forEach((balanceField, balanceAlias) -> noNullExp.add(String.format("case when %s=null then 0 else %s end as %s", balanceAlias, balanceAlias, balanceField)));
        return balanceData.select(String.join((CharSequence)",", noNullExp));
    }

    private DataSet filterNoBizData(DataSet journalBalanceRawData) {
        List<String> selectedFields = DataSetUtils.getSelectedFields(journalBalanceRawData, new String[0]);
        DataSet finish = journalBalanceRawData.groupBy(this.journalDimensions.toArray(new String[0])).count().finish();
        JoinDataSet join = journalBalanceRawData.join(finish);
        for (String jd : this.journalDimensions) {
            join = join.on(jd, jd);
        }
        journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"count"}).finish();
        return journalBalanceRawData.filter("count > 2 ");
    }

    private DataSet filterZeroBalanceData(DataSet journalBalanceRawData, DataSet sumData) {
        List<String> selectedFields = DataSetUtils.getSelectedFields(journalBalanceRawData, new String[0]);
        JoinDataSet join = journalBalanceRawData.join(sumData, JoinType.LEFT);
        for (String jd : this.journalDimensions) {
            join = join.on(jd, jd);
        }
        journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"balance balance2", "localbalance localbalance2"}).finish();
        return journalBalanceRawData.filter("balance2 <> 0 or localbalance2 <> 0");
    }

    private DataSet totalSum(DataSet rawDataSet) {
        rawDataSet = rawDataSet.filter("rowtype=1");
        SumParam totalSumParam = new SumParam(SumParam.SumType.TOTAL);
        totalSumParam.addSummaryField("payableamt", "localpayableamt", "prepaidamt", "localprepaidamt", "payoffset", "localpayoffset", "offset", "localoffset", "receivableamt", "receivedamt", "receivedoffset", "recoffset", "localreceivableamt", "localreceivedamt", "localreceivedoffset", "localrecoffset", "balance", "localbalance");
        DataSet totalSumData = DataSetUtils.sum(rawDataSet, totalSumParam);
        List totalSumDataSetFields = DataSetUtils.getSelectedFields(rawDataSet, new String[0]).stream().map(f -> {
            if ("sourcebilltype".equalsIgnoreCase((String)f)) {
                return "'totalsum' sourcebilltype";
            }
            if ("sumlevel".equalsIgnoreCase((String)f)) {
                return "2 sumlevel";
            }
            return f;
        }).collect(Collectors.toList());
        totalSumData = totalSumData.select(String.join((CharSequence)",", totalSumDataSetFields));
        return totalSumData;
    }

    private DataSet sum(DataSet journalBalanceRawData) {
        SumParam sumParam = new SumParam(SumParam.SumType.SUM);
        sumParam.setGroupByFields(this.journalDimensions);
        sumParam.addSummaryField("payableamt", "localpayableamt", "prepaidamt", "localprepaidamt", "payoffset", "localpayoffset", "offset", "localoffset", "receivableamt", "receivedamt", "receivedoffset", "recoffset", "localreceivableamt", "localreceivedamt", "localreceivedoffset", "localrecoffset", "balance", "localbalance");
        DataSet sumData = DataSetUtils.sum(journalBalanceRawData, sumParam);
        List sumDataFields = DataSetUtils.getSelectedFields(sumData, new String[0]).stream().map(f -> {
            if ("sourcebilltype".equalsIgnoreCase((String)f)) {
                return "'sum' sourcebilltype";
            }
            if ("sumlevel".equalsIgnoreCase((String)f)) {
                return "1 sumlevel";
            }
            if ("balance".equalsIgnoreCase((String)f)) {
                return "balance + payableamt-prepaidamt-payoffset+offset-(receivableamt-receivedamt-receivedoffset+recoffset) balance";
            }
            if ("localbalance".equalsIgnoreCase((String)f)) {
                return "localbalance+localpayableamt-localprepaidamt-localpayoffset+localoffset -(localreceivableamt - localreceivedamt - localreceivedoffset + localrecoffset) localbalance";
            }
            if ("rowtype".equalsIgnoreCase((String)f)) {
                return "1 rowtype";
            }
            return f;
        }).collect(Collectors.toList());
        sumData = sumData.select(String.join((CharSequence)",", sumDataFields));
        return sumData;
    }

    private boolean isContainsPrepaid() {
        return this.filterInfo.getBoolean("containspre");
    }

    private ARAPSumParam getSumParam(ReportQueryParam queryParam) {
        List<Long> cusAndSupPksByPartners = BizPartnerHelper.getCusAndSupPksByPartners(this.filterInfo.getDynamicObjectCollection("bizpartners"));
        FilterInfo filterInfo = queryParam.getFilter();
        ARAPSumParam param = new ARAPSumParam();
        param.setOrgs(filterInfo.getDynamicObjectCollection("orgs"));
        param.setCurrencys(filterInfo.getDynamicObjectCollection("currencys"));
        param.setStartDate(DateUtils.getDataFormat(filterInfo.getDate("startdate"), true));
        param.setStopDate(DateUtils.getDataFormat(filterInfo.getDate("stopdate"), false));
        param.setBillScope(filterInfo.getString("billscope"));
        param.setIncludUnAudit(filterInfo.getBoolean("includunaudit"));
        param.setNotShowZero(filterInfo.getBoolean("notshowzero"));
        param.setNotShowNull(filterInfo.getBoolean("notshownull"));
        param.setShowMainCurrency(filterInfo.getBoolean("showmaincurrency"));
        param.setCusAndPusPks(cusAndSupPksByPartners);
        return param;
    }
}

