/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.bizpartner;

import java.math.BigDecimal;
import java.util.EventObject;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.ILocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.fi.arapcommon.form.AbstractARAPReportFormPlugin;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.report.BizTypeDisplayNameProvider;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApBizPartnerDetailFormRpt
extends AbstractARAPReportFormPlugin
implements HyperLinkClickListener {
    private List<Long> orgIds = null;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList reportList = (ReportList)this.getControl("reportlistap");
        reportList.addHyperClickListener((HyperLinkClickListener)this);
    }

    public void hyperLinkClick(HyperLinkClickEvent evt) {
        ReportList reportList = (ReportList)evt.getSource();
        IReportListModel reportListModel = reportList.getReportModel();
        DynamicObject rowData = reportListModel.getRowData(evt.getRowIndex());
        String type = rowData.getString("sourcebilltype");
        if ("sum".equals(type) || "totalsum".equals(type) || "periodbalance".equals(type)) {
            return;
        }
        if ("ar_settlerecord".equals(type) || "ap_settlerecord".equals(type)) {
            String message = ResManager.loadKDString((String)"\u660e\u7ec6\u8868\u4e0d\u652f\u6301\u8054\u67e5\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"ArApBizPartnerDetailFormRpt_0", (String)"fi-arapcommon", (Object[])new Object[0]);
            this.getView().showTipNotification(message);
            return;
        }
        long billid = rowData.getLong("sourcebillid");
        BillShowParameter showParameter = new BillShowParameter();
        showParameter.setFormId(type);
        showParameter.setPkId((Object)billid);
        showParameter.setStatus(OperationStatus.VIEW);
        showParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
        showParameter.setHasRight(true);
        this.getView().showForm((FormShowParameter)showParameter);
    }

    @Override
    protected List<Long> getOrgIds() {
        if (this.orgIds == null || this.orgIds.size() == 0) {
            List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs("arap_asstact_detail", "47150e89000000ac");
            this.orgIds = orgs.stream().map(e -> e.getLong("id")).collect(Collectors.toList());
        }
        return this.orgIds;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        BizTypeDisplayNameProvider bizTypeDisplayNameProvider = new BizTypeDisplayNameProvider("ap_finapbill", "ap_busbill", "cas_paybill", "ap_paidbill", "ap_settlerecord", "ar_finarbill", "ar_busbill", "cas_recbill", "ar_receivedbill", "ar_settlerecord");
        BigDecimal periodAmt = BigDecimal.ZERO;
        BigDecimal localPeriodAmt = BigDecimal.ZERO;
        for (int i = 0; i < rowData.size(); ++i) {
            ILocaleString displayName;
            DynamicObject row = (DynamicObject)rowData.get(i);
            BigDecimal payableAmt = row.getBigDecimal("payableamt");
            BigDecimal prepaidAmt = row.getBigDecimal("prepaidamt");
            BigDecimal payOffset = row.getBigDecimal("payoffset");
            BigDecimal offset = row.getBigDecimal("offset");
            BigDecimal receivableAmt = row.getBigDecimal("receivableamt");
            BigDecimal receivedAmt = row.getBigDecimal("receivedamt");
            BigDecimal receivedOffset = row.getBigDecimal("receivedoffset");
            BigDecimal recOffset = row.getBigDecimal("recoffset");
            BigDecimal balanceAmt = row.getBigDecimal("balance");
            switch (row.getInt("sumlevel")) {
                case -1: {
                    periodAmt = balanceAmt;
                    localPeriodAmt = row.getBigDecimal("localbalance");
                    break;
                }
                case 0: {
                    periodAmt = periodAmt.add(payableAmt).subtract(prepaidAmt).subtract(payOffset).add(offset).subtract(receivableAmt).add(receivedAmt).add(receivedOffset).subtract(recOffset);
                    row.set("balance", (Object)periodAmt);
                    localPeriodAmt = localPeriodAmt.add(row.getBigDecimal("localpayableamt")).subtract(row.getBigDecimal("localprepaidamt")).subtract(row.getBigDecimal("localpayoffset")).add(row.getBigDecimal("localoffset")).subtract(row.getBigDecimal("localreceivableamt")).add(row.getBigDecimal("localreceivedamt")).add(row.getBigDecimal("localreceivedoffset")).subtract(row.getBigDecimal("localrecoffset"));
                    row.set("localbalance", (Object)localPeriodAmt);
                    break;
                }
                case 1: {
                    periodAmt = BigDecimal.ZERO;
                }
            }
            String bizType = row.getString("biztype");
            if (EmptyUtils.isEmpty(bizType) || (displayName = bizTypeDisplayNameProvider.getDisplayName(bizType)) == null) continue;
            row.set("biztype", (Object)displayName.getLocaleValue());
        }
    }
}

