/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.bizpartner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.Field;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.helper.BizPartnerHelper;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.DefaultCustomSettingParser;
import kd.fi.arapcommon.report.RptCustomSettingParser;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.bizpartner.ApSumDataHelper;
import kd.fi.arapcommon.report.bizpartner.ArSumDataHelper;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;
import org.apache.commons.collections4.CollectionUtils;

public class ArApBizPartnerSumDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ArApBizPartnerSumDataRpt.class);
    private ARAPSumParam param;
    private RptCustomSettingParser parser;
    private FilterInfo filterInfo;
    private String[] dimensionAlias;
    private Set<String> commonAmtField;

    public DataSet query(ReportQueryParam queryParam, Object args) throws Throwable {
        try {
            this.filterInfo = queryParam.getFilter();
            this.param = this.getSumParam(queryParam);
            this.parser = new DefaultCustomSettingParser(queryParam);
            this.commonAmtField = new HashSet<String>(Arrays.asList("localbalanceamt", "balanceamt", "localperiodamt", "periodamt"));
            this.orgnizeDimensionJournalAlias();
            return this.query(queryParam);
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private DataSet query(ReportQueryParam queryParam) {
        ArSumDataHelper arSumDataHelper = new ArSumDataHelper(this.param, this.parser, this.filterInfo, this.dimensionAlias, this.commonAmtField);
        ApSumDataHelper apSumDataHelper = new ApSumDataHelper(this.param, this.parser, this.filterInfo, this.dimensionAlias, this.commonAmtField);
        DataSet apDataSet = apSumDataHelper.query(queryParam);
        DataSet arDataSet = arSumDataHelper.query(queryParam);
        List apFields = Stream.of(apDataSet.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        List arFields = Stream.of(arDataSet.getRowMeta().getFields()).map(Field::getName).collect(Collectors.toList());
        String[] selects = (String[])Stream.concat(apFields.stream(), arFields.stream()).distinct().toArray(String[]::new);
        String apSelect = Stream.of(selects).map(field -> apFields.contains(field) ? field : "0 " + field).collect(Collectors.joining(","));
        String arSelect = Stream.of(selects).map(field -> arFields.contains(field) ? field : "0 " + field).collect(Collectors.joining(","));
        apDataSet = apDataSet.select(apSelect);
        arDataSet = arDataSet.select(arSelect);
        DataSet dataSet = apDataSet.union(arDataSet);
        dataSet = BizPartnerHelper.convertAsstactToBizPartner(dataSet, selects, DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs()));
        GroupbyDataSet groupBy = dataSet.groupBy((String[])this.parser.getStatisticalDimensions().stream().toArray(String[]::new));
        List<String> arAmtFields = arSumDataHelper.getAmtFields();
        List<String> apAmtFields = apSumDataHelper.getAmtFields();
        Collection amtFields = CollectionUtils.union((Iterable)CollectionUtils.union(arAmtFields, apAmtFields), this.commonAmtField);
        Iterator iterator = amtFields.iterator();
        while (iterator.hasNext()) {
            String amtField;
            String sumExp = amtField = (String)iterator.next();
            if (this.commonAmtField.contains(amtField)) {
                String apAmtField = "ap".concat(amtField);
                String arAmtField = "ar".concat(amtField);
                String caseWhen = "(case when %s is null then 0 else %s end)";
                sumExp = String.format(caseWhen, apAmtField, apAmtField).concat(" - ").concat(String.format(caseWhen, arAmtField, arAmtField));
            }
            groupBy.sum(sumExp, amtField);
        }
        dataSet = groupBy.finish();
        dataSet = this.param.isShowMainCurrency() ? (this.param.isNotShowZero() && this.param.isNotShowNull() ? (this.isContainsPre() ? dataSet.filter("(balanceamt <> 0 or localbalanceamt <> 0) and ((receivableamt <> 0 or recamt<> 0 or arsettleamt <> 0 or recsettleamt <> 0 or localreceivableamt <> 0 or localrecamt <> 0 or arlocalsettleamt <> 0 or localrecsettleamt <> 0)  or (payableamt <> 0 or prepaidamt<> 0 or apsettleamt <> 0 or paysettleamt <> 0 or localpayableamt <> 0 or localprepaidamt <> 0 or aplocalsettleamt <> 0 or localpaysettleamt <> 0))") : dataSet.filter("(balanceamt <> 0 or localbalanceamt <> 0) and ((receivableamt <> 0 or arsettleamt <> 0 or localreceivableamt <> 0 or arlocalsettleamt <> 0)  or (payableamt <> 0 or apsettleamt <> 0 or localpayableamt <> 0 or aplocalsettleamt <> 0))")) : (this.param.isNotShowNull() ? (this.isContainsPre() ? dataSet.filter("receivableamt <> 0 or recamt<> 0 or arsettleamt <> 0 or recsettleamt <> 0 or payableamt <> 0 or prepaidamt<> 0 or apsettleamt <> 0 or paysettleamt <> 0 or localreceivableamt <> 0 or localrecamt <> 0 or arlocalsettleamt <> 0 or localrecsettleamt <> 0 or localpayableamt <> 0 or localprepaidamt <> 0 or aplocalsettleamt <> 0 or localpaysettleamt <> 0") : dataSet.filter("receivableamt <> 0 or arsettleamt <> 0 or payableamt <> 0 or apsettleamt <> 0 or localreceivableamt <> 0 or arlocalsettleamt <> 0 or localpayableamt <> 0 or aplocalsettleamt <> 0")) : (this.param.isNotShowZero() ? dataSet.filter("balanceamt <> 0 or localbalanceamt <> 0") : (this.isContainsPre() ? dataSet.filter("periodamt <> 0 or receivableamt <> 0 or recamt<> 0 or arsettleamt <> 0 or recsettleamt <> 0 or payableamt <> 0 or prepaidamt<> 0 or apsettleamt <> 0 or paysettleamt <> 0 or localperiodamt <> 0 or localreceivableamt <> 0 or localrecamt <> 0 or arlocalsettleamt <> 0 or localrecsettleamt <> 0 or localpayableamt <> 0 or localprepaidamt <> 0 or aplocalsettleamt <> 0 or localpaysettleamt <> 0") : dataSet.filter("periodamt <> 0 or receivableamt <> 0 or arsettleamt <> 0 or payableamt <> 0 or apsettleamt <> 0 or localperiodamt <> 0 or localreceivableamt <> 0 or  arlocalsettleamt <> 0 or localpayableamt <> 0 or aplocalsettleamt <> 0"))))) : (this.param.isNotShowZero() && this.param.isNotShowNull() ? (this.isContainsPre() ? dataSet.filter("balanceamt <> 0 and ((receivableamt <> 0 or recamt<> 0 or arsettleamt <> 0 or recsettleamt <> 0) or (payableamt <> 0 or prepaidamt<> 0 or apsettleamt <> 0 or paysettleamt <> 0))") : dataSet.filter("balanceamt <> 0 and ((receivableamt <> 0 or arsettleamt <> 0) or (payableamt <> 0 or apsettleamt <> 0))")) : (this.param.isNotShowNull() ? (this.isContainsPre() ? dataSet.filter("receivableamt <> 0 or recamt<> 0 or arsettleamt <> 0 or recsettleamt <> 0 or payableamt <> 0 or prepaidamt<> 0 or apsettleamt <> 0 or paysettleamt <> 0") : dataSet.filter("receivableamt <> 0 or arsettleamt <> 0 or payableamt <> 0 or apsettleamt <> 0")) : (this.param.isNotShowZero() ? dataSet.filter("balanceamt <> 0") : (this.isContainsPre() ? dataSet.filter("periodamt <> 0 or receivableamt <> 0 or recamt<> 0 or arsettleamt <> 0 or recsettleamt <> 0 or payableamt <> 0 or prepaidamt<> 0 or apsettleamt <> 0 or paysettleamt <> 0") : dataSet.filter("periodamt <> 0 or receivableamt <> 0 or arsettleamt <> 0 or payableamt <> 0 or apsettleamt <> 0")))));
        dataSet = dataSet.addField("0", "sumlevel");
        dataSet = this.calDataSetSum(dataSet, amtFields);
        return dataSet;
    }

    private boolean isContainsPre() {
        return this.filterInfo.getBoolean("containspre");
    }

    private DataSet calDataSetSum(DataSet dataSet, Collection<String> summaryFields) {
        SumParam sumParam = new SumParam(SumParam.SumType.TOTAL);
        sumParam.setSummaryFields(new ArrayList<String>(summaryFields));
        DataSet sumDataSet = DataSetUtils.sum(dataSet, sumParam);
        dataSet = dataSet.union(sumDataSet);
        LinkedHashSet<String> orderByFields = new LinkedHashSet<String>();
        orderByFields.addAll(sumParam.getGroupByFields());
        orderByFields.add("sumlevel");
        orderByFields.addAll(this.parser.getSortFields());
        dataSet = dataSet.orderBy(orderByFields.toArray(new String[0]));
        return dataSet;
    }

    private ARAPSumParam getSumParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        ARAPSumParam param = new ARAPSumParam();
        param.setOrgs(filterInfo.getDynamicObjectCollection("orgs"));
        DynamicObjectCollection bizpartnerFilters = filterInfo.getDynamicObjectCollection("bizpartners");
        param.setCusAndPusPks(BizPartnerHelper.getCusAndSupPksByPartners(bizpartnerFilters));
        param.setCurrencys(filterInfo.getDynamicObjectCollection("currencys"));
        param.setStartDate(DateUtils.getDataFormat(filterInfo.getDate("startdate"), true));
        param.setStopDate(DateUtils.getDataFormat(filterInfo.getDate("stopdate"), false));
        param.setBillScope(filterInfo.getString("billscope"));
        param.setIncludUnAudit(filterInfo.getBoolean("includunaudit"));
        param.setNotShowZero(filterInfo.getBoolean("notshowzero"));
        param.setNotShowNull(filterInfo.getBoolean("notshownull"));
        param.setNotShowNullAndZero(filterInfo.getBoolean("notshownullandzero"));
        param.setShowMainCurrency(filterInfo.getBoolean("showmaincurrency"));
        return param;
    }

    private void orgnizeDimensionJournalAlias() {
        List<String> dimensions = this.parser.getStatisticalDimensions();
        this.dimensionAlias = new String[dimensions.size()];
        for (int i = 0; i < this.dimensionAlias.length; ++i) {
            String journalAlias;
            this.dimensionAlias[i] = journalAlias = dimensions.get(i) + "2";
        }
    }
}

