/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.bizpartner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.algo.DataSet;
import kd.bos.algo.GroupbyDataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.RptCustomSettingParser;
import kd.fi.arapcommon.util.CollectionUtils;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;

public class ArSumDataHelper {
    private ARAPSumParam param;
    private RptCustomSettingParser customSettingParser;
    private FilterInfo filterInfo;
    private String[] journalDimensionAlias;
    private Set<String> commonAmtField;
    private List<String> amtFields;

    public ArSumDataHelper(ARAPSumParam param, RptCustomSettingParser customSettingParser, FilterInfo filterInfo, String[] journalDimensionAlias, Set<String> commonAmtField) {
        this.param = param;
        this.customSettingParser = customSettingParser;
        this.filterInfo = filterInfo;
        this.journalDimensionAlias = journalDimensionAlias;
        this.commonAmtField = commonAmtField;
    }

    public DataSet query(ReportQueryParam queryParam) {
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs());
        List<QFilter> journalFilters = this.getJournalFilters(this.filterInfo);
        List<String> journalDimensions = this.customSettingParser.getStatisticalDimensions();
        List<String> journalSelectors = this.getJournalSelectors();
        this.amtFields = new ArrayList<String>();
        this.amtFields.add("receivableamt");
        this.amtFields.add("localreceivableamt");
        this.amtFields.add("arsettleamt");
        this.amtFields.add("arlocalsettleamt");
        if (this.isContainsPrereceived()) {
            this.amtFields.add("recamt");
            this.amtFields.add("localrecamt");
            this.amtFields.add("recsettleamt");
            this.amtFields.add("localrecsettleamt");
        }
        DataSet journals = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_journal", (String)String.join((CharSequence)",", journalSelectors), (QFilter[])journalFilters.toArray(new QFilter[0]), null);
        GroupbyDataSet journalGroupByDataSet = journals.groupBy(this.journalDimensionAlias);
        for (String amtField : this.amtFields) {
            journalGroupByDataSet.sum(amtField);
        }
        journals = journalGroupByDataSet.finish();
        List<String> journalSelectedFields = DataSetUtils.getSelectedFields(journals, new String[0]);
        List<String> balanceDimensions = this.getBalanceDimensions();
        BalanceQuerier balanceQuerier = new BalanceQuerier(this.getBalanceType());
        DataSet lastestBalance = balanceQuerier.queryBalance(orgIds, this.param.getStartDate(), balanceDimensions, this.getBalanceQueryCustomFilters(this.filterInfo));
        JoinDataSet temJoinDataSet = journals.join(lastestBalance, JoinType.FULL);
        for (int i = 0; i < this.journalDimensionAlias.length; ++i) {
            temJoinDataSet = temJoinDataSet.on(this.journalDimensionAlias[i], balanceDimensions.get(i));
        }
        String[] balanceSelectedFields = CollectionUtils.mergeArrays(balanceDimensions.toArray(new String[0]), new String[]{"periodamt", "localperiodamt"});
        this.amtFields.add("periodamt");
        this.amtFields.add("localperiodamt");
        DataSet mergedDataSet = temJoinDataSet.select(journalSelectedFields.toArray(new String[0]), balanceSelectedFields).finish();
        ArrayList<String> exp = new ArrayList<String>(journalDimensions.size() + this.amtFields.size());
        for (int i = 0; i < journalDimensions.size(); ++i) {
            String journalField = journalDimensions.get(i) + "2";
            exp.add(String.format("case when %s=null then %s else %s end as %s", journalField, balanceDimensions.get(i), journalField, journalDimensions.get(i)));
        }
        for (String amtField : this.amtFields) {
            exp.add(String.format("case when %s=null then 0 else %s end as %s", amtField, amtField, amtField));
        }
        DataSet totalDataSet = mergedDataSet.select(exp.toArray(new String[0]));
        totalDataSet = this.isContainsPrereceived() ? totalDataSet.addField("periodamt+receivableamt-recamt-arsettleamt+recsettleamt", "balanceamt").addField("localperiodamt+localreceivableamt-localrecamt-arlocalsettleamt+localrecsettleamt", "localbalanceamt") : totalDataSet.addField("periodamt+receivableamt-arsettleamt", "balanceamt").addField("localperiodamt+localreceivableamt-arlocalsettleamt", "localbalanceamt");
        totalDataSet = totalDataSet.addField("0", "sumlevel");
        List<String> summaryFields = null;
        summaryFields = this.isContainsPrereceived() ? Arrays.asList("periodamt", "receivableamt", "recamt", "arsettleamt", "recsettleamt", "balanceamt", "localperiodamt", "localreceivableamt", "localrecamt", "arlocalsettleamt", "localrecsettleamt", "localbalanceamt") : Arrays.asList("periodamt", "receivableamt", "arsettleamt", "balanceamt", "localperiodamt", "localreceivableamt", "arlocalsettleamt", "localbalanceamt");
        String aliasSelects = Stream.concat(journalDimensions.stream(), summaryFields.stream().map(field -> field.concat(this.commonAmtField.contains(field) ? " ar" : " ").concat((String)field))).collect(Collectors.joining(","));
        totalDataSet = totalDataSet.select(aliasSelects);
        return totalDataSet;
    }

    private BalanceType getBalanceType() {
        String billScope = this.filterInfo.getString("billscope");
        if ("ALL".equals(billScope)) {
            return this.isContainsPrereceived() ? BalanceType.AR_FIN_BUS_RECEIVED : BalanceType.AR_FIN_BUS;
        }
        if ("finbill".equals(billScope)) {
            return this.isContainsPrereceived() ? BalanceType.AR_FIN_RECEIVED : BalanceType.AR_FIN;
        }
        if ("busbill".equals(billScope)) {
            return this.isContainsPrereceived() ? BalanceType.AR_BUS_RECEIVED : BalanceType.AR_BUS;
        }
        throw new KDBizException("Unknow Report Data Source " + billScope);
    }

    private List<String> getJournalSelectors() {
        String notCasSettleRealtionExp;
        List<String> dimensions = this.customSettingParser.getStatisticalDimensions();
        ArrayList<String> selectors = new ArrayList<String>(64);
        for (int i = 0; i < this.journalDimensionAlias.length; ++i) {
            String journalField = dimensions.get(i);
            String journalAlias = journalField + "2";
            selectors.add(journalField + " " + journalAlias);
        }
        String receivableAmtExpression = "case when SOURCEBILLTYPE='ar_finarbill' then receivableamt when SOURCEBILLTYPE='ar_busbill' then estimatedamt else 0 end as receivableamt";
        selectors.add(receivableAmtExpression);
        String localReceivableAmtExpression = "case when SOURCEBILLTYPE='ar_finarbill' then localreceivableamt when SOURCEBILLTYPE='ar_busbill' then localestimatedamt else 0 end as localreceivableamt";
        selectors.add(localReceivableAmtExpression);
        if (this.isContainsPrereceived()) {
            notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself' and BIZTYPE<>'recself'";
            String settleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + "  then 0-receivableamt else 0 end as arsettleamt";
            selectors.add(settleAmtExpression);
            String localSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-localreceivableamt else 0 end as arlocalsettleamt";
            selectors.add(localSettleAmtExpression);
            String casSettleRealtionExp = "BIZTYPE IN ('recsettle','recpaysettle','payrecsettle','recself','baddebtrecovery','aprecsettle','recclearing')";
            String casSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-receivedamt else 0 end as recsettleamt";
            selectors.add(casSettleAmtExpression);
            String localCasSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-localreceivedamt else 0 end as localrecsettleamt";
            selectors.add(localCasSettleAmtExpression);
            String receivedAmtExpression = "case when SOURCEBILLTYPE in ('cas_recbill','ar_receivedbill') then receivedamt else 0 end as recamt";
            selectors.add(receivedAmtExpression);
            String localReceivedAmtExpression = "case when SOURCEBILLTYPE in ('cas_recbill','ar_receivedbill') then localreceivedamt else 0 end as localrecamt";
            selectors.add(localReceivedAmtExpression);
        } else {
            notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself' and BIZTYPE<>'recself'";
            selectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-receivableamt else 0 end as arsettleamt");
            selectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-localreceivableamt else 0 end as arlocalsettleamt");
            selectors.add("0 recamt");
            selectors.add("0 localrecamt");
            selectors.add("0 recsettleamt");
            selectors.add("0 localrecsettleamt");
        }
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        selectors.add("biztype");
        return selectors;
    }

    private boolean isContainsPrereceived() {
        return this.filterInfo.getBoolean("containspre");
    }

    private List<String> getBalanceDimensions() {
        List<String> journalDimensions = this.customSettingParser.getStatisticalDimensions();
        ArrayList<String> balanceDimensions = new ArrayList<String>();
        BalJouMapper mapper = BalJouMapper.getMapper(false);
        BalanceSettingParser balanceSettingParser = new BalanceSettingParser(mapper);
        for (String journalField : journalDimensions) {
            List<String> balanceFields = balanceSettingParser.getBalanceFields(journalField);
            if (balanceFields == null || balanceFields.isEmpty()) {
                throw new KDBizException("the related balance field is not exist:" + journalField);
            }
            balanceDimensions.addAll(balanceFields);
        }
        return balanceDimensions;
    }

    private List<QFilter> getBalanceQueryCustomFilters(FilterInfo filterInfo) {
        DynamicObjectCollection currencys;
        ArrayList<QFilter> balanceCustomFilters = new ArrayList<QFilter>(64);
        List<Long> cusAndPusPks = this.param.getCusAndPusPks();
        if (EmptyUtils.isNotEmpty(cusAndPusPks)) {
            QFilter asstactFilter = new QFilter("asstact", "in", cusAndPusPks);
            balanceCustomFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty(currencys = this.param.getCurrencys())) {
            List<Object> currencyPks = DynamicObjectHelper.getIdList((Collection<DynamicObject>)currencys);
            QFilter currencyFilter = new QFilter("currency", "in", currencyPks);
            balanceCustomFilters.add(currencyFilter);
        }
        balanceCustomFilters.addAll(this.customSettingParser.getCustomFilters());
        return balanceCustomFilters;
    }

    private List<QFilter> getJournalFilters(FilterInfo filterInfo) {
        DynamicObjectCollection currencys;
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)this.param.getOrgs());
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        QFilter beginDateFilter = new QFilter("bizdate", ">=", (Object)this.param.getStartDate());
        QFilter endDateFilter = new QFilter("bizdate", "<=", (Object)this.param.getStopDate());
        ArrayList<QFilter> journalFilters = new ArrayList<QFilter>();
        journalFilters.add(orgFilter);
        journalFilters.add(beginDateFilter);
        journalFilters.add(endDateFilter);
        List<Long> cusAndPusPks = this.param.getCusAndPusPks();
        if (!EmptyUtils.isEmpty(cusAndPusPks)) {
            QFilter asstactFilter = new QFilter("asstact", "in", cusAndPusPks);
            journalFilters.add(asstactFilter);
        }
        if (!EmptyUtils.isEmpty(currencys = this.param.getCurrencys())) {
            List<Object> currencyPks = DynamicObjectHelper.getIdList((Collection<DynamicObject>)currencys);
            QFilter currencyFilter = new QFilter("currency", "in", currencyPks);
            journalFilters.add(currencyFilter);
        }
        journalFilters.addAll(this.customSettingParser.getCustomFilters());
        ArrayList<String> journalSourceEntityTypes = new ArrayList<String>();
        String billScope = filterInfo.getString("billscope");
        if ("ALL".equals(billScope)) {
            journalSourceEntityTypes.add("ar_finarbill");
            journalSourceEntityTypes.add("ar_settlerecord");
            journalSourceEntityTypes.add("ap_settlerecord");
            journalSourceEntityTypes.add("ar_busbill");
        } else if ("finbill".equals(billScope)) {
            journalSourceEntityTypes.add("ar_finarbill");
            journalSourceEntityTypes.add("ar_settlerecord");
            journalSourceEntityTypes.add("ap_settlerecord");
        } else if ("busbill".equals(billScope)) {
            journalSourceEntityTypes.add("ar_busbill");
        } else {
            throw new KDBizException("Unknow Report Data Source " + billScope);
        }
        if (this.isContainsPrereceived()) {
            journalSourceEntityTypes.add("cas_recbill");
            journalSourceEntityTypes.add("ar_receivedbill");
        }
        journalFilters.add(new QFilter("sourcebilltype", "in", journalSourceEntityTypes));
        return journalFilters;
    }

    public List<String> getAmtFields() {
        return this.amtFields;
    }

    public void setAmtFields(List<String> amtFields) {
        this.amtFields = amtFields;
    }
}

