/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.detailv2.transform;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.vo.SumRptParam;

public class FilterandSortResults
implements IDataTransform {
    private SumRptParam param;
    private Set<String> showKeys;

    public FilterandSortResults(ReportDataCtx ctx) {
        this.param = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        this.showKeys = ctx.getShowKeyCols();
    }

    public DataSet doTransform(DataSet srcData) {
        String[] fields = srcData.getRowMeta().getFieldNames();
        DataSet detailData = srcData.filter("sumlevel = 0");
        DataSet balanceData = srcData.filter("sumlevel = -1");
        DataSet journalBalanceRawData = detailData.union(balanceData);
        DataSet sumData = srcData.filter("sumlevel = 1");
        journalBalanceRawData = journalBalanceRawData.union(sumData);
        if (this.param.isNotShowZero()) {
            journalBalanceRawData = this.filterZeroBalanceData(journalBalanceRawData, sumData);
        }
        if (this.param.isNotShowNull()) {
            journalBalanceRawData = this.filterNoBizData(journalBalanceRawData);
        }
        if (this.param.isNotShowNullAndZero()) {
            journalBalanceRawData = this.filterNotShowNullAndZero(journalBalanceRawData, sumData);
        }
        journalBalanceRawData = journalBalanceRawData.select(fields);
        DataSet totalSumData = this.totalSum(journalBalanceRawData);
        LinkedList<String> orderByFields = new LinkedList<String>();
        for (String key : this.showKeys) {
            orderByFields.add(key + " desc");
        }
        orderByFields.add("sumlevel");
        orderByFields.add("bizdate asc");
        DataSet union = journalBalanceRawData.union(totalSumData).orderBy(orderByFields.toArray(new String[0]));
        return this.createResult(union);
    }

    private DataSet createResult(DataSet union) {
        BigDecimal periodAmt = BigDecimal.ZERO;
        BigDecimal localPeriodAmt = BigDecimal.ZERO;
        int localBalanceIdx = -1;
        RowMeta rowMeta = union.getRowMeta();
        int length = rowMeta.getFields().length;
        int balanceIdx = rowMeta.getFieldIndex("balance");
        if (this.param.isShowMainCurrency()) {
            localBalanceIdx = rowMeta.getFieldIndex("localbalance");
        }
        DataSetBuilder dataSetBuilder = Algo.create((String)"newdetailrpt.calculatebalance").createDataSetBuilder(rowMeta);
        while (union.hasNext()) {
            Object[] rowData = new Object[length];
            Row row = union.next();
            for (int i = 0; i < length; ++i) {
                rowData[i] = row.get(i);
            }
            periodAmt = this.calculateBalance(periodAmt, row, false);
            rowData[balanceIdx] = periodAmt;
            if (this.param.isShowMainCurrency() && localBalanceIdx != -1) {
                localPeriodAmt = this.calculateBalance(localPeriodAmt, row, true);
                rowData[localBalanceIdx] = localPeriodAmt;
            }
            dataSetBuilder.append(rowData);
        }
        return dataSetBuilder.build();
    }

    private BigDecimal calculateBalance(BigDecimal periodAmt, Row row, boolean isLocalAmt) {
        BigDecimal finAmt = row.getBigDecimal(isLocalAmt ? "localfinamt" : "finamt");
        BigDecimal settleAmt = row.getBigDecimal(isLocalAmt ? "localsettleamt" : "settleamt");
        BigDecimal casSettleAmt = row.getBigDecimal(isLocalAmt ? "localcassettleamt" : "cassettleamt");
        BigDecimal casAmt = row.getBigDecimal(isLocalAmt ? "localprecasamt" : "precasamt");
        BigDecimal balanceAmt = row.getBigDecimal(isLocalAmt ? "localbalance" : "balance");
        switch (row.getInteger("sumlevel")) {
            case -1: {
                return balanceAmt;
            }
            case 0: {
                return periodAmt.add(finAmt).subtract(casAmt).subtract(settleAmt).add(casSettleAmt);
            }
        }
        return balanceAmt;
    }

    private DataSet filterNoBizData(DataSet journalBalanceRawData) {
        String[] fields = journalBalanceRawData.getRowMeta().getFieldNames();
        DataSet finish = journalBalanceRawData.groupBy(this.showKeys.toArray(new String[0])).count().finish();
        JoinDataSet join = journalBalanceRawData.join(finish);
        for (String key : this.showKeys) {
            join = join.on(key, key);
        }
        journalBalanceRawData = join.select(fields, new String[]{"count"}).finish();
        return journalBalanceRawData.filter("count > 2 ");
    }

    private DataSet filterNotShowNullAndZero(DataSet journalBalanceRawData, DataSet sumData) {
        JoinDataSet countJoin;
        DataSet finish;
        String[] selectedFields = journalBalanceRawData.getRowMeta().getFieldNames();
        JoinDataSet join = journalBalanceRawData.join(sumData, JoinType.LEFT);
        for (String key : this.showKeys) {
            join = join.on(key, key);
        }
        if (this.param.isShowMainCurrency()) {
            journalBalanceRawData = join.select(selectedFields, new String[]{"balance balance3", "localbalance localbalance3"}).finish();
            finish = journalBalanceRawData.groupBy(this.showKeys.toArray(new String[0])).count().finish();
            countJoin = journalBalanceRawData.join(finish);
            for (String key : this.showKeys) {
                countJoin = countJoin.on(key, key);
            }
            if (!this.param.isNotShowNull()) {
                journalBalanceRawData = countJoin.select(journalBalanceRawData.getRowMeta().getFieldNames(), new String[]{"count"}).finish();
            }
            return journalBalanceRawData.filter("balance3 <> 0 or localbalance3 <> 0 or count > 2");
        }
        journalBalanceRawData = join.select(selectedFields, new String[]{"balance balance3"}).finish();
        finish = journalBalanceRawData.groupBy(this.showKeys.toArray(new String[0])).count().finish();
        countJoin = journalBalanceRawData.join(finish);
        for (String key : this.showKeys) {
            countJoin = countJoin.on(key, key);
        }
        if (!this.param.isNotShowNull()) {
            journalBalanceRawData = countJoin.select(journalBalanceRawData.getRowMeta().getFieldNames(), new String[]{"count"}).finish();
        }
        return journalBalanceRawData.filter("balance3 <> 0 or count > 2");
    }

    private DataSet filterZeroBalanceData(DataSet journalBalanceRawData, DataSet sumData) {
        String[] fields = journalBalanceRawData.getRowMeta().getFieldNames();
        JoinDataSet join = journalBalanceRawData.join(sumData, JoinType.LEFT);
        for (String key : this.showKeys) {
            join = join.on(key, key);
        }
        if (this.param.isShowMainCurrency()) {
            journalBalanceRawData = join.select(fields, new String[]{"balance balance2", "localbalance localbalance2"}).finish();
            journalBalanceRawData = journalBalanceRawData.filter("balance2 <> 0 or localbalance2 <> 0");
            return journalBalanceRawData.select(fields);
        }
        journalBalanceRawData = join.select(fields, new String[]{"balance balance2"}).finish();
        return journalBalanceRawData.filter("balance2 <> 0");
    }

    private DataSet totalSum(DataSet rawDataSet) {
        rawDataSet = rawDataSet.filter("sumlevel = 1");
        SumParam totalSumParam = new SumParam(SumParam.SumType.TOTAL);
        ArrayList<String> fields = new ArrayList<String>(6);
        fields.add("finamt");
        fields.add("precasamt");
        fields.add("settleamt");
        fields.add("cassettleamt");
        fields.add("balance");
        if (this.param.isShowMainCurrency()) {
            fields.add("localfinamt");
            fields.add("localprecasamt");
            fields.add("localsettleamt");
            fields.add("localcassettleamt");
            fields.add("localbalance");
        }
        totalSumParam.addSummaryField(fields.toArray(new String[0]));
        DataSet totalSumData = DataSetUtils.sum(rawDataSet, totalSumParam);
        List totalSumDataSetFields = DataSetUtils.getSelectedFields(rawDataSet, new String[0]).stream().map(f -> {
            if ("type".equalsIgnoreCase((String)f)) {
                return "'totalsum' type";
            }
            if ("sumlevel".equalsIgnoreCase((String)f)) {
                return "2 sumlevel";
            }
            return f;
        }).collect(Collectors.toList());
        totalSumData = totalSumData.select(String.join((CharSequence)",", totalSumDataSetFields));
        return totalSumData;
    }
}

