/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.detailv2.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.FilterFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.fi.arapcommon.vo.SumRptParam;

public class BizJournalFilterFunc
extends FilterFunction {
    RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private SumRptParam param;

    public BizJournalFilterFunc(RowMeta rowMeta, ReportDataCtx ctx) {
        this.rowMeta = rowMeta;
        this.param = (SumRptParam)ctx.getParam(SumRptParam.class.getName());
        this.buildIndexs();
    }

    private void buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(13);
        columns.add("bizdate");
        columns.add("biztype");
        columns.add("entitykey");
        columns.add("finamt");
        columns.add("precasamt");
        columns.add("settleamt");
        columns.add("cassettleamt");
        if (this.param.isShowMainCurrency()) {
            columns.add("localfinamt");
            columns.add("localprecasamt");
            columns.add("localsettleamt");
            columns.add("localcassettleamt");
        }
        this.indexs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }

    public boolean test(RowX rowX) {
        if (!"ap_journal".equals(rowX.getString(this.indexs.get("entitykey").intValue())) && !"ar_journal".equals(rowX.getString(this.indexs.get("entitykey").intValue()))) {
            return true;
        }
        boolean isnotZero = true;
        Date bizDate = rowX.getDate(this.indexs.get("bizdate").intValue());
        if (bizDate.compareTo(this.param.getStartDate()) < 0 || bizDate.compareTo(this.param.getStopDate()) > 0) {
            return isnotZero;
        }
        BigDecimal finAmt = rowX.getBigDecimal(this.indexs.get("finamt").intValue());
        BigDecimal settleAmt = rowX.getBigDecimal(this.indexs.get("settleamt").intValue());
        BigDecimal preCasAmt = rowX.getBigDecimal(this.indexs.get("precasamt").intValue());
        BigDecimal casSettleAmt = rowX.getBigDecimal(this.indexs.get("cassettleamt").intValue());
        if (this.param.isShowMainCurrency()) {
            BigDecimal localFinAmt = rowX.getBigDecimal(this.indexs.get("localfinamt").intValue());
            BigDecimal localSettleAmt = rowX.getBigDecimal(this.indexs.get("localsettleamt").intValue());
            BigDecimal localPreCasAmt = rowX.getBigDecimal(this.indexs.get("localprecasamt").intValue());
            BigDecimal localCasSettleAmt = rowX.getBigDecimal(this.indexs.get("localcassettleamt").intValue());
            isnotZero = finAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || settleAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || preCasAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || casSettleAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || localFinAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || localSettleAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || localPreCasAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || localCasSettleAmt.compareTo(BigDecimal.ZERO) != 0;
        } else {
            isnotZero = finAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || settleAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || preCasAmt.compareTo(BigDecimal.ZERO) != 0;
            isnotZero = isnotZero || casSettleAmt.compareTo(BigDecimal.ZERO) != 0;
        }
        return isnotZero;
    }
}

