/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.invoicev2;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.form.field.BasedataEdit;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.report.ReportList;
import kd.bos.report.plugin.AbstractReportFormPlugin;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.invoicev2.InvoiceRptParam;
import kd.fi.arapcommon.util.DateUtils;

public class InvoiceForm
extends AbstractReportFormPlugin
implements HyperLinkClickListener {
    private List<Long> orgIds = null;

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
        BasedataEdit orgCtrl = (BasedataEdit)this.getControl("orgs");
        orgCtrl.addBeforeF7SelectListener(beforeF7SelectEvent -> {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            showParameter.getListFilterParameter().setFilter(new QFilter("id", "in", this.getOrgIds()));
        });
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.resetFilterGrid();
    }

    private void resetFilterGrid() {
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("commonfs");
        List filterColumns = filterGrid.getFilterColumns();
        ArrayList<Map> cols = new ArrayList<Map>(filterColumns.size());
        for (Map info : filterColumns) {
            String fieldName = (String)info.get("fieldName");
            if (!this.filterGrid(fieldName)) continue;
            cols.add(info);
        }
        filterGrid.setFilterColumns(cols);
    }

    private boolean filterGrid(String fieldName) {
        String[] split = fieldName.split("\\.");
        HashSet<String> removedPros = new HashSet<String>(32);
        removedPros.add("org");
        removedPros.add("asstacttype");
        removedPros.add("asstact");
        removedPros.add("invoicedate");
        removedPros.add("invoicetypef7");
        removedPros.add("currency");
        removedPros.add("pricetaxtotal");
        removedPros.add("taxrate");
        removedPros.add("tax");
        removedPros.add("amount");
        removedPros.add("usedamt");
        removedPros.add("invid");
        removedPros.add("buyername");
        removedPros.add("buyertin");
        removedPros.add("asstactname");
        removedPros.add("sellertin");
        removedPros.add("remark");
        removedPros.add("istaxdeduction");
        removedPros.add("taxdeduction");
        removedPros.add("invoicestatus");
        removedPros.add("finbillid");
        removedPros.add("billstatus");
        removedPros.add("bizdate");
        removedPros.add("createtime");
        removedPros.add("settlestatus");
        removedPros.add("isvoucher");
        removedPros.add("voucherno");
        removedPros.add("voucherid");
        return !removedPros.contains(split[0]);
    }

    public void initDefaultQueryParam(ReportQueryParam queryParam) {
        Date newDate;
        List<Long> orgIds;
        super.initDefaultQueryParam(queryParam);
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("orgs")) && !ObjectUtils.isEmpty(orgIds = this.getOrgIds())) {
            long orgId = RequestContext.get().getOrgId();
            if (!orgIds.contains(orgId)) {
                orgId = orgIds.get(0);
            }
            this.getModel().setValue("orgs", (Object)new Object[]{orgId});
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("invoicestartdate"))) {
            newDate = new Date();
            this.getModel().setValue("invoicestartdate", (Object)DateUtils.getMinMonthDate(newDate));
            this.getModel().setValue("invoicestopdate", (Object)newDate);
        }
        if (ObjectUtils.isEmpty((Object)this.getModel().getValue("bizstartdate"))) {
            newDate = new Date();
            this.getModel().setValue("bizstartdate", (Object)DateUtils.getMinMonthDate(newDate));
            this.getModel().setValue("bizstopdate", (Object)newDate);
        }
    }

    private List<Long> getOrgIds() {
        if (this.orgIds == null) {
            List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs(this.getView().getEntityId(), "47150e89000000ac", false);
            this.orgIds = orgs.stream().map(org -> org.getLong("id")).distinct().collect(Collectors.toList());
        }
        return this.orgIds;
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showqtycols".equals(key)) {
            List qtyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!qtyCols.contains("tax")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u503c\u201d\u4e2d\u9009\u9879\u201c\u7a0e\u989d\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!qtyCols.contains("taxdeduction")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u503c\u201d\u4e2d\u9009\u9879\u201c\u62b5\u6263\u7a0e\u989d\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        } else if ("showkeycols".equals(key)) {
            List keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (!keyCols.contains("invid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u6536\u7968\u5355id\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("finbillid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5e94\u4ed8\u5355id\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("voucherid")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u51ed\u8bc1id\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("org")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u7ed3\u7b97\u7ec4\u7ec7\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("asstacttype")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5f80\u6765\u7c7b\u578b\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("asstact")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5f80\u6765\u6237\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_12", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("invoicebillno")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u6536\u7968\u5355\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_13", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("invoicedate")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5f00\u7968\u65e5\u671f\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
            if (!keyCols.contains("bizdate")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u6c47\u603b\u4f9d\u636e\u201d\u4e2d\u9009\u9879\u201c\u5355\u636e\u65e5\u671f\u201d\u5fc5\u9009\u3002", (String)"InvoiceForm_15", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    public boolean verifyQuery(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        if (filterInfo == null) {
            return false;
        }
        DynamicObjectCollection org = (DynamicObjectCollection)filterInfo.getValue("orgs");
        if (ObjectUtils.isEmpty((Object)org)) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceForm_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Date invoiceStartDate = filterInfo.getDate("invoicestartdate");
        if (invoiceStartDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8303\u56f4\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceForm_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Date invoiceStopDate = filterInfo.getDate("invoicestopdate");
        if (invoiceStopDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5f00\u7968\u65e5\u671f\u8303\u56f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceForm_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Date bizStartDate = filterInfo.getDate("bizstartdate");
        if (bizStartDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f\u8303\u56f4\u5f00\u59cb\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceForm_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        Date bizStopDate = filterInfo.getDate("invoicestopdate");
        if (bizStopDate == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u5355\u636e\u65e5\u671f\u8303\u56f4\u7ed3\u675f\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"InvoiceForm_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            return false;
        }
        return super.verifyQuery(queryParam);
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        InvoiceRptParam param = this.buildReportParam(queryParam);
        queryParam.getCustomParam().put(InvoiceRptParam.class.getName(), param);
    }

    private InvoiceRptParam buildReportParam(ReportQueryParam queryParam) {
        InvoiceRptParam param = new InvoiceRptParam();
        FilterInfo filterInfo = queryParam.getFilter();
        param.setOrgIds(DynamicObjectHelper.getLongIds((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("orgs")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            DynamicObjectCollection asstacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactIds(ReportHelper.getBasedataIds((List<DynamicObject>)asstacts));
        }
        param.setInvoiceStartDate(DateUtils.getDataFormat(filterInfo.getDate("invoicestartdate"), true));
        param.setInvoiceStopDate(DateUtils.getDataFormat(filterInfo.getDate("invoicestopdate"), false));
        param.setBizStartDate(DateUtils.getDataFormat(filterInfo.getDate("bizstartdate"), true));
        param.setBizStopDate(DateUtils.getDataFormat(filterInfo.getDate("bizstopdate"), false));
        param.setInvoiceTypeIds(DynamicObjectHelper.getLongIds((Collection<DynamicObject>)filterInfo.getDynamicObjectCollection("invoicetypef7s")));
        param.setIsVoucherStr(filterInfo.getString("q_isvoucher"));
        return param;
    }

    public void processRowData(String gridPK, DynamicObjectCollection rowData, ReportQueryParam queryParam) {
        super.processRowData(gridPK, rowData, queryParam);
        for (DynamicObject row : rowData) {
            if (!row.getBoolean("istaxdeduction")) continue;
            row.set("taxdeduction", (Object)row.getBigDecimal("tax"));
        }
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        String fieldName;
        ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(hyperLinkClickEvent.getRowIndex());
        BillShowParameter parameter = new BillShowParameter();
        switch (fieldName = hyperLinkClickEvent.getFieldName()) {
            case "billno": {
                parameter.setFormId("ap_finapbill");
                parameter.setPkId((Object)rowData.getLong("finbillid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "invoicebillno": {
                parameter.setFormId("ap_invoice");
                parameter.setPkId((Object)rowData.getLong("invid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
                break;
            }
            case "voucherno": {
                parameter.setFormId("gl_voucher");
                parameter.setPkId((Object)rowData.getLong("voucherid"));
                parameter.setStatus(OperationStatus.VIEW);
                parameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
                this.getView().showForm((FormShowParameter)parameter);
            }
        }
    }
}

