/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.mlv2.transform.func;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.util.TransformUtil;

public class CalculateColumnMapFunc
extends MapFunction {
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private boolean isShowPlan;

    public CalculateColumnMapFunc(RowMeta rowMeta, boolean isShowPlan) {
        this.rowMeta = rowMeta;
        this.indexs = this.buildIndexs();
        this.isShowPlan = isShowPlan;
    }

    private Map<String, Integer> buildIndexs() {
        ArrayList<String> columns = new ArrayList<String>(4);
        columns.add("topayamt");
        columns.add("lockedamt");
        columns.add("settledamt");
        columns.add("planseq");
        return TransformUtil.buildIndexs((RowMeta)this.rowMeta, columns);
    }

    public RowX map(RowX rowX) {
        BigDecimal lockedAmt = rowX.getBigDecimal(this.indexs.get("lockedamt").intValue());
        BigDecimal settledAmt = rowX.getBigDecimal(this.indexs.get("settledamt").intValue());
        rowX.set(this.indexs.get("topayamt").intValue(), (Object)lockedAmt.subtract(settledAmt));
        if (!this.isShowPlan) {
            rowX.set(this.indexs.get("planseq").intValue(), (Object)0);
        }
        return rowX;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

