/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.sumv2;

import java.util.Collection;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.IReportListModel;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.form.FormShowParameter;
import kd.bos.form.control.Control;
import kd.bos.form.events.BeforeFieldPostBackEvent;
import kd.bos.form.events.HyperLinkClickEvent;
import kd.bos.form.events.HyperLinkClickListener;
import kd.bos.report.ReportList;
import kd.bos.report.ReportShowParameter;
import kd.bplat.scmc.report.conf.BigTableColConf;
import kd.bplat.scmc.report.conf.ReportConf;
import kd.bplat.scmc.report.core.ReportDataHandle;
import kd.fi.arapcommon.form.AbstractARAPReportFormPlugin;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.helper.OrgHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.SumRptParam;
import org.apache.commons.lang.StringUtils;

public class SumForm
extends AbstractARAPReportFormPlugin
implements HyperLinkClickListener {
    private List<Long> orgIds = null;
    private ReportConf confCache;

    @Override
    public void registerListener(EventObject e) {
        super.registerListener(e);
        ReportList list = (ReportList)this.getControl("reportlistap");
        list.addHyperClickListener((HyperLinkClickListener)this);
    }

    @Override
    protected List<Long> getOrgIds() {
        if (this.orgIds == null) {
            List<DynamicObject> orgs = OrgHelper.getAuthorizedInitializedOrgs(this.getView().getEntityId(), "47150e89000000ac", !this.isAp());
            this.orgIds = orgs.stream().map(org -> org.getLong("id")).distinct().collect(Collectors.toList());
        }
        return this.orgIds;
    }

    private boolean isAp() {
        return StringUtils.startsWith((String)this.getView().getEntityId(), (String)"ap_");
    }

    public void beforeFieldPostBack(BeforeFieldPostBackEvent e) {
        super.beforeFieldPostBack(e);
        Control source = (Control)e.getSource();
        String key = source.getKey();
        Object value = e.getValue();
        if ("showkeycols".equals(key)) {
            List keyCols = Stream.of(((String)value).split(",")).collect(Collectors.toList());
            if (keyCols.contains("asstact") && !keyCols.contains("asstacttype")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u9009\u62e9\u201c\u5f80\u6765\u6237\u201d\u65f6\uff0c\u201c\u5f80\u6765\u7c7b\u578b\u201d\u5fc5\u9009\u3002", (String)"SumandDetailForm_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            } else if (!keyCols.contains("currency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u201c\u5e01\u79cd\u201d\u5fc5\u9009\u3002", (String)"SumandDetailForm_1", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            } else if (!((Boolean)this.getModel().getValue("showmaincurrency")).booleanValue() && keyCols.contains("basecurrency")) {
                this.getView().showTipNotification(ResManager.loadKDString((String)"\u4e0d\u663e\u793a\u6298\u672c\u5e01\u65f6\u201c\u7edf\u8ba1\u7ef4\u5ea6\u201d\u4e2d\u201c\u672c\u4f4d\u5e01\u201d\u4e0d\u5141\u8bb8\u9009\u62e9\u3002", (String)"SumandDetailForm_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                e.setCancel(true);
                this.getView().updateView(key);
            }
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        IDataModel m = this.getModel();
        if ("showmaincurrency".equals(key)) {
            ChangeData[] changeDatas = e.getChangeSet();
            Object newValue = changeDatas[0].getNewValue();
            boolean isShowLocalAmt = (Boolean)newValue;
            ReportConf conf = this.getReportConf();
            List bigTableColConfs = conf.getBigTableColConf();
            String showKeyCols = (String)m.getValue("showkeycols");
            for (BigTableColConf bigTableColConf : bigTableColConfs) {
                if (isShowLocalAmt) {
                    if (!"basecurrency".equals(bigTableColConf.getCol())) continue;
                    String concat = showKeyCols.concat(",basecurrency");
                    m.setValue("showkeycols", (Object)concat);
                    continue;
                }
                List showKeyColList = Stream.of(showKeyCols.split(",")).filter(EmptyUtils::isNotEmpty).collect(Collectors.toList());
                showKeyColList.removeIf("basecurrency"::equals);
                m.setValue("showkeycols", (Object)String.join((CharSequence)",", showKeyColList));
            }
            List cols = bigTableColConfs.stream().filter(colConf -> "B".equals(colConf.getCalType())).map(BigTableColConf::getCol).collect(Collectors.toList());
            if (!isShowLocalAmt) {
                cols.removeIf(col -> StringUtils.startsWith((String)col, (String)"local"));
            }
            m.setValue("showqtycols", (Object)String.join((CharSequence)",", cols));
        }
    }

    private ReportConf getReportConf() {
        if (this.confCache == null) {
            this.confCache = ReportDataHandle.loadReportConf((String)this.getModel().getDataEntityType().getName());
        }
        return this.confCache;
    }

    public void beforeQuery(ReportQueryParam queryParam) {
        super.beforeQuery(queryParam);
        SumRptParam param = this.getSumParam(queryParam);
        queryParam.getCustomParam().put(SumRptParam.class.getName(), param);
    }

    private SumRptParam getSumParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        SumRptParam param = new SumRptParam();
        param.setApSys(this.isAp());
        DynamicObjectCollection orgs = filterInfo.getDynamicObjectCollection("orgs");
        List<Long> orgIds = DynamicObjectHelper.getLongIds((Collection<DynamicObject>)orgs);
        param.setOrgIds(orgIds);
        param.setAsstactType(filterInfo.getString("q_asstacttype"));
        if (!EmptyUtils.isEmpty(param.getAsstactType())) {
            DynamicObjectCollection asstacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactIds(ReportHelper.getBasedataIds((List<DynamicObject>)asstacts));
        }
        DynamicObjectCollection currencys = filterInfo.getDynamicObjectCollection("currencys");
        param.setCurrencyIds(DynamicObjectHelper.getLongIds((Collection<DynamicObject>)currencys));
        Date startDate = DateUtils.getDataFormat(filterInfo.getDate("startdate"), true);
        param.setStartDate(startDate);
        param.setStopDate(DateUtils.getDataFormat(filterInfo.getDate("stopdate"), false));
        param.setBillScope(filterInfo.getString("billscope"));
        param.setNotShowZero(filterInfo.getBoolean("notshowzero"));
        param.setNotShowNull(filterInfo.getBoolean("notshownull"));
        param.setNotShowNullAndZero(filterInfo.getBoolean("notshownullandzero"));
        param.setShowMainCurrency(filterInfo.getBoolean("showmaincurrency"));
        param.setContainsPrepaid(filterInfo.getBoolean("containsprepaid"));
        param.setOnlyContainsAmount(filterInfo.getBoolean("onlycontainsamount"));
        CloseRecordService closeRecordService = new CloseRecordService(this.isAp());
        HashMap<Long, Map<Long, Date>> closeInfoMap = new HashMap<Long, Map<Long, Date>>(orgIds.size());
        Date minCloseDate = null;
        Date balanceDate = DateUtils.getLastDay(startDate, 1);
        for (Long orgId : orgIds) {
            HashMap<Long, Date> closeMap = new HashMap<Long, Date>(1);
            DynamicObject closeRecord = closeRecordService.queryCloseRecord(orgId, balanceDate);
            if (closeRecord == null) continue;
            if (minCloseDate == null) {
                minCloseDate = new Date();
            }
            Date closeDate = closeRecord.getDate("closedate");
            closeMap.put(closeRecord.getLong("id"), closeDate);
            closeInfoMap.put(orgId, closeMap);
            if (!minCloseDate.after(closeDate)) continue;
            minCloseDate = closeDate;
        }
        param.setCloseInfoMap(closeInfoMap);
        param.setMinCloseDate(minCloseDate);
        return param;
    }

    public void hyperLinkClick(HyperLinkClickEvent hyperLinkClickEvent) {
        super.registerListener((EventObject)hyperLinkClickEvent);
        ReportShowParameter param = new ReportShowParameter();
        param.setFormId(this.isAp() ? "ap_detailrpt_n" : "ar_detailrpt_n");
        param.getOpenStyle().setTargetKey(this.getView().getFormShowParameter().getOpenStyle().getTargetKey());
        param.getOpenStyle().setShowType(this.getView().getFormShowParameter().getFormConfig().getShowType());
        ReportList reportList = (ReportList)hyperLinkClickEvent.getSource();
        IReportListModel reportModel = reportList.getReportModel();
        DynamicObject rowData = reportModel.getRowData(hyperLinkClickEvent.getRowIndex());
        param.setCustomParams(this.getCustomParams(rowData));
        this.getView().showForm((FormShowParameter)param);
    }

    private Map<String, Object> getCustomParams(DynamicObject row) {
        HashMap<String, Object> customParams = new HashMap<String, Object>(8);
        customParams.put("isopenbyhyperlink", Boolean.TRUE);
        String showKeyCols = (String)this.getModel().getValue("showkeycols");
        List dimensions = Stream.of(showKeyCols.split(",")).filter(EmptyUtils::isNotEmpty).collect(Collectors.toList());
        HashMap<String, Object> rowData = new HashMap<String, Object>(dimensions.size());
        for (String d : dimensions) {
            rowData.put(d, row.get(d));
        }
        customParams.put("row", rowData);
        return customParams;
    }
}

