/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.report.sumv2.impl;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.fi.arapcommon.report.sumv2.transform.RemoveRefundantJournal;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.vo.SumRptParam;

public class JournalSumImpl {
    protected SumRptParam param;

    public JournalSumImpl(SumRptParam param) {
        this.param = param;
    }

    public void modifyBlock(SrcBlockConf blockConf) {
        QFilter filter = this.getSrcBlockFilter();
        QFilter dataFs = blockConf.getDataFs();
        if (dataFs != null) {
            filter.and(dataFs);
        }
        blockConf.setDataFs(filter);
        blockConf.setAllowNotMatch(true);
        blockConf.getDataTransform().add(new RemoveRefundantJournal(this.param));
    }

    private QFilter getSrcBlockFilter() {
        QFilter filter = new QFilter("bizdate", "<=", (Object)this.param.getStopDate());
        Date minCloseDate = this.param.getMinCloseDate();
        if (minCloseDate != null) {
            QFilter startDateFilter = new QFilter("bizdate", ">", (Object)DateUtils.getDataFormat(minCloseDate, false));
            filter.and(startDateFilter);
        }
        List<String> journalSourceEntityTypes = this.getJournalSourceEntityTypes();
        filter.and("sourcebilltype", "in", journalSourceEntityTypes);
        return filter;
    }

    private List<String> getJournalSourceEntityTypes() {
        LinkedList<String> journalSourceEntityTypes = new LinkedList<String>();
        String billScope = this.param.getBillScope();
        boolean apSys = this.param.isApSys();
        if (apSys) {
            journalSourceEntityTypes.add("ap_adjexchbill");
            if ("ALL".equals(billScope)) {
                journalSourceEntityTypes.add("ap_finapbill");
                journalSourceEntityTypes.add("ap_settlerecord");
                journalSourceEntityTypes.add("ar_settlerecord");
                journalSourceEntityTypes.add("ap_busbill");
            } else if ("ap_finapbill".equals(billScope)) {
                journalSourceEntityTypes.add("ap_finapbill");
                journalSourceEntityTypes.add("ap_settlerecord");
                journalSourceEntityTypes.add("ar_settlerecord");
            } else if ("ap_busbill".equals(billScope)) {
                journalSourceEntityTypes.add("ap_busbill");
            } else {
                throw new KDBizException("Unknow Report Data Source " + billScope);
            }
            if (this.param.isContainsPrepaid()) {
                journalSourceEntityTypes.add("cas_paybill");
                journalSourceEntityTypes.add("ap_paidbill");
            }
        } else {
            journalSourceEntityTypes.add("ar_adjustexchbill");
            if ("ALL".equals(billScope)) {
                journalSourceEntityTypes.add("ar_finarbill");
                journalSourceEntityTypes.add("ap_settlerecord");
                journalSourceEntityTypes.add("ar_settlerecord");
                journalSourceEntityTypes.add("ar_busbill");
            } else if ("ar_finarbill".equals(billScope)) {
                journalSourceEntityTypes.add("ar_finarbill");
                journalSourceEntityTypes.add("ap_settlerecord");
                journalSourceEntityTypes.add("ar_settlerecord");
            } else if ("ar_busbill".equals(billScope)) {
                journalSourceEntityTypes.add("ar_busbill");
            } else {
                throw new KDBizException("Unknow Report Data Source " + billScope);
            }
            if (this.param.isContainsPrepaid()) {
                journalSourceEntityTypes.add("cas_recbill");
                journalSourceEntityTypes.add("ar_receivedbill");
            }
        }
        return journalSourceEntityTypes;
    }
}

