/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.SettleEntryEnum;
import kd.fi.arapcommon.helper.SettleRecordQueryHelper;
import kd.fi.arapcommon.service.AbstractSettleTemplate;
import kd.fi.arapcommon.service.IAutoSettleService;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.vo.UnSettleParam;

public abstract class AbsAutoSettleService
implements IAutoSettleService {
    private static final Log logger = LogFactory.getLog(AbsAutoSettleService.class);
    @Deprecated
    private boolean isMain;

    @Override
    @Deprecated
    public void unAutoSettle(DynamicObject obj, boolean isMain) throws KDBizException {
        try (TXHandle tx = TX.required((String)"unautosettle");){
            try {
                this.isMain = isMain;
                this.unSettle4Main(obj);
                this.unSettle4Asst(obj);
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Override
    public void unAutoSettle(DynamicObject[] objs) throws KDBizException {
        if (objs.length == 0) {
            return;
        }
        try (TXHandle tx = TX.required((String)"unautosettle");){
            try {
                logger.info("AbsAutoSettleService.unSettle4Main batch start");
                this.unSettle4Main(objs);
                logger.info("AbsAutoSettleService.unSettle4Main batch end");
                logger.info("AbsAutoSettleService.unSettle4Asst batch start");
                this.unSettle4Asst(objs);
                logger.info("AbsAutoSettleService.unSettle4Asst batch end");
            }
            catch (Exception e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    @Deprecated
    protected void unSettle4Main(DynamicObject obj) {
        this.unSettle4Main(new DynamicObject[]{obj});
    }

    protected void unSettle4Main(DynamicObject[] objs) {
        List billIds = Arrays.stream(objs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("mainbillid", "in", billIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] results = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)CommonSettleServiceHelper.getSettleRecordSelector(), (QFilter[])filter.toArray());
        if (results != null && results.length > 0) {
            ArrayList<DynamicObject> detailSettleRecords = new ArrayList<DynamicObject>(results.length);
            ArrayList<DynamicObject> planSettleRecords = new ArrayList<DynamicObject>(results.length);
            for (DynamicObject settleRecord : results) {
                int settleModel = settleRecord.getInt("settleentry");
                if (SettleEntryEnum.DETAIL.getValue() == settleModel) {
                    detailSettleRecords.add(settleRecord);
                    continue;
                }
                planSettleRecords.add(settleRecord);
            }
            if (detailSettleRecords.size() > 0) {
                this.unSettleByMain(detailSettleRecords);
            }
            if (planSettleRecords.size() > 0) {
                this.unSettleByMain(planSettleRecords);
            }
        }
    }

    private void unSettleByMain(List<DynamicObject> settleRecords) {
        Map<String, List<DynamicObject>> map = SettleRecordOpHelper.classfySettleRecord(settleRecords.toArray(new DynamicObject[0]));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String key = entry.getKey();
            AbstractSettleTemplate service = this.getSettleService(key);
            service.unSettle(entry.getValue().toArray(new DynamicObject[0]), false);
        }
    }

    @Deprecated
    protected void unSettle4Asst(DynamicObject obj) {
        this.unSettle4Asst(new DynamicObject[]{obj});
    }

    protected void unSettle4Asst(DynamicObject[] objs) {
        List<Long> billIds = Arrays.stream(objs).map(obj -> obj.getLong("id")).collect(Collectors.toList());
        if (billIds.size() == 0) {
            return;
        }
        QFilter filter = new QFilter("entry.billid", "in", billIds);
        filter.and("iswrittenoff", "=", (Object)Boolean.FALSE).and("hadwrittenoff", "=", (Object)Boolean.FALSE);
        DynamicObject[] settleRecords = SettleRecordQueryHelper.getSettleRecords("ap_settlerecord", CommonSettleServiceHelper.getSettleRecordSelector(), objs[0].getDataEntityType().getName(), billIds.toArray(), filter);
        List<DynamicObject> settleRecordList = Arrays.stream(settleRecords).collect(Collectors.toList());
        Iterator settleRecordItr = settleRecordList.iterator();
        while (settleRecordItr.hasNext()) {
            boolean isRemove = false;
            DynamicObject settleRecord = (DynamicObject)settleRecordItr.next();
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Long asstBillId = entry.getLong("billid");
                boolean hadWriteOff = entry.getBoolean("e_hadwrittenoff");
                if (!hadWriteOff || !billIds.contains(asstBillId)) continue;
                isRemove = true;
                break;
            }
            if (!isRemove) continue;
            settleRecordItr.remove();
        }
        settleRecords = settleRecordList.toArray(new DynamicObject[0]);
        if (settleRecords.length == 0) {
            return;
        }
        ArrayList<DynamicObject> detailSettleRecords = new ArrayList<DynamicObject>(settleRecords.length);
        ArrayList<DynamicObject> planSettleRecords = new ArrayList<DynamicObject>(settleRecords.length);
        for (DynamicObject settleRecord : settleRecords) {
            int settleModel = settleRecord.getInt("settleentry");
            if (SettleEntryEnum.DETAIL.getValue() == settleModel) {
                detailSettleRecords.add(settleRecord);
                continue;
            }
            planSettleRecords.add(settleRecord);
        }
        if (detailSettleRecords.size() > 0) {
            this.unSettleByAsst(detailSettleRecords, billIds);
        }
        if (planSettleRecords.size() > 0) {
            this.unSettleByAsst(planSettleRecords, billIds);
        }
    }

    private void unSettleByAsst(List<DynamicObject> settleRecords, List<Long> billIds) {
        ArrayList<DynamicObject> wholeNeedDeleteRecords = new ArrayList<DynamicObject>(settleRecords.size());
        ArrayList<DynamicObject> partNeedDeleteRecords = new ArrayList<DynamicObject>(settleRecords.size());
        for (DynamicObject result : settleRecords) {
            boolean isWhole = true;
            DynamicObjectCollection entries = result.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long asstBillId = entry.getLong("billid");
                if (billIds.contains(asstBillId)) continue;
                isWhole = false;
                break;
            }
            if (isWhole) {
                wholeNeedDeleteRecords.add(result);
                continue;
            }
            partNeedDeleteRecords.add(result);
        }
        if (wholeNeedDeleteRecords.size() > 0) {
            this.resolveWholeNeedDeleteRecord(wholeNeedDeleteRecords);
        }
        if (partNeedDeleteRecords.size() > 0) {
            this.resolvePartNeedDeleteRecord(partNeedDeleteRecords, billIds);
        }
    }

    public abstract AbstractSettleTemplate getSettleService(String var1);

    private void resolveWholeNeedDeleteRecord(List<DynamicObject> wholeNeedDeleteRecords) {
        if (wholeNeedDeleteRecords.size() == 0) {
            return;
        }
        Map<String, List<DynamicObject>> map = SettleRecordOpHelper.classfySettleRecord(wholeNeedDeleteRecords.toArray(new DynamicObject[0]));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String key = entry.getKey();
            AbstractSettleTemplate service = this.getSettleService(key);
            service.unSettle(entry.getValue().toArray(new DynamicObject[0]), false);
        }
    }

    private void resolvePartNeedDeleteRecord(List<DynamicObject> partNeedDeleteRecords, List<Long> billIds) {
        DynamicObjectCollection entries;
        if (partNeedDeleteRecords.size() == 0) {
            return;
        }
        for (DynamicObject partNeedDeleteRecord : partNeedDeleteRecords) {
            long mainCurrency = partNeedDeleteRecord.getLong("maincurrency.id");
            entries = partNeedDeleteRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                long asstCurrency = entry.getLong("currency.id");
                if (mainCurrency != asstCurrency) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u5df2\u8fdb\u884c\u5f02\u5e01\u79cd\u7ed3\u7b97\uff0c\u4e0d\u5141\u8bb8\u6267\u884c\u6b64\u53cd\u64cd\u4f5c\uff0c\u8bf7\u7ed3\u7b97\u8bb0\u5f55\u5148\u8fdb\u884c\u53cd\u7ed3\u7b97\u540e\u91cd\u8bd5\u3002", (String)"AbsAutoSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                boolean hadWriteOff = entry.getBoolean("e_hadwrittenoff");
                if (!hadWriteOff) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u53cd\u64cd\u4f5c\u65f6\u5b58\u5728\u4e00\u5bf9\u591a\u7684\u7ed3\u7b97\u8bb0\u5f55\u7684\u8f85\u65b9\u5b58\u5728\u88ab\u7ea2\u51b2\u7684\u5206\u5f55\uff0c\u4e0d\u5141\u8bb8\u53cd\u64cd\u4f5c\uff0c\u8bf7\u5148\u5220\u9664\u5bf9\u5e94\u7684\u7ea2\u51b2\u7ed3\u7b97\u8bb0\u5f55\uff0c\u518d\u6267\u884c\u53cd\u64cd\u4f5c\u3002", (String)"AbsAutoSettleService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        ArrayList<DynamicObject> partRecordsTemp = new ArrayList<DynamicObject>(partNeedDeleteRecords.size());
        CloneUtils clone = new CloneUtils(false, false);
        for (DynamicObject settleRecord : partNeedDeleteRecords) {
            partRecordsTemp.add((DynamicObject)clone.clone((IDataEntityBase)settleRecord));
        }
        for (DynamicObject partRecord : partNeedDeleteRecords) {
            entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            while (iterator.hasNext()) {
                DynamicObject entry;
                entry = (DynamicObject)iterator.next();
                Long asstBillId = entry.getLong("billid");
                if (billIds.contains(asstBillId)) continue;
                iterator.remove();
            }
        }
        this.repairSettleRecordMainData(partNeedDeleteRecords);
        Map<String, List<DynamicObject>> map = SettleRecordOpHelper.classfySettleRecord(partNeedDeleteRecords.toArray(new DynamicObject[0]));
        for (Map.Entry<String, List<DynamicObject>> entry : map.entrySet()) {
            String key = entry.getKey();
            AbstractSettleTemplate service = this.getSettleService(key);
            UnSettleParam unSettleParam = new UnSettleParam();
            unSettleParam.setUnSettleByListOP(false);
            unSettleParam.setRedSettleRecord(true);
            service.unSettle(entry.getValue().toArray(new DynamicObject[0]), unSettleParam);
        }
        for (DynamicObject partRecord : partRecordsTemp) {
            DynamicObjectCollection entries2 = partRecord.getDynamicObjectCollection("entry");
            Iterator eItr = entries2.iterator();
            while (eItr.hasNext()) {
                DynamicObject entry = (DynamicObject)eItr.next();
                Long asstBillId = entry.getLong("billid");
                if (!billIds.contains(asstBillId)) continue;
                eItr.remove();
            }
        }
        this.repairSettleRecordMainData(partRecordsTemp);
        SettleRecordOpHelper.updateSettleRecord(partRecordsTemp.toArray(new DynamicObject[0]));
    }

    private void repairSettleRecordMainData(List<DynamicObject> partRecords) {
        for (DynamicObject partRecord : partRecords) {
            DynamicObjectCollection entries = partRecord.getDynamicObjectCollection("entry");
            Iterator iterator = entries.iterator();
            BigDecimal tempSettleAmt = BigDecimal.ZERO;
            BigDecimal tempSettleLocalAmt = BigDecimal.ZERO;
            BigDecimal tempSwapL = BigDecimal.ZERO;
            while (iterator.hasNext()) {
                DynamicObject entry = (DynamicObject)iterator.next();
                tempSettleAmt = tempSettleAmt.add(entry.getBigDecimal("settleamt"));
                tempSettleLocalAmt = tempSettleLocalAmt.add(entry.getBigDecimal("localsettleamt"));
                tempSwapL = tempSwapL.add(entry.getBigDecimal("e_swappl"));
            }
            partRecord.set("totalsettleamt", (Object)tempSettleAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("totalsettleamt").signum())));
            partRecord.set("localtotalsettleamt", (Object)tempSettleLocalAmt.abs().multiply(new BigDecimal(partRecord.getBigDecimal("localtotalsettleamt").signum())));
            partRecord.set("swappl", (Object)tempSwapL.abs().multiply(new BigDecimal(partRecord.getBigDecimal("swappl").signum())));
        }
    }

    protected void addSettleLock(DynamicObject[] mains, DynamicObject[] assts) {
        if (ObjectUtils.isEmpty((Object[])mains) || ObjectUtils.isEmpty((Object[])assts)) {
            return;
        }
        String mainBillEntity = mains[0].getDataEntityType().getName();
        Set<Long> mainIdSet = Arrays.stream(mains).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        String asstBillEntity = assts[0].getDataEntityType().getName();
        Set<Long> asstIdSet = Arrays.stream(assts).map(entity -> entity.getLong("id")).collect(Collectors.toSet());
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainIdSet, mainBillEntity, asstIdSet, asstBillEntity, true);
    }
}

