/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.excecontrol.ExecCtrlHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.service.helper.CommonSettleServiceHelper;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.service.helper.SettleRecordOpHelper;
import kd.fi.arapcommon.vo.BillSettleVO;
import kd.fi.arapcommon.vo.SettleRecordEntryVO;
import kd.fi.arapcommon.vo.SettleRecordVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.UnSettleParam;

public abstract class AbstractSettleTemplate {
    protected static final Log logger = LogFactory.getLog(AbstractSettleTemplate.class);
    protected SettleSchemeVO scheme;

    public final void settle(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO settleScheme, String settleType) {
        if (mains != null && mains.length > 0 && assts != null && assts.length > 0) {
            Throwable throwable = null;
            try (TXHandle tx = TX.required((String)"settle");){
                logger.info("----settle\u7ed3\u7b97\u5f00\u59cb----");
                long start = System.currentTimeMillis();
                this.scheme = settleScheme;
                this.scheme.setSettleRelation(this.getSettleRelation());
                List<BillSettleVO> mainList = this.getMainListVO(mains);
                List<BillSettleVO> asstList = this.getAsstListVO(assts);
                settleScheme.setSettle(true);
                SettleLogHelper.logBeginSettle(mainList, asstList, this.getSettleRelation(), this.scheme, settleType);
                if (mainList.size() == 0 || asstList.size() == 0) {
                    return;
                }
                try {
                    ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0003", null, mainList, asstList, Boolean.TRUE);
                    List<SettleRecordVO> resultList = this.doSettle(mainList, asstList, this.scheme, settleType);
                    this.processResultList(resultList);
                    SettleLogHelper.logSettleRecord(resultList);
                    this.afterSettle(resultList, this.scheme);
                    BizExtendHelper.invokeAfterSettleCallback(resultList, this.scheme);
                    this.afterSettleValidator(mainList, asstList, this.scheme);
                    long end = System.currentTimeMillis();
                    logger.info("----settle\u7ed3\u7b97\u7ed3\u675f----\u8017\u65f6(ms):" + (end - start));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    logger.error(e);
                    throw e;
                }
            }
        }
    }

    public final void settleByVO(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO scheme, String settleType) {
        if (mainList != null && asstList != null && mainList.size() > 0 && asstList.size() > 0) {
            try (TXHandle tx = TX.required((String)"settleByVO");){
                try {
                    logger.info("----settleByVO\u7ed3\u7b97\u5f00\u59cb----");
                    long start = System.currentTimeMillis();
                    this.scheme = scheme;
                    scheme.setSettleRelation(this.getSettleRelation());
                    SettleLogHelper.logBeginSettle(mainList, asstList, this.getSettleRelation(), scheme, settleType);
                    ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0003", null, mainList, asstList, Boolean.TRUE);
                    List<SettleRecordVO> resultList = this.doSettle(mainList, asstList, scheme, settleType);
                    SettleLogHelper.logSettleRecord(resultList);
                    this.processResultList(resultList);
                    this.afterSettle(resultList, scheme);
                    BizExtendHelper.invokeAfterSettleCallback(resultList, scheme);
                    ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0003", null, mainList, asstList, Boolean.FALSE);
                    long end = System.currentTimeMillis();
                    logger.info("----settle\u7ed3\u7b97\u7ed3\u675f----\u8017\u65f6(ms):" + (end - start));
                }
                catch (Throwable e) {
                    tx.markRollback();
                    logger.error(e);
                    throw e;
                }
            }
        }
    }

    protected void processResultList(List<SettleRecordVO> resultList) {
        if (ObjectUtils.isEmpty(resultList)) {
            return;
        }
        if (this.scheme.isManual() && this.scheme.getSettleDate() != null) {
            for (SettleRecordVO vo : resultList) {
                vo.setSettleDate(this.scheme.getSettleDate());
            }
        }
    }

    protected abstract List<BillSettleVO> getMainListVO(DynamicObject[] var1);

    protected abstract List<BillSettleVO> getAsstListVO(DynamicObject[] var1);

    protected SettleSchemeVO getSettleSchemeVO(Object settleScheme) {
        SettleSchemeVO scheme = new SettleSchemeVO();
        if (settleScheme instanceof SettleSchemeVO) {
            scheme = (SettleSchemeVO)settleScheme;
        }
        scheme.setSettle(true);
        return scheme;
    }

    protected abstract List<SettleRecordVO> doSettle(List<BillSettleVO> var1, List<BillSettleVO> var2, SettleSchemeVO var3, String var4);

    protected abstract void afterSettle(List<SettleRecordVO> var1, SettleSchemeVO var2);

    public final void unSettle(DynamicObject[] results, boolean unSettleByListOP) {
        UnSettleParam param = new UnSettleParam();
        param.setUnSettleByListOP(unSettleByListOP);
        this.unSettle(results, param);
    }

    public void unSettle(DynamicObject[] results, UnSettleParam param) {
        if (results != null) {
            try (TXHandle tx = TX.required((String)"unsettle");){
                try {
                    logger.info("----unSettle\u53cd\u7ed3\u7b97\u5f00\u59cb----");
                    ArrayList<SettleRecordVO> srList = new ArrayList<SettleRecordVO>(64);
                    for (DynamicObject result : results) {
                        if ("fromeas".equals(result.getString("settletype"))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e3aEAS\u96c6\u6210\u7684\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"AbstractSettleTemplate_0", (String)"fi-arapcommon", (Object[])new Object[0]));
                        }
                        SettleRecordVO vo = this.getSettleRecordVO(result);
                        srList.add(vo);
                    }
                    ArrayList<SettleRecordEntryVO> srEntryList = new ArrayList<SettleRecordEntryVO>();
                    for (SettleRecordVO vo : srList) {
                        srEntryList.addAll(vo.getEntrys());
                    }
                    this.unsettleAddLock(srList, srEntryList);
                    SettleSchemeVO scheme = new SettleSchemeVO();
                    scheme.setSettle(false);
                    SettleRecordVO srVO = (SettleRecordVO)srList.get(0);
                    if (srVO.getMainPayableAmt().multiply(srVO.getTotalSettleAmt()).compareTo(BigDecimal.ZERO) < 0) {
                        scheme.setSettle(true);
                        for (SettleRecordVO settleRecordVO : srList) {
                            settleRecordVO.setTotalSettleAmt(settleRecordVO.getTotalSettleAmt().negate());
                            settleRecordVO.setLocalTotalSettleamt(settleRecordVO.getLocalTotalSettleamt().negate());
                        }
                        for (SettleRecordEntryVO settleRecordEntryVO : srEntryList) {
                            settleRecordEntryVO.setSettleAmt(settleRecordEntryVO.getSettleAmt().negate());
                        }
                    }
                    scheme.setSettleRelation(srVO.getSettleRela());
                    scheme.setOnlyByBotp("1".equals(srVO.getAutoSettleType()));
                    scheme.setUnSettleByListOP(param.isUnSettleByListOP());
                    scheme.setUnSettleByReturn(param.isUnSettleByReturn());
                    scheme.setUnSettleByWriteOff(param.isUnSettleByWriteOff());
                    SettleLogHelper.logUnSettle(srList, scheme);
                    this.batchDisposeMainBill(srList, scheme);
                    if (!SettleRelationEnum.APPAYSETTLE.getValue().equals(this.getSettleRelation()) || !"ApFin_prepay_BT_S".equals(((SettleRecordVO)srList.get(0)).getBillType())) {
                        this.disposeAsstBill(srEntryList, scheme);
                    }
                    if (!param.isRedSettleRecord()) {
                        SettleRecordOpHelper.deleteSettleRecord(results);
                    }
                    this.updateAutoSettleType(results, param);
                    BizExtendHelper.invokeAfterSettleCallback(srList, scheme);
                    ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0004", null, srList);
                    logger.info("----unSettle\u53cd\u7ed3\u7b97\u7ed3\u675f----");
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
        }
    }

    private void updateAutoSettleType(DynamicObject[] results, UnSettleParam param) {
        if (param.isUnSettleByListOP()) {
            DynamicObject[] records;
            HashSet<Long> mainbillids = new HashSet<Long>(8);
            HashSet asstBillIds = new HashSet(8);
            Set recordSet = Arrays.stream(results).filter(e -> "1".equals(e.getString("autosettletype"))).collect(Collectors.toSet());
            for (DynamicObject record : recordSet) {
                mainbillids.add(record.getLong("mainbillid"));
                asstBillIds.addAll(record.getDynamicObjectCollection("entry").stream().map(e -> e.getLong("billid")).collect(Collectors.toSet()));
            }
            for (DynamicObject record : records = BusinessDataServiceHelper.load((String)"ap_settlerecord", (String)"autosettletype", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", mainbillids), new QFilter("entry.billid", "in", asstBillIds)})) {
                record.set("autosettletype", (Object)"4");
            }
            SaveServiceHelper.update((DynamicObject[])records);
        }
    }

    protected abstract SettleRecordVO getSettleRecordVO(DynamicObject var1);

    public abstract void disposeMainBill(SettleRecordVO var1, SettleSchemeVO var2);

    public abstract void disposeAsstBill(List<SettleRecordEntryVO> var1, SettleSchemeVO var2);

    protected abstract String getSettleRelation();

    protected void batchDisposeMainBill(List<SettleRecordVO> voList, SettleSchemeVO scheme) {
    }

    protected void setScheme(SettleSchemeVO scheme) {
        this.scheme = scheme;
    }

    private void unsettleAddLock(List<SettleRecordVO> srList, List<SettleRecordEntryVO> srEntryList) {
        if (ObjectUtils.isEmpty(srList) || ObjectUtils.isEmpty(srEntryList)) {
            return;
        }
        String mainBillEntity = srList.get(0).getBillEntity();
        Set<Long> mainBillIds = srList.stream().map(SettleRecordVO::getMainBillId).collect(Collectors.toSet());
        String asstBillEntity = srEntryList.get(0).getBillEntity();
        Set<Long> asstBillIds = srEntryList.stream().map(SettleRecordEntryVO::getBillId).collect(Collectors.toSet());
        CommonSettleServiceHelper.settleAddMutexCtrlInTX(mainBillIds, mainBillEntity, asstBillIds, asstBillEntity, false);
    }

    private void afterSettleValidator(List<BillSettleVO> mainList, List<BillSettleVO> asstList, SettleSchemeVO settleScheme) {
        boolean premAutoSettle = settleScheme.isPremAutoSettle();
        boolean onlyByBotp = settleScheme.isOnlyByBotp();
        String settleRelation = settleScheme.getSettleRelation();
        Set asstIdSet = asstList.stream().map(BillSettleVO::getId).collect(Collectors.toSet());
        if (onlyByBotp) {
            if (premAutoSettle) {
                boolean isAr = "artranswar".equals(settleRelation);
                ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0072", null, asstIdSet, isAr);
            } else if (SettleRelationEnum.ARWRITEOFF.getValue().equals(settleRelation) || SettleRelationEnum.APWRITEOFF.getValue().equals(settleRelation)) {
                ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0073", null, asstIdSet, settleRelation);
            } else if (SettleRelationEnum.APPAYSETTLE.getValue().equals(settleRelation) || SettleRelationEnum.RECSETTLE.getValue().equals(settleRelation)) {
                ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0074", null, asstIdSet, settleRelation);
            }
        }
        ExecCtrlHelper.execCustomizeCtrlService("SZJK-PRE-0003", null, mainList, asstList, Boolean.FALSE);
    }
}

