/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.enums.VerifyRelationEnum;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.helper.VerifyLogHelper;
import kd.fi.arapcommon.vo.BillVerifyVO;
import kd.fi.arapcommon.vo.SettleSchemeVO;
import kd.fi.arapcommon.vo.UnVerifyParam;
import kd.fi.arapcommon.vo.VerifyRecordEntryVO;
import kd.fi.arapcommon.vo.VerifyRecordVO;

public abstract class AbstractVerifyTemplate {
    protected static final Log logger = LogFactory.getLog(AbstractVerifyTemplate.class);
    private static boolean callCalService = true;

    public final void verify(DynamicObject[] mains, DynamicObject[] assts, SettleSchemeVO scheme, String verifyType) {
        if (mains != null && mains.length > 0 && assts != null && assts.length > 0) {
            Throwable throwable = null;
            try (TXHandle tx = TX.required((String)"verify");){
                logger.info("----verify\u6838\u9500\u5f00\u59cb----");
                long start = System.currentTimeMillis();
                logger.info("AbstractVerifyTemplate\u4e3b\u65b9id\u662f" + mains[0].getLong("id"));
                List<BillVerifyVO> mainList = this.getMainListVO(mains);
                long end = System.currentTimeMillis();
                logger.info("getMainListVO spend " + (end - start));
                long start1 = System.currentTimeMillis();
                List<BillVerifyVO> asstList = this.getAsstListVO(assts);
                long end1 = System.currentTimeMillis();
                logger.info("getAsstListVO spend " + (end1 - start1));
                if (mainList == null || mainList.size() == 0) {
                    logger.info("----verify\u4e3b\u65b9\u5355\u636e\u4e0d\u5b58\u5728\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u7ec8\u6b62\u6838\u9500----");
                    return;
                }
                if (asstList == null || asstList.size() == 0) {
                    logger.info("----verify\u8f85\u65b9\u5355\u636e\u4e0d\u5b58\u5728\u7b26\u5408\u6761\u4ef6\u7684\u6570\u636e\uff0c\u7ec8\u6b62\u6838\u9500----");
                    return;
                }
                try {
                    VerifyLogHelper.logBeginVerify(mainList, asstList, this.getSettleRelation(), scheme, verifyType);
                    scheme.setSettle(true);
                    List<VerifyRecordVO> resultList = this.doVerify(mainList, asstList, scheme, verifyType);
                    VerifyLogHelper.logVerifyRecord(resultList);
                    this.afterVerify(resultList, scheme);
                    logger.info("----verify\u6838\u9500\u7ed3\u675f----");
                }
                catch (Throwable e) {
                    tx.markRollback();
                    logger.error(e);
                    throw e;
                }
            }
        }
    }

    public final void verifyByVO(List<BillVerifyVO> mainList, List<BillVerifyVO> asstList, SettleSchemeVO scheme, String verifyType) {
        if (mainList != null && asstList != null && mainList.size() > 0 && asstList.size() > 0) {
            try (TXHandle tx = TX.required((String)"verify");){
                try {
                    logger.info("----verifyByVO\u6838\u9500\u5f00\u59cb----");
                    VerifyLogHelper.logBeginVerify(mainList, asstList, this.getSettleRelation(), scheme, verifyType);
                    List<VerifyRecordVO> resultList = this.doVerify(mainList, asstList, scheme, verifyType);
                    VerifyLogHelper.logVerifyRecord(resultList);
                    this.afterVerify(resultList, scheme);
                    logger.info("----verifyByVO\u6838\u9500\u7ed3\u675f----");
                }
                catch (Exception e) {
                    tx.markRollback();
                    logger.error((Throwable)e);
                    throw e;
                }
            }
        }
    }

    protected abstract List<BillVerifyVO> getMainListVO(DynamicObject[] var1);

    protected abstract List<BillVerifyVO> getAsstListVO(DynamicObject[] var1);

    protected abstract List<VerifyRecordVO> doVerify(List<BillVerifyVO> var1, List<BillVerifyVO> var2, SettleSchemeVO var3, String var4);

    protected abstract void afterVerify(List<VerifyRecordVO> var1, SettleSchemeVO var2);

    public final void unVerify(DynamicObject[] results) {
        UnVerifyParam param = new UnVerifyParam();
        param.setRedVerifyRecord(false);
        this.unVerify(results, param);
    }

    public final void unVerify(DynamicObject[] results, UnVerifyParam param) {
        if (results != null && results.length > 0) {
            long start = System.currentTimeMillis();
            try (TXHandle tx = TX.required((String)"unverify");){
                try {
                    logger.info("----unVerify\u53cd\u6838\u9500\u5f00\u59cb----");
                    boolean isRedVerifyRecord = param.isRedVerifyRecord();
                    ArrayList<VerifyRecordVO> vrList = new ArrayList<VerifyRecordVO>(64);
                    for (DynamicObject result : results) {
                        DynamicObject[] vo = this.converDyn2VO(result);
                        vrList.add((VerifyRecordVO)vo);
                    }
                    VerifyLogHelper.logUnVerify(vrList);
                    ArrayList<VerifyRecordEntryVO> vrEntryList = new ArrayList<VerifyRecordEntryVO>();
                    for (VerifyRecordVO vo : vrList) {
                        vrEntryList.addAll(vo.getVrEntrys());
                    }
                    SettleSchemeVO scheme = new SettleSchemeVO();
                    scheme.setSettle(false);
                    scheme.setRedVerifyRecord(isRedVerifyRecord);
                    String verifyRelation = results[0].getString("verifyrelation");
                    if (!(isRedVerifyRecord || !callCalService || VerifyRelationEnum.ARFINSELF.getValue().equals(verifyRelation) || VerifyRelationEnum.APFINSELF.getValue().equals(verifyRelation) || VerifyRelationEnum.APPURRECED.getValue().equals(verifyRelation))) {
                        try {
                            logger.info(this.getCalPara());
                            long startTime = System.currentTimeMillis();
                            Map result = (Map)DispatchServiceHelper.invokeBizService((String)"fi", (String)"cal", (String)"CalCheckService", (String)"doService", (Object[])new Object[]{this.getCalPara(), null, results});
                            if (result != null && result.size() > 0) {
                                logger.info(result.toString());
                                StringBuilder errorMsg = new StringBuilder();
                                for (Map.Entry entry : result.entrySet()) {
                                    errorMsg.append(entry.getValue()).append("\r\n");
                                }
                                throw new KDBizException(errorMsg.toString());
                            }
                            long endTime = System.currentTimeMillis();
                            logger.info("unverify invoke CalBizService spends " + (endTime - startTime));
                        }
                        catch (KDBizException e) {
                            logger.error((Throwable)e);
                            throw e;
                        }
                        catch (Exception e) {
                            logger.error((Throwable)e);
                            throw e;
                        }
                    }
                    this.disposeMainBill(vrList, scheme);
                    this.disposeAsstBill(vrEntryList, scheme);
                    ArrayList<Long> verifyRecordIds = new ArrayList<Long>(results.length);
                    for (DynamicObject result : results) {
                        verifyRecordIds.add(result.getLong("id"));
                    }
                    if (!isRedVerifyRecord) {
                        OperationResult operationResult = OperationServiceHelper.executeOperate((String)"remove", (String)results[0].getDataEntityType().getName(), (Object[])verifyRecordIds.toArray(new Long[verifyRecordIds.size()]), (OperateOption)OperateOption.create());
                        OperationHelper.assertResult(operationResult);
                    }
                }
                catch (Exception e) {
                    logger.error((Throwable)e);
                    tx.markRollback();
                    throw e;
                }
                long end = System.currentTimeMillis();
                logger.info("unverify spends " + (end - start));
                logger.info("----unVerify\u53cd\u6838\u9500\u7ed3\u675f----");
            }
        }
    }

    protected abstract VerifyRecordVO converDyn2VO(DynamicObject var1);

    protected abstract void disposeAsstBill(List<VerifyRecordEntryVO> var1, SettleSchemeVO var2);

    protected abstract String getCalPara();

    protected abstract void disposeMainBill(List<VerifyRecordVO> var1, SettleSchemeVO var2);

    protected abstract String getSettleRelation();
}

