/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.helper.PeriodHelper;
import kd.fi.arapcommon.helper.SystemParameterHelper;
import kd.fi.arapcommon.journal.JournalService;
import kd.fi.arapcommon.service.adjustexch.AdjustExchHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class AdjExchService {
    protected static Log logger = LogFactory.getLog(AdjExchService.class);
    private String appName;
    private String beforePeriod = String.format(ResManager.loadKDString((String)"\u671f\u521d", (String)"AdjExchService_0", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]);
    public static final String AP_PARAMKEY = "ap_031";
    public static final String AR_PARAMKEY = "ar_031";

    public AdjExchService() {
    }

    public AdjExchService(String appName) {
        this.appName = appName;
    }

    private boolean isAr() {
        return "ar".equals(this.appName);
    }

    public StringBuffer insertAdjExchRecord(IDataModel m) {
        DynamicObjectCollection orgInfos = (DynamicObjectCollection)m.getValue("orgs");
        LinkedList<DynamicObject> adjExchRecords = new LinkedList<DynamicObject>();
        StringBuffer tips = new StringBuffer();
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        for (DynamicObject orgBaseData : orgInfos) {
            DynamicObject org = orgBaseData.getDynamicObject("fbasedataid");
            Long orgId = (Long)org.getPkValue();
            orgIds.add(orgId);
        }
        Map<Long, Boolean> orgAndParamMap = this.getIsParticipateInAdjExchMap(orgIds);
        HashSet<Long> oldDataIds = new HashSet<Long>(orgInfos.size());
        for (DynamicObject orgBaseData : orgInfos) {
            Boolean isExist;
            DynamicObject org = orgBaseData.getDynamicObject("fbasedataid");
            Long orgId = (Long)org.getPkValue();
            Boolean IsParticipateInAdjExch = orgAndParamMap.get(orgId);
            if (IsParticipateInAdjExch == null || !IsParticipateInAdjExch.booleanValue()) {
                tips.append(org.getString("name"));
                tips.append('\n');
                continue;
            }
            DynamicObject adjExchRecord = BusinessDataServiceHelper.newDynamicObject((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"));
            adjExchRecord.set("org", (Object)org);
            adjExchRecord.set("basecurrency", this.isAr() ? m.getValue("currency") : m.getValue("standardcurrency"));
            adjExchRecord.set("exratetable", m.getValue("exratetable"));
            adjExchRecord.set("isadjexch", (Object)Boolean.FALSE);
            adjExchRecord.set("isperiod", (Object)Boolean.TRUE);
            adjExchRecord.set("listperiod", (Object)this.beforePeriod);
            DynamicObject startperiod = (DynamicObject)m.getValue("startperiod");
            if (startperiod != null) {
                Date adjExchDate = DateUtils.getLastDay(startperiod.getDate("begindate"), 1);
                adjExchRecord.set("adjexchdate", (Object)adjExchDate);
            }
            if (this.isAr()) {
                adjExchRecord.set("bizsystem", (Object)"AR");
            } else {
                adjExchRecord.set("bizsystem", (Object)"AP");
            }
            if ((isExist = this.validateAdjExchRecord(adjExchRecord, true, oldDataIds)).booleanValue()) continue;
            adjExchRecords.add(adjExchRecord);
        }
        if (EmptyUtils.isNotEmpty(oldDataIds)) {
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (Object[])oldDataIds.toArray(new Long[0]), (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                logger.info("------insertAdjExchRecord:operationResult.Message------" + deleteResult.getMessage());
                OperationHelper.assertResult(deleteResult);
            }
        }
        SaveServiceHelper.save((DynamicObject[])adjExchRecords.toArray(new DynamicObject[0]));
        return tips;
    }

    public Boolean validateAdjExchRecord(DynamicObject adjExchRecord, boolean isPeriod, Set<Long> oldDataIds) {
        Boolean key = Boolean.FALSE;
        DynamicObject org = adjExchRecord.getDynamicObject("org");
        Long periodId = 0L;
        if (!isPeriod) {
            periodId = (Long)adjExchRecord.getDynamicObject("period").getPkValue();
        }
        QFilter filter = new QFilter("org", "=", org.get("id"));
        QFilter periodfilter = new QFilter("period", "=", (Object)periodId);
        QFilter bizsystemfilter = new QFilter("bizsystem", "=", (Object)(this.isAr() ? "AR" : "AP"));
        DynamicObject validateData = BusinessDataServiceHelper.loadSingle((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (String)"id,basecurrency,exratetable,isadjexch", (QFilter[])new QFilter[]{filter, periodfilter, bizsystemfilter});
        if (EmptyUtils.isEmpty(validateData)) {
            return key;
        }
        if (validateData.getBoolean("isadjexch")) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\uff1a%s\u5df2\u8c03\u6c47\uff0c\u8bf7\u53d6\u6d88\u8c03\u6c47\u540e\u91cd\u8bd5\u3002", (String)"AdjExchService_1", (String)"fi-arapcommon", (Object[])new Object[]{org.getString("name")}), new Object[0]));
        }
        if (validateData.getDynamicObject("basecurrency").getPkValue().toString().equals(adjExchRecord.getDynamicObject("basecurrency").getPkValue().toString()) && validateData.getDynamicObject("exratetable").getPkValue().toString().equals(adjExchRecord.getDynamicObject("exratetable").getPkValue().toString())) {
            key = Boolean.TRUE;
        }
        if (!key.booleanValue()) {
            oldDataIds.add(validateData.getLong("id"));
        }
        return key;
    }

    public void insertAdjExchRecord(DynamicObject info, Boolean isInitClose) {
        DynamicObject[] adjExchRecord = new DynamicObject[]{BusinessDataServiceHelper.newDynamicObject((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"))};
        adjExchRecord[0].set("org", (Object)info.getDynamicObject("org"));
        adjExchRecord[0].set("basecurrency", (Object)info.getDynamicObject("standardcurrency"));
        adjExchRecord[0].set("exratetable", (Object)info.getDynamicObject("exratetable"));
        adjExchRecord[0].set("isadjexch", (Object)Boolean.FALSE);
        adjExchRecord[0].set("isperiod", (Object)Boolean.FALSE);
        if (isInitClose.booleanValue()) {
            adjExchRecord[0].set("period", (Object)info.getDynamicObject("curperiod"));
        } else {
            adjExchRecord[0].set("period", (Object)PeriodHelper.getNextPeriod((Long)info.getDynamicObject("curperiod").getPkValue()));
        }
        adjExchRecord[0].set("listperiod", (Object)adjExchRecord[0].getDynamicObject("period").getString("name"));
        if (this.isAr()) {
            adjExchRecord[0].set("bizsystem", (Object)"AR");
        } else {
            adjExchRecord[0].set("bizsystem", (Object)"AP");
        }
        if (!this.validateAdjExchRecord(adjExchRecord[0], false, new HashSet<Long>(8)).booleanValue()) {
            SaveServiceHelper.save((DynamicObject[])adjExchRecord);
        }
    }

    public List<String> cancelAdjValidate(DynamicObject org, DynamicObject period) {
        return this.cancelAdjValidate(org, period, false);
    }

    public List<String> cancelAdjValidate(DynamicObject org, DynamicObject period, boolean isAntiInit) {
        ArrayList<String> errorMessageList = new ArrayList<String>(8);
        logger.info("\u6821\u9a8c\u7684\u7ec4\u7ec7\uff1a%s\uff0c\u671f\u95f4id:%s, \u671f\u95f4\u540d\uff1a%s", new Object[]{org.getString("name"), EmptyUtils.isEmpty(period) ? "0L" : period.get("id"), EmptyUtils.isEmpty(period) ? "0L" : period.getString("name")});
        QFilter filter = new QFilter("org", "=", org.get("id"));
        QFilter periodfilter = new QFilter("period", "=", EmptyUtils.isEmpty(period) ? Long.valueOf(0L) : period.get("id"));
        QFilter bizSystemfilter = new QFilter("bizsystem", "=", (Object)(this.isAr() ? "AR" : "AP"));
        DynamicObject adjExchRecord = BusinessDataServiceHelper.loadSingle((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (String)"listperiod,isadjexch", (QFilter[])new QFilter[]{filter, periodfilter, bizSystemfilter});
        if (EmptyUtils.isEmpty(adjExchRecord)) {
            return errorMessageList;
        }
        Boolean isAdjExch = adjExchRecord.getBoolean("isadjexch");
        if (!isAdjExch.booleanValue()) {
            return errorMessageList;
        }
        QFilter isAdjExchFilter = new QFilter("isadjexch", "=", (Object)Boolean.TRUE);
        DynamicObject initData = BusinessDataServiceHelper.loadSingle((String)(this.isAr() ? "ar_init" : "ap_init"), (String)this.getSelectors(), (QFilter[])filter.toArray());
        DynamicObject[] lastPeriod = BusinessDataServiceHelper.load((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (String)"org,period", (QFilter[])new QFilter[]{filter, isAdjExchFilter, bizSystemfilter}, (String)"period desc", (int)1);
        if (EmptyUtils.isEmpty(lastPeriod)) {
            return errorMessageList;
        }
        DynamicObject lastPeriodDO = lastPeriod[0].getDynamicObject("period");
        if (EmptyUtils.isEmpty(period)) {
            if (isAntiInit) {
                if (EmptyUtils.isNotEmpty(lastPeriodDO) && !PeriodHelper.identical(lastPeriodDO, initData.getDynamicObject("curperiod"))) {
                    errorMessageList.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5176\u4ed6\u671f\u95f4\u8c03\u6c47\u5355\u65f6\uff0c\u4e0d\u80fd\u53d6\u6d88\u671f\u521d\u8c03\u6c47\uff1b", (String)"AdjExchService_2", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
                }
            } else if (EmptyUtils.isNotEmpty(lastPeriodDO)) {
                errorMessageList.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5176\u4ed6\u671f\u95f4\u8c03\u6c47\u5355\u65f6\uff0c\u4e0d\u80fd\u53d6\u6d88\u671f\u521d\u8c03\u6c47\uff1b", (String)"AdjExchService_2", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
        } else {
            Boolean isAfterCurrentPeriod = PeriodHelper.before(period, initData.getDynamicObject("curperiod"));
            if (isAfterCurrentPeriod.booleanValue()) {
                errorMessageList.add(String.format(ResManager.loadKDString((String)"\u5df2\u7ed3\u8d26\u671f\u95f4\u4e0b\u7684\u8c03\u6c47\u5355\u4e0d\u53ef\u53d6\u6d88\u3002", (String)"AdjExchService_3", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
            if (!PeriodHelper.identical(period, lastPeriodDO)) {
                errorMessageList.add(String.format(ResManager.loadKDString((String)"\u53d6\u6d88\u8c03\u6c47\u8981\u6309\u671f\u95f4\u4ece\u540e\u5f80\u524d\u4f9d\u6b21\u53d6\u6d88\uff1b", (String)"AdjExchService_4", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
            }
        }
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue()).and(new QFilter("bizsystem", "=", (Object)(this.isAr() ? "AR" : "AP")));
        QFilter dateFilter = new QFilter("period", "=", EmptyUtils.isEmpty(period) ? Long.valueOf(0L) : period.getPkValue());
        QFilter isVoucherFilter = new QFilter("isvoucher", "=", (Object)Boolean.TRUE);
        boolean isVoucherAdjExchBillTap = QueryServiceHelper.exists((String)(this.isAr() ? "ar_adjustexchbill" : "ap_adjexchbill"), (QFilter[])new QFilter[]{orgFilter, dateFilter, isVoucherFilter});
        if (isVoucherAdjExchBillTap) {
            errorMessageList.add(String.format(ResManager.loadKDString((String)"\u5b58\u5728\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u8c03\u6c47\u5355\uff0c\u8bf7\u5220\u9664\u540e\u91cd\u8bd5\u3002", (String)"AdjExchService_5", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
        }
        return errorMessageList;
    }

    public Map<Long, Boolean> getIsParticipateInAdjExchMap(List<Long> orgIds) {
        Map<Long, Object> appParameter = SystemParameterHelper.batchGetAppParameter(this.isAr(), orgIds, this.isAr() ? AR_PARAMKEY : AP_PARAMKEY);
        HashMap<Long, Boolean> isParticipateInAdjExchMap = new HashMap<Long, Boolean>(appParameter.size());
        for (Map.Entry<Long, Object> entryMap : appParameter.entrySet()) {
            isParticipateInAdjExchMap.put(entryMap.getKey(), (Boolean)entryMap.getValue());
        }
        return isParticipateInAdjExchMap;
    }

    public Boolean getIsParticipateInAdjExch(Long orgId) {
        return this.isAr() ? (Boolean)SystemParameterHelper.getARAppParameter(orgId, AR_PARAMKEY) : (Boolean)SystemParameterHelper.getAPAppParameter(orgId, AP_PARAMKEY);
    }

    public void cancelAdj(DynamicObject org, DynamicObject period, Boolean isAdjExch) {
        logger.info("\u5220\u9664\u7684\u7ec4\u7ec7\uff1a%s\uff0c\u671f\u95f4id\uff1a%s\uff0c\u671f\u95f4\u540d\u79f0\uff1a%s\uff0c\u662f\u5426\u5220\u8c03\u6c47\u8bb0\u5f55\uff1a%s", new Object[]{org.getString("name"), EmptyUtils.isEmpty(period) ? "0L" : period.getPkValue(), EmptyUtils.isEmpty(period) ? "0L" : period.getString("name"), isAdjExch});
        QFilter orgFilter = new QFilter("org", "=", org.getPkValue());
        QFilter bizFilter = new QFilter("bizsystem", "=", (Object)(this.isAr() ? "AR" : "AP"));
        QFilter periodFilter = new QFilter("period", "=", EmptyUtils.isEmpty(period) ? Long.valueOf(0L) : period.getPkValue());
        DynamicObject[] adjExchBill = BusinessDataServiceHelper.load((String)(this.isAr() ? "ar_adjustexchbill" : "ap_adjexchbill"), (String)"id", (QFilter[])new QFilter[]{orgFilter, bizFilter, periodFilter});
        if (EmptyUtils.isNotEmpty(adjExchBill)) {
            Object[] adjExchBillIds = (Long[])Arrays.stream(adjExchBill).map(bill -> bill.getLong("id")).toArray(Long[]::new);
            JournalService journalService = new JournalService();
            journalService.deleteJournals(AdjustExchHelper.getAdjExchBillEntityName(this.isAr()), (Long[])adjExchBillIds);
            OperateOption option = OperateOption.create();
            option.setVariableValue("ishasright", "true");
            OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)AdjustExchHelper.getAdjExchBillEntityName(this.isAr()), (Object[])adjExchBillIds, (OperateOption)option);
            if (!deleteResult.isSuccess()) {
                logger.info("------adjexchbill:operationResult.Message------" + deleteResult.getMessage());
                OperationHelper.assertResult(deleteResult);
            }
        }
        DynamicObject adjExchRecord = BusinessDataServiceHelper.loadSingle((String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (String)"id,isadjexch,gainloss,adjexchmode", (QFilter[])new QFilter[]{orgFilter, bizFilter, periodFilter});
        if (!isAdjExch.booleanValue()) {
            if (EmptyUtils.isNotEmpty(adjExchRecord)) {
                OperateOption option = OperateOption.create();
                option.setVariableValue("ishasright", "true");
                OperationResult deleteResult = OperationServiceHelper.executeOperate((String)"delete", (String)(this.isAr() ? "ar_adjustexch" : "ap_adjustexch"), (Object[])new Long[]{adjExchRecord.getLong("id")}, (OperateOption)option);
                if (!deleteResult.isSuccess()) {
                    logger.info("------adjustexch:deleteResult.Message------" + deleteResult.getMessage());
                    OperationHelper.assertResult(deleteResult);
                }
            }
        } else if (EmptyUtils.isNotEmpty(adjExchRecord)) {
            adjExchRecord.set("isadjexch", (Object)Boolean.FALSE);
            adjExchRecord.set("gainloss", (Object)BigDecimal.ZERO);
            adjExchRecord.set("adjexchmode", null);
            SaveServiceHelper.update((DynamicObject)adjExchRecord);
        }
    }

    private String getSelectors() {
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("id");
        selectors.add("standardcurrency");
        selectors.add("exratetable");
        selectors.add("isfinishinit");
        selectors.add("startperiod");
        selectors.add("curperiod");
        return String.join((CharSequence)",", selectors);
    }

    public List<Long> getOrgIds(DynamicObject[] infos) {
        ArrayList<Long> orgIds = new ArrayList<Long>(8);
        for (DynamicObject info : infos) {
            Long orgId = (Long)info.getDynamicObject("org").getPkValue();
            orgIds.add(orgId);
        }
        return orgIds;
    }
}

