/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.CloneUtils;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.IDataEntityBase;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.botp.CRCondition;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.filter.FilterValue;
import kd.bos.entity.filter.SimpleFilterRow;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.fi.arapcommon.enums.SettleRelationEnum;

public class ArApSchemeSettleActionService {
    private static final Log logger = LogFactory.getLog(ArApSchemeSettleActionService.class);
    private static final Map<String, String> amountFieldMap = new HashMap<String, String>();

    public void schemeSettle(DynamicObject[] schemes, String billEntity, Set<String> billNos) {
        DynamicObjectCollection blueBills = QueryServiceHelper.query((String)billEntity, (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos), new QFilter(amountFieldMap.get(billEntity), ">", (Object)BigDecimal.ZERO)});
        Set<String> blueBillNos = blueBills.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
        DynamicObjectCollection redBills = QueryServiceHelper.query((String)billEntity, (String)"billno", (QFilter[])new QFilter[]{new QFilter("billno", "in", billNos), new QFilter(amountFieldMap.get(billEntity), "<", (Object)BigDecimal.ZERO)});
        Set<String> redBillNos = redBills.stream().map(e -> e.getString("billno")).collect(Collectors.toSet());
        CloneUtils clone = new CloneUtils(false, false);
        DynamicObject[] schemesCopy = new DynamicObject[schemes.length];
        for (int i = 0; i < schemes.length; ++i) {
            schemesCopy[i] = (DynamicObject)clone.clone((IDataEntityBase)schemes[i]);
        }
        if (blueBillNos.size() > 0) {
            logger.info("blueBillNos.size > 0");
            this.executeSettle(schemes, billEntity, blueBillNos, false);
        }
        if (redBillNos.size() > 0) {
            logger.info("redBillNos.size > 0");
            this.executeSettle(schemesCopy, billEntity, redBillNos, true);
        }
    }

    private SimpleFilterRow buildSimpleFilterRow(Set<String> billNos) {
        SimpleFilterRow simpleFilterRow = new SimpleFilterRow();
        simpleFilterRow.setFieldName("billno");
        simpleFilterRow.setCompareType("17");
        ArrayList<FilterValue> filterValue = new ArrayList<FilterValue>(billNos.size());
        for (String billNo : billNos) {
            FilterValue value = new FilterValue();
            value.setValue((Object)billNo);
            filterValue.add(value);
        }
        simpleFilterRow.setValue(filterValue);
        return simpleFilterRow;
    }

    private String getBillFilterTag(String billEntity, String settleRelation, boolean isRed) {
        if (ArApSchemeSettleActionService.getSelfSettleRelations().contains(settleRelation)) {
            if (isRed) {
                return "asstfilter_tag";
            }
            return "mainfilter_tag";
        }
        List<String> entitys = SettleRelationEnum.getEntityByRelation(settleRelation);
        if (billEntity.equals(entitys.get(0))) {
            return "mainfilter_tag";
        }
        if (billEntity.equals(entitys.get(1))) {
            return "asstfilter_tag";
        }
        return "";
    }

    private void executeSettle(DynamicObject[] schemes, String billEntity, Set<String> billNos, boolean isRed) {
        logger.info("ArApSchemeSettleActionService is begin and schemes.size:" + schemes.length);
        for (DynamicObject scheme : schemes) {
            DynamicObjectCollection ruleEntrys = scheme.getDynamicObjectCollection("ruleentry");
            Iterator rules = ruleEntrys.iterator();
            while (rules.hasNext()) {
                FilterCondition filterCondition;
                CRCondition formula;
                DynamicObject rule = (DynamicObject)rules.next();
                String settleRelation = rule.getString("settleRelation");
                String billFilterTag = this.getBillFilterTag(billEntity, settleRelation, isRed);
                if (StringUtils.isEmpty((String)billFilterTag)) {
                    rules.remove();
                    continue;
                }
                SimpleFilterRow simpleFilterRow = this.buildSimpleFilterRow(billNos);
                String billFilter = rule.getString(billFilterTag);
                if (StringUtils.isEmpty((String)billFilter)) {
                    formula = new CRCondition();
                    filterCondition = new FilterCondition();
                } else {
                    formula = (CRCondition)SerializationUtils.fromJsonString((String)billFilter, CRCondition.class);
                    filterCondition = formula.getFilterCondition();
                }
                filterCondition.addFilterRow(simpleFilterRow);
                formula.setFilterCondition(filterCondition);
                String exprission = SerializationUtils.toJsonString((Object)formula);
                rule.set(billFilterTag, (Object)exprission);
            }
            this.invokeSchemeSettleService(scheme);
        }
    }

    private void invokeSchemeSettleService(DynamicObject scheme) {
        String schemeEntity = scheme.getDataEntityType().getName();
        if ("ap_settlescheme".equals(schemeEntity)) {
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ap", (String)"ApSchemeSettleService", (String)"schemeSettle", (Object[])new Object[]{scheme});
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
        if ("ar_settlescheme".equals(schemeEntity)) {
            try {
                DispatchServiceHelper.invokeBizService((String)"fi", (String)"ar", (String)"ArSchemeSettleService", (String)"schemeSettle", (Object[])new Object[]{scheme});
            }
            catch (Exception e) {
                logger.error(e.getMessage());
            }
        }
    }

    private static List<String> getSelfSettleRelations() {
        ArrayList<String> SelfSettleRelations = new ArrayList<String>();
        SelfSettleRelations.add(SettleRelationEnum.APSELF.getValue());
        SelfSettleRelations.add(SettleRelationEnum.ARSELF.getValue());
        SelfSettleRelations.add(SettleRelationEnum.PAYSELF.getValue());
        SelfSettleRelations.add(SettleRelationEnum.RECSELF.getValue());
        return SelfSettleRelations;
    }

    static {
        amountFieldMap.put("ap_finapbill", "pricetaxtotal");
        amountFieldMap.put("ar_finarbill", "recamount");
        amountFieldMap.put("cas_paybill", "actpayamt");
        amountFieldMap.put("cas_recbill", "actrecamt");
    }
}

