/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import java.lang.reflect.Method;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.service.log.LogUtil;
import kd.fi.arapcommon.service.log.ServiceInvokeLog;
import net.sf.cglib.proxy.Callback;
import net.sf.cglib.proxy.Enhancer;
import net.sf.cglib.proxy.MethodInterceptor;
import net.sf.cglib.proxy.MethodProxy;

public class ArApServiceProxy
implements MethodInterceptor {
    private static Log logger = LogFactory.getLog(ArApServiceProxy.class);
    private Object target;
    private String serviceName;

    public ArApServiceProxy(Object target, String serviceName) {
        this.target = target;
        this.serviceName = serviceName;
    }

    public Object createObj() {
        Enhancer hancer = new Enhancer();
        hancer.setSuperclass(this.target.getClass());
        hancer.setCallback((Callback)this);
        hancer.setClassLoader(this.target.getClass().getClassLoader());
        return hancer.create();
    }

    public Object intercept(Object o, Method method, Object[] objects, MethodProxy methodProxy) throws Throwable {
        Object result;
        ServiceInvokeLog annotation = method.getAnnotation(ServiceInvokeLog.class);
        try {
            result = methodProxy.invokeSuper(o, objects);
        }
        catch (Throwable e) {
            if (annotation != null) {
                LogUtil.addInvokeErrorLog(this.serviceName, objects, e, true);
            }
            throw e;
        }
        if (annotation != null) {
            LogUtil.addInvokeLog(this.serviceName, objects, result, true);
        }
        return result;
    }
}

