/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.service;

import com.alibaba.fastjson.JSON;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.botp.runtime.BFRowId;
import kd.bos.entity.botp.runtime.BFRowLinkUpNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.BillStatusEnum;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;

public class ArApSuiteService {
    protected static Log logger = LogFactory.getLog(ArApSuiteService.class);
    private final String entityKey;
    private final BillModel billModel;
    private final Map<Long, Boolean> materialCache = new HashMap<Long, Boolean>(2);
    private final Map<Long, Tuple<Long, Long>> saloutMapping = new HashMap<Long, Tuple<Long, Long>>(2);
    private final Map<Long, Long> salout2CoreEntryMapping = new HashMap<Long, Long>(2);

    public ArApSuiteService(String entityKey) {
        this.entityKey = entityKey;
        this.billModel = BillModelFactory.getModel(entityKey);
    }

    public Map<String, List<Integer>> checkSuite(ExtendedDataEntity[] dataEntities) {
        ArrayList<DynamicObject> billList = new ArrayList<DynamicObject>(dataEntities.length);
        HashMap<String, List<Integer>> unSuiteMap = new HashMap<String, List<Integer>>(2);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            billList.add(dataEntity.getDataEntity());
        }
        Map<Long, BigDecimal> suiteQtyMap = this.getSuiteQtyMap(billList);
        if (suiteQtyMap == null) {
            return unSuiteMap;
        }
        for (ExtendedDataEntity dataEntity : dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            String billNo = dataEntity.getBillNo();
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject entry : entryColl) {
                BigDecimal maxBaseSuiteQty;
                Long coreBillEntryId;
                long entryid;
                Tuple<Long, Long> tuple;
                DynamicObject material = entry.getDynamicObject(this.billModel.E_MATERIAL);
                if (material == null || !this.materialCache.get(material.getLong("id")).booleanValue() || (tuple = this.saloutMapping.get(entryid = entry.getLong("id"))) == null) continue;
                Long srcEntryId = (Long)tuple.item2;
                if (entryid == 0L) {
                    srcEntryId = entry.getLong(this.billModel.E_SOURCEBILLENTRYID);
                }
                if ((coreBillEntryId = this.salout2CoreEntryMapping.get(srcEntryId)) == null || (maxBaseSuiteQty = suiteQtyMap.get(coreBillEntryId)) == null) continue;
                BigDecimal baseQty = entry.getBigDecimal(this.billModel.E_BASEUNITQTY);
                if (baseQty.signum() == 0 || baseQty.abs().compareTo(maxBaseSuiteQty.abs()) > 0) {
                    this.handleUnSuiteMap(unSuiteMap, billNo, entry);
                    continue;
                }
                maxBaseSuiteQty = maxBaseSuiteQty.subtract(baseQty);
                suiteQtyMap.put(coreBillEntryId, maxBaseSuiteQty);
            }
        }
        return unSuiteMap;
    }

    private void handleUnSuiteMap(Map<String, List<Integer>> unSuiteMap, String billNo, DynamicObject entry) {
        List<Integer> entrySeqs = unSuiteMap.get(billNo);
        if (entrySeqs == null) {
            entrySeqs = new ArrayList<Integer>(2);
        }
        entrySeqs.add(entry.getInt("seq"));
        unSuiteMap.put(billNo, entrySeqs);
    }

    public Map<Long, BigDecimal> getSuiteQtyMap(List<DynamicObject> billList) {
        Map invokeResult;
        String maxOutBaseQty = "maxOutBaseQty";
        String mainBillEntryId = "mainBillEntryId";
        logger.info("ArApSuiteService entityKey:" + this.entityKey);
        HashMap<Long, BigDecimal> oldSuiteQtySumMap = new HashMap<Long, BigDecimal>(2);
        List<Map<String, Object>> param = this.buildParam(billList, oldSuiteQtySumMap);
        if (param.isEmpty()) {
            logger.info("ArApSuiteService No Suite Bill!!!");
            return null;
        }
        TXHandle tx = TX.requiresNew((String)"ArApSuiteService");
        Iterator iterator = null;
        try {
            try {
                logger.info("ArApSuiteService invoke begin. Params:" + JSON.toJSONString(param));
                invokeResult = (Map)DispatchServiceHelper.invokeBizService((String)"scmc", (String)"im", (String)"InvKitService", (String)"getMaxBaseQty", (Object[])new Object[]{param});
                logger.info("ArApSuiteService invoke end. Result:" + JSON.toJSONString((Object)invokeResult));
            }
            catch (Exception e) {
                tx.markRollback();
                logger.error("ArApSuiteService invokeBizService e.getMessage:" + e.getMessage());
                throw e;
            }
        }
        catch (Throwable e) {
            iterator = e;
            throw e;
        }
        finally {
            if (tx != null) {
                if (iterator != null) {
                    try {
                        tx.close();
                    }
                    catch (Throwable e) {
                        ((Throwable)((Object)iterator)).addSuppressed(e);
                    }
                } else {
                    tx.close();
                }
            }
        }
        HashMap<Long, BigDecimal> suiteQtyMap = new HashMap<Long, BigDecimal>(invokeResult.size());
        if ("ar_finarbill".equals(this.entityKey)) {
            for (Map.Entry entry : invokeResult.entrySet()) {
                Map value = (Map)entry.getValue();
                BigDecimal apiQty = (BigDecimal)value.get(maxOutBaseQty);
                Long coreBillEntryId = (Long)value.get(mainBillEntryId);
                this.salout2CoreEntryMapping.put((Long)entry.getKey(), coreBillEntryId);
                if (suiteQtyMap.get(coreBillEntryId) != null) continue;
                BigDecimal oldSuiteQty = oldSuiteQtySumMap.computeIfAbsent(coreBillEntryId, v -> BigDecimal.ZERO);
                BigDecimal unVerifyBaseQty = apiQty.subtract(oldSuiteQty);
                suiteQtyMap.put(coreBillEntryId, unVerifyBaseQty);
            }
        } else {
            for (Map.Entry entry : invokeResult.entrySet()) {
                Long coreBillEntryId = (Long)((Map)entry.getValue()).get(mainBillEntryId);
                this.salout2CoreEntryMapping.put((Long)entry.getKey(), coreBillEntryId);
                suiteQtyMap.put(coreBillEntryId, (BigDecimal)((Map)entry.getValue()).get(maxOutBaseQty));
            }
        }
        logger.info("ArApSuiteService salout2CoreEntryMapping:" + JSON.toJSONString(this.salout2CoreEntryMapping));
        logger.info("ArApSuiteService VIPMSG suiteQtyMap:" + JSON.toJSONString(suiteQtyMap));
        return suiteQtyMap;
    }

    private List<Map<String, Object>> buildParam(List<DynamicObject> billList, Map<Long, BigDecimal> oldSuiteQtySumMap) {
        String billEntity = "billEntity";
        String billId = "billId";
        String billEntryId = "billEntryId";
        String salOutBillId = "salOutBillId";
        String salOutBillEntryId = "salOutBillEntryId";
        boolean isFinar = "ar_finarbill".equals(this.entityKey);
        boolean isBusar = "ar_busbill".equals(this.entityKey);
        ArrayList<Long> billIdList = new ArrayList<Long>(billList.size());
        ArrayList<Long> billEntryIdList = new ArrayList<Long>(billList.size());
        ArrayList<Long> coreBillIdList = new ArrayList<Long>(billList.size());
        ArrayList<Long> coreBillEntryIdList = new ArrayList<Long>(billList.size());
        ArrayList<DynamicObject> entryCheckList = new ArrayList<DynamicObject>(2);
        for (DynamicObject bill : billList) {
            if (isFinar && (bill.getBoolean("iswrittenoff") || bill.getBoolean("istransfer") || BillTypeConsts.ARFIN_BORROW.equals(bill.get("billtype.id"))) || isBusar && bill.getBoolean("isadjust")) continue;
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject entry : entryColl) {
                DynamicObject material = entry.getDynamicObject(this.billModel.E_MATERIAL);
                if (material == null) continue;
                Long materialid = material.getLong("id");
                Boolean isSuite = this.materialCache.get(materialid);
                if (isSuite == null) {
                    if (material.containsProperty("suite")) {
                        isSuite = material.getBoolean("suite");
                        this.materialCache.put(materialid, isSuite);
                    } else {
                        this.initMaterialCache(billList);
                        isSuite = this.materialCache.getOrDefault(materialid, false);
                    }
                }
                if (!isSuite.booleanValue()) continue;
                if (isFinar) {
                    Object coreBillType = entry.get(this.billModel.E_COREBILLTYPE);
                    Long coreBillEntryid = entry.getLong(this.billModel.E_COREBILLENTRYID);
                    Long coreBillId = entry.getLong(this.billModel.E_COREBILLID);
                    if (this.isNeedCheck(coreBillType, coreBillId, coreBillEntryid)) {
                        coreBillIdList.add(coreBillId);
                        coreBillEntryIdList.add(coreBillEntryid);
                    }
                    entryCheckList.add(entry);
                    long entryId = entry.getLong("id");
                    if ("im_saloutbill".equals(bill.get(this.billModel.HEAD_SOURCEBILLTYPE))) {
                        this.saloutMapping.put(entryId, (Tuple<Long, Long>)Tuple.create((Object)entry.getLong(this.billModel.E_SOURCEBILLID), (Object)entry.getLong(this.billModel.E_SOURCEBILLENTRYID)));
                        continue;
                    }
                    billIdList.add(bill.getLong("id"));
                    billEntryIdList.add(entryId);
                    continue;
                }
                if (!isBusar || !"im_saloutbill".equals(bill.get(this.billModel.HEAD_SOURCEBILLTYPE))) continue;
                entryCheckList.add(entry);
            }
        }
        if (isFinar) {
            List bfRowLinkUpNodes = BFTrackerServiceHelper.loadLinkUpNodes((String)this.entityKey, (String)this.billModel.ENTRY, (Long[])billIdList.toArray(new Long[0]), (Long[])billEntryIdList.toArray(new Long[0]), (OperateOption)OperateOption.create());
            if (bfRowLinkUpNodes != null && !bfRowLinkUpNodes.isEmpty()) {
                TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)"im_saloutbill", (String)"im_saloutbill");
                Long upTableId = tableDefine.getTableId();
                for (Long entryId : billEntryIdList) {
                    BFRowLinkUpNode entryNode;
                    List<BFRowLinkUpNode> sourceNodes;
                    Optional<BFRowLinkUpNode> entryNodeOptional = bfRowLinkUpNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getEntryId().compareTo(entryId) == 0).findFirst();
                    if (!entryNodeOptional.isPresent() || ObjectUtils.isEmpty(sourceNodes = this.findSourceEntryNodes(entryNode = entryNodeOptional.get(), upTableId, entryId))) continue;
                    BFRowId rowId = sourceNodes.get(0).getRowId();
                    this.saloutMapping.put(entryId, (Tuple<Long, Long>)Tuple.create((Object)rowId.getBillId(), (Object)rowId.getEntryId()));
                }
            }
            if (!coreBillEntryIdList.isEmpty()) {
                String baseUnitQtyKey = "entry.e_baseunitqty";
                DynamicObjectCollection oldBillColl = QueryServiceHelper.query((String)this.entityKey, (String)("id,billstatus,billtype,entry.id,entry.corebillid,entry.corebillentryid," + baseUnitQtyKey), (QFilter[])new QFilter[]{new QFilter("billstatus", "=", (Object)BillStatusEnum.AUDIT.getValue()), new QFilter("istransfer", "=", (Object)Boolean.FALSE), new QFilter("billtype", "!=", (Object)BillTypeConsts.ARFIN_BORROW), new QFilter("entry.corebillid", "in", coreBillIdList), new QFilter("entry.corebillentryid", "in", coreBillEntryIdList)});
                if (!oldBillColl.isEmpty()) {
                    for (DynamicObject oldBill : oldBillColl) {
                        long corebillentryid = oldBill.getLong("entry.corebillentryid");
                        BigDecimal baseUnitQty = oldBill.getBigDecimal(baseUnitQtyKey);
                        BigDecimal entryQty = oldSuiteQtySumMap.computeIfAbsent(corebillentryid, v -> BigDecimal.ZERO);
                        entryQty = entryQty.add(baseUnitQty);
                        oldSuiteQtySumMap.put(corebillentryid, entryQty);
                    }
                    logger.info("ArApSuiteService data on the way. oldSuiteQtySumMap:" + JSON.toJSONString(oldSuiteQtySumMap));
                }
            }
        }
        ArrayList<Map<String, Object>> params = new ArrayList<Map<String, Object>>(entryCheckList.size());
        for (DynamicObject entry : entryCheckList) {
            HashMap<String, Object> param = new HashMap<String, Object>(2);
            Object coreBillType = entry.get(this.billModel.E_COREBILLTYPE);
            Long coreBillEntryid = entry.getLong(this.billModel.E_COREBILLENTRYID);
            Long coreBillId = entry.getLong(this.billModel.E_COREBILLID);
            if (this.isNeedCheck(coreBillType, coreBillId, coreBillEntryid)) {
                param.put(billEntity, coreBillType);
                param.put(billId, coreBillId);
                param.put(billEntryId, coreBillEntryid);
            }
            Long entryId = entry.getLong("id");
            if (isFinar) {
                Tuple<Long, Long> tuple = this.saloutMapping.get(entryId);
                if (tuple == null) continue;
                param.put(salOutBillId, tuple.item1);
                param.put(salOutBillEntryId, tuple.item2);
                params.add(param);
                continue;
            }
            Long srcBillId = entry.getLong(this.billModel.E_SOURCEBILLID);
            Long srcBillEntryId = entry.getLong(this.billModel.E_SOURCEBILLENTRYID);
            this.saloutMapping.put(entryId, (Tuple<Long, Long>)Tuple.create((Object)srcBillId, (Object)srcBillEntryId));
            param.put(salOutBillId, srcBillId);
            param.put(salOutBillEntryId, srcBillEntryId);
            params.add(param);
        }
        return params;
    }

    private List<BFRowLinkUpNode> findSourceEntryNodes(BFRowLinkUpNode node, Long sMainTableId, Long entryId) {
        ArrayList<BFRowLinkUpNode> nodes = new ArrayList<BFRowLinkUpNode>(2);
        BFRowId rowId = node.getRowId();
        if (rowId.getMainTableId().compareTo(sMainTableId) == 0 && rowId.getEntryId().compareTo(entryId) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkUpNode sNode : node.getSNodes().values()) {
                nodes.addAll(this.findSourceEntryNodes(sNode, sMainTableId, entryId));
            }
        }
        return nodes;
    }

    private boolean isNeedCheck(Object coreBillType, Long coreBillId, Long coreBillEntryid) {
        return coreBillId != null && coreBillId != 0L && coreBillEntryid != null && coreBillEntryid != 0L && ("sm_salorder".equals(coreBillType) || "sm_returnapply".equals(coreBillType));
    }

    private void initMaterialCache(List<DynamicObject> billList) {
        HashSet<Long> idSet = new HashSet<Long>();
        for (DynamicObject bill : billList) {
            DynamicObjectCollection entryColl = bill.getDynamicObjectCollection(this.billModel.ENTRY);
            for (DynamicObject entry : entryColl) {
                DynamicObject material = entry.getDynamicObject(this.billModel.E_MATERIAL);
                if (material == null) continue;
                Long id = material.getLong("id");
                idSet.add(id);
            }
        }
        Map materialMap = BusinessDataServiceHelper.loadFromCache((String)"bd_material", (String)"id,suite", (QFilter[])new QFilter[]{new QFilter("id", "in", idSet)});
        for (DynamicObject material : materialMap.values()) {
            this.materialCache.put(material.getLong("id"), material.getBoolean("suite"));
        }
    }
}

